/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.util;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.jain.protocol.ip.sip.SipJainFactories;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.sip.parser.CharArray;
import com.ibm.ws.sip.parser.HeaderCreator;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import jain.protocol.ip.sip.ListeningPoint;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.RecordRouteHeader;
import jain.protocol.ip.sip.header.RouteHeader;
import jain.protocol.ip.sip.message.Message;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.regex.Pattern;

public class SIPStackUtil {
    private static final LogMgr c_logger = Log.get(SIPStackUtil.class);
    public static int s_ipCacheInitSize = 100;
    public static int s_ipCacheMaxSize = 1000;
    private static ThreadLocal<CharsBuffer> m_ibmClientAddressBuffers = new ThreadLocal();
    private static final String IBM_CLIENT_ADDRESS = "IBM-Client-Address";
    private static final String IPV4_REGEX = "^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$";
    private static final String IPV6_REGEX = "^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$";
    private static final String COMPRESSED_IPV6_REGEX = "^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$";
    private static final Pattern ipv4Validator = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");
    private static final Pattern ipv6Validator = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern compressedIPv6Validator = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private SIPStackUtil() {
    }

    public static List headerIteratorToList(HeaderIterator iter) {
        Vector<Header> retVal = new Vector<Header>(3);
        if (iter != null) {
            while (iter.hasNext()) {
                try {
                    retVal.add(iter.next());
                }
                catch (HeaderParseException e2) {
                    if (!c_logger.isTraceDebugEnabled()) continue;
                    c_logger.traceDebug((Object)null, "headerIteratorToList", e2.getMessage());
                }
                catch (NoSuchElementException e3) {
                    if (!c_logger.isTraceDebugEnabled()) continue;
                    c_logger.traceDebug((Object)null, "headerIteratorToList", e3.getMessage());
                }
            }
        }
        return retVal;
    }

    public static List getRouteHeaders(Message msg) throws SipParseException {
        ArrayList<RouteHeader> routeHeaders;
        if (msg.getRecordRouteHeaders() != null && msg.getRecordRouteHeaders().hasNext()) {
            routeHeaders = new ArrayList<RouteHeader>(3);
            HeaderIterator iter = msg.getRecordRouteHeaders();
            while (iter.hasNext()) {
                RecordRouteHeader recordRoute = (RecordRouteHeader)iter.next();
                RouteHeader route = SipJainFactories.getInstance().getHeaderFactory().createRouteHeader(recordRoute.getNameAddress());
                routeHeaders.add(route);
            }
        } else {
            HeaderIterator iter = msg.getHeaders("Route");
            routeHeaders = SIPStackUtil.headerIteratorToList(iter);
        }
        return routeHeaders;
    }

    public static String generateRandomString() {
        return String.valueOf(Math.random()).substring(2);
    }

    public static String generateCallIdentifier(String address) {
        if (address == null || address.trim().length() == 0) {
            return SIPStackUtil.generateRandomString();
        }
        return SIPStackUtil.generateRandomString() + "@" + address;
    }

    public static String getAsHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }

    public static String generateTag() {
        return SIPStackUtil.generateRandomString();
    }

    public static String generateBranchId() {
        int randomSize = 15;
        double exp = 1.0E15;
        long random = Math.round(Math.random() * 1.0E15);
        StringBuffer branchId = new StringBuffer(22);
        branchId.append("z9hG4bK");
        branchId.append(random);
        return branchId.toString();
    }

    public static String toHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }

    public static String getHostAddress(String host) {
        try {
            return InetAddressCache.getHostAddress(host);
        }
        catch (UnknownHostException e2) {
            return host;
        }
    }

    public static String getHostAddress(InetAddress address) {
        return InetAddressCache.getHostAddress(address);
    }

    public static boolean isSameHost(String host, String otherhost) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)SIPStackUtil.class, "isSameHost", host, otherhost);
        }
        boolean rc = false;
        String normalizedHost = SIPStackUtil.normalizedHostName(host);
        String normalizedOtherHost = SIPStackUtil.normalizedHostName(otherhost);
        if (normalizedHost != null && normalizedOtherHost != null) {
            rc = normalizedHost.equals(normalizedOtherHost);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(SIPStackUtil.class, "isSameHost", rc);
        }
        return rc;
    }

    private static String normalizedHostName(String host) {
        String returnValue;
        block6: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)SIPStackUtil.class, "normalizedHostName", (Object)String.valueOf(host));
            }
            returnValue = null;
            try {
                InetAddress address = InetAddressCache.getByName(host);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(SIPStackUtil.class, "normalizedHostName", "Address Cache returned : " + address);
                }
                returnValue = address.getCanonicalHostName();
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(SIPStackUtil.class, "normalizedHostName", "The canonical host name is : " + returnValue);
                }
            }
            catch (UnknownHostException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block6;
                c_logger.traceDebug(SIPStackUtil.class, "normalizedHostName", "Failed to get canonical host address : " + host);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(SIPStackUtil.class, "normalizedHostName", returnValue);
        }
        return returnValue;
    }

    public static SipURL parseNameAdressFromConfig(String nameAdress) throws SipParseException {
        try {
            String host = null;
            String port = null;
            String transport = null;
            if (nameAdress != null && nameAdress.length() > 0) {
                int doublequete = nameAdress.lastIndexOf(":");
                int rightSlash = nameAdress.lastIndexOf("/");
                if (doublequete == -1) {
                    if (rightSlash == -1) {
                        host = nameAdress;
                    } else {
                        host = nameAdress.substring(0, rightSlash);
                        transport = nameAdress.substring(rightSlash + 1, nameAdress.length());
                    }
                } else if (rightSlash == -1) {
                    host = nameAdress.substring(0, doublequete);
                    port = nameAdress.substring(doublequete + 1, nameAdress.length());
                } else {
                    host = nameAdress.substring(0, doublequete);
                    port = nameAdress.substring(doublequete + 1, rightSlash);
                    transport = nameAdress.substring(rightSlash + 1, nameAdress.length());
                }
            } else {
                host = SIPStackUtil.getLocalHost();
            }
            SipURL retVal = SipJainFactories.getInstance().getAddressFactory().createSipURL(host);
            if (port != null) {
                retVal.setPort(Integer.parseInt(port));
            }
            if (transport != null) {
                if (transport.equalsIgnoreCase("tls")) {
                    retVal.setScheme("sips");
                }
                retVal.setTransport(transport);
            }
            return retVal;
        }
        catch (Throwable t) {
            throw new SipParseException("could not parse listening point");
        }
    }

    public static ListeningPointImpl parseLPNameAdressFromConfig(String nameAdress) throws SipParseException {
        try {
            String transport;
            String port;
            String host;
            block15: {
                host = "";
                port = "";
                transport = "";
                if (nameAdress != null && nameAdress.length() > 0) {
                    int doublequete = nameAdress.lastIndexOf(":");
                    int rightSlash = nameAdress.lastIndexOf("/");
                    if (doublequete == -1) {
                        if (rightSlash == -1) {
                            try {
                                Integer.parseInt(nameAdress);
                                host = SIPStackUtil.getLocalHost();
                                port = nameAdress;
                                transport = "udp";
                            }
                            catch (NumberFormatException exp) {
                                if (nameAdress.equalsIgnoreCase("udp") || nameAdress.equalsIgnoreCase("tcp") || nameAdress.equalsIgnoreCase("tls")) {
                                    host = SIPStackUtil.getLocalHost();
                                    port = "5060";
                                    transport = nameAdress;
                                    break block15;
                                }
                                host = nameAdress;
                                port = "5060";
                                transport = "udp";
                            }
                        } else {
                            String param = nameAdress.substring(0, rightSlash);
                            try {
                                Integer.parseInt(param);
                                host = SIPStackUtil.getLocalHost();
                                port = param;
                            }
                            catch (NumberFormatException exp) {
                                host = param;
                                port = "5060";
                            }
                            transport = nameAdress.substring(rightSlash + 1, nameAdress.length());
                        }
                    } else if (rightSlash == -1) {
                        host = nameAdress.substring(0, doublequete);
                        port = nameAdress.substring(doublequete + 1, nameAdress.length());
                        transport = "udp";
                    } else {
                        host = nameAdress.substring(0, doublequete);
                        port = nameAdress.substring(doublequete + 1, rightSlash);
                        transport = nameAdress.substring(rightSlash + 1, nameAdress.length());
                    }
                } else {
                    host = SIPStackUtil.getLocalHost();
                    port = "5060";
                    transport = "udp";
                }
            }
            ListeningPointImpl retVal = new ListeningPointImpl(host, Integer.parseInt(port), transport);
            return retVal;
        }
        catch (Throwable t) {
            throw new SipParseException("could not parse listenning point");
        }
    }

    public static String getLocalHost() {
        try {
            return InetAddressCache.getHostAddress(InetAddress.getLocalHost());
        }
        catch (UnknownHostException e2) {
            return "127.0.0.1";
        }
    }

    public static void addIbmClientAddressHeader(Message message, ListeningPoint lpoint) throws IllegalArgumentException, SipParseException {
        SIPStackUtil.addIbmClientAddressHeader(message, null, lpoint);
    }

    public static void addIbmClientAddressHeader(Message message, SIPConnection connection, ListeningPoint lpoint) throws IllegalArgumentException, SipParseException {
        int remotePort;
        String remoteHost;
        CharsBuffer ibmClientAddressBuffer = m_ibmClientAddressBuffers.get();
        if (ibmClientAddressBuffer == null) {
            ibmClientAddressBuffer = new CharsBuffer();
            m_ibmClientAddressBuffers.set(ibmClientAddressBuffer);
        }
        if (message.getHeader(IBM_CLIENT_ADDRESS, true) != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(SIPStackUtil.class, "SIPStackUtil addIbmClientAddressHeader", "IBM-Client-Address already added");
            }
            return;
        }
        String localHost = lpoint.getHost();
        int localPort = lpoint.getPort();
        String transport = lpoint.getTransport();
        if (connection != null) {
            remoteHost = connection.getRemoteHost();
            remotePort = connection.getRemotePort();
        } else {
            remoteHost = localHost;
            remotePort = localPort;
        }
        ibmClientAddressBuffer.reset();
        ibmClientAddressBuffer.append(remoteHost).append(':').append(remotePort);
        ibmClientAddressBuffer.append(";local-address=");
        ibmClientAddressBuffer.append(localHost).append(':').append(localPort);
        ibmClientAddressBuffer.append(";").append(transport);
        char[] buffer = ibmClientAddressBuffer.getCharArray();
        int length = ibmClientAddressBuffer.getCharCount();
        CharArray array = CharArray.getFromPool(buffer, 0, length);
        HeaderImpl ibmClientAddressHeader = HeaderCreator.createHeader(IBM_CLIENT_ADDRESS);
        ibmClientAddressHeader.setValue(array);
        ibmClientAddressHeader.parse();
        message.addHeader(ibmClientAddressHeader, true);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(SIPStackUtil.class, "SIPStackUtil addIbmClientAddressHeader", "IBM-Client-Address: " + ibmClientAddressHeader);
        }
    }

    public static boolean isInet4Address(String inetAddress) {
        return ipv4Validator.matcher(inetAddress).matches();
    }

    public static boolean isInet6Address(String inetAddress) {
        return ipv6Validator.matcher(inetAddress).matches() || compressedIPv6Validator.matcher(inetAddress).matches();
    }

    public static boolean isIpAddress(String address) {
        return SIPStackUtil.isInet4Address(address) || SIPStackUtil.isInet6Address(address);
    }

    public static boolean isSameInetAddressType(String inetAddress1, String inetAddress2) {
        boolean retValue = false;
        if (inetAddress1 != null && inetAddress2 != null) {
            if (SIPStackUtil.isInet4Address(inetAddress1) && SIPStackUtil.isInet4Address(inetAddress2)) {
                retValue = true;
            } else if (SIPStackUtil.isInet6Address(inetAddress1) && SIPStackUtil.isInet6Address(inetAddress2)) {
                retValue = true;
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(SIPStackUtil.class, "isSameInetAddressType", "address1: " + inetAddress1 + ", address2: " + inetAddress2 + ", " + retValue);
        }
        return retValue;
    }
}

