/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transactions.ct;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.SipJainFactories;
import com.ibm.ws.jain.protocol.ip.sip.extensions.IbmRetransmissionIntervalHeader;
import com.ibm.ws.jain.protocol.ip.sip.extensions.IbmTransactionTimeoutHeader;
import com.ibm.ws.jain.protocol.ip.sip.message.RequestImpl;
import com.ibm.ws.sip.stack.dispatch.TimerEvent;
import com.ibm.ws.sip.stack.transaction.SIPStackConfiguration;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transactions.BranchMethodKey;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransactionHelper;
import com.ibm.ws.sip.stack.transaction.transactions.ct.SIPClientTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transactions.ct.SIPNonInviteClientTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transport.SIPTransportException;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.MaxForwardsHeader;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;

public class SIPInviteClientTransactionImpl
extends SIPClientTransactionImpl {
    public static final int STATE_CALLING = 0;
    private TimerA m_timerA;
    private TimerB m_timerB;
    private TimerD m_timerD;
    private int m_timerAvalue;
    private final int m_timerBvalue;
    private Response m_lastResponse;
    private Header _ibmDestinationHeader;
    public static final String DESTINATION_URI = "IBM-Destination";
    private static final String IBM_PO_HEADER = "IBM-PO";
    private Header _ibmPO;
    boolean outboundEnable;
    private static final LogMgr c_logger = Log.get(SIPInviteClientTransactionImpl.class);

    public SIPInviteClientTransactionImpl(SIPTransactionStack transactionStack, SipProvider provider, Request req, BranchMethodKey key, long transactionId) {
        block3: {
            super(transactionStack, provider, req, key, transactionId);
            this._ibmDestinationHeader = null;
            this._ibmPO = null;
            this.outboundEnable = ApplicationProperties.getProperties().getBoolean("enableSetOutboundIF");
            this.m_timerAvalue = SIPInviteClientTransactionImpl.getTimerA(req);
            this.m_timerBvalue = SIPInviteClientTransactionImpl.getTimerB(req);
            SIPNonInviteClientTransactionImpl.getTimerT2(req);
            try {
                this._ibmDestinationHeader = req.getHeader(DESTINATION_URI, true);
                this._ibmPO = req.getHeader(IBM_PO_HEADER, true);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "SIPInviteClientTransactionImpl", "extracted the IBM-PO header: " + this._ibmPO);
                }
            }
            catch (HeaderParseException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block3;
                c_logger.traceDebug(this, "SIPInviteClientTransactionImpl", "Failed to extract the IBM-Destination header");
            }
        }
    }

    @Override
    public synchronized void processRequest(Request sipRequest) throws SipParseException {
        try {
            String method = sipRequest.getMethod();
            switch (this.getState()) {
                case -1: {
                    this.setState(0);
                    this.sendRequestToTransport(sipRequest);
                    if (!this.isTransportReliable()) {
                        this.m_timerA = new TimerA(this, this.getCallId());
                        this.addTimerTask(this.m_timerA, this.m_timerAvalue);
                    }
                    this.m_timerB = new TimerB(this, this.getCallId());
                    this.addTimerTask(this.m_timerB, this.m_timerBvalue);
                    break;
                }
                case 0: {
                    if ("INVITE".equals(method)) {
                        this.sendRequestToTransport(sipRequest);
                        break;
                    }
                    if (!"ACK".equals(method)) break;
                    this.handleACK(sipRequest);
                    break;
                }
                case 1: {
                    this.handleACK(sipRequest);
                    break;
                }
                case 2: {
                    this.handleACK(sipRequest);
                }
            }
        }
        catch (SIPTransportException exp) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processRequest", "Exception in transport exception", exp);
            }
            this.prossesTransportError();
        }
    }

    @Override
    public synchronized void processResponse(Response sipResponse) throws SipParseException {
        this.m_lastResponse = sipResponse;
        switch (this.getState()) {
            case 0: {
                if (SIPTransactionHelper.isProvionalResponse(sipResponse.getStatusCode())) {
                    this.setState(1);
                    this.notCalling();
                    this.sendResponseToUA(sipResponse);
                    break;
                }
                if (SIPTransactionHelper.isOKFinalResponse(sipResponse.getStatusCode())) {
                    this.setFinalResponse(sipResponse);
                    this.destroyTransaction();
                    this.sendResponseToUA(sipResponse);
                    break;
                }
                if (!SIPTransactionHelper.isNonOkFinalResponse(sipResponse.getStatusCode())) break;
                this.setFinalResponse(sipResponse);
                this.sendAutomaticAckRequest();
                this.notCalling();
                this.setCompletedState();
                this.sendResponseToUA(sipResponse);
                break;
            }
            case 1: {
                if (SIPTransactionHelper.isProvionalResponse(sipResponse.getStatusCode())) {
                    this.sendResponseToUA(sipResponse);
                    break;
                }
                if (SIPTransactionHelper.isOKFinalResponse(sipResponse.getStatusCode())) {
                    this.setFinalResponse(sipResponse);
                    this.destroyTransaction();
                    this.sendResponseToUA(sipResponse);
                    break;
                }
                if (!SIPTransactionHelper.isNonOkFinalResponse(sipResponse.getStatusCode())) break;
                this.setFinalResponse(sipResponse);
                this.setCompletedState();
                this.sendAutomaticAckRequest();
                this.sendResponseToUA(sipResponse);
                break;
            }
            case 2: {
                if (!SIPTransactionHelper.isNonOkFinalResponse(sipResponse.getStatusCode())) break;
                this.sendAutomaticAckRequest();
            }
        }
    }

    private void handleACK(Request sipRequest) throws SIPTransportException {
        this.sendRequestToTransport(sipRequest);
        this.setCompletedState();
    }

    private synchronized void setCompletedState() {
        if (this.isTransportReliable()) {
            this.destroyTransaction();
        } else {
            this.setState(2);
            long delay = this.getParentStack().getConfiguration().getTimerD();
            this.m_timerD = new TimerD(this, this.getCallId());
            this.addTimerTask(this.m_timerD, delay);
        }
    }

    private static int getTimerA(Request request) {
        int timerValue;
        block4: {
            timerValue = -1;
            try {
                IbmRetransmissionIntervalHeader header = (IbmRetransmissionIntervalHeader)request.getHeader("IBM-RetransmissionInterval", true);
                if (header != null && header.applicationCreated()) {
                    timerValue = header.getTimeValue();
                    request.removeHeader("IBM-RetransmissionInterval", true);
                }
            }
            catch (HeaderParseException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block4;
                c_logger.traceDebug(SIPInviteClientTransactionImpl.class, "getTimerA", "error getting header [IBM-RetransmissionInterval] in message\r\n" + request, e2);
            }
        }
        if (timerValue == -1) {
            SIPStackConfiguration config = SIPTransactionStack.instance().getConfiguration();
            timerValue = config.getTimerA();
        }
        return timerValue;
    }

    private static int getTimerB(Request request) {
        int timerValue;
        block4: {
            timerValue = -1;
            try {
                IbmTransactionTimeoutHeader header = (IbmTransactionTimeoutHeader)request.getHeader("IBM-TransactionTimeout", true);
                if (header != null && header.applicationCreated()) {
                    timerValue = header.getTimeValue();
                    request.removeHeader("IBM-TransactionTimeout", true);
                }
            }
            catch (HeaderParseException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block4;
                c_logger.traceDebug(SIPNonInviteClientTransactionImpl.class, "getTimerB", "error getting header [IBM-TransactionTimeout] in message\r\n" + request, e2);
            }
        }
        if (timerValue == -1) {
            SIPStackConfiguration config = SIPTransactionStack.instance().getConfiguration();
            timerValue = config.getTimerB();
        }
        return timerValue;
    }

    synchronized void timerAfired() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "timerAfired", "Timer A fired on transaction " + this.toString());
        }
        this.updateSipTimersInvocationsPMICounter();
        if (this.getState() == 0) {
            this.m_timerAvalue *= 2;
            try {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "timerAfired", "IBM-PO header: " + this._ibmPO);
                }
                if (this.getFirstRequest().getHeader(IBM_PO_HEADER, true) == null && this._ibmPO != null && this.outboundEnable) {
                    this.getFirstRequest().addHeader(this._ibmPO, true);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "timerAfired", "add IBM-PO header: " + this._ibmPO);
                    }
                }
                this.sendRequestToTransport(this.getFirstRequest());
                this.m_timerA = new TimerA(this, this.getCallId());
                this.addTimerTask(this.m_timerA, this.m_timerAvalue);
            }
            catch (Exception e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "timerAfired", "", e2);
                }
                this.destroyTransaction();
            }
        }
    }

    void timerBfired() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "timerBfired", "Timer B fired on transaction " + this.toString());
        }
        this.updateSipTimersInvocationsPMICounter();
        if (this.getState() == 0) {
            this.notifyTransactionTimeoutToUA();
            this.destroyTransaction();
        }
    }

    void timerDfired() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "timerDfired", "Timer D fired on transaction " + this.toString());
        }
        this.updateSipTimersInvocationsPMICounter();
        if (this.getState() == 2) {
            this.notifyTransactionTimeoutToUA();
            this.destroyTransaction();
        }
    }

    @Override
    public synchronized void prossesTransportError() {
        this.destroyTransaction();
        this.notifyRequestErrorToUA(this.getFirstRequest());
    }

    public void setCancelTimer() {
        CancelTimer timer = new CancelTimer(this, this.getCallId());
        int delay = this.getParentStack().getConfiguration().getCancelTimer();
        this.addTimerTask(timer, delay);
    }

    private void cancelTimerFired() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "cancelTimerFired", "Timer CancelTimer fired on transaction " + this.toString());
        }
        if (this.getState() == 1) {
            this.notifyTransactionTimeoutToUA();
            this.destroyTransaction();
        }
    }

    private void sendAutomaticAckRequest() {
        block13: {
            RequestImpl invite = (RequestImpl)this.getFirstRequest();
            RequestImpl ack = new RequestImpl();
            try {
                MaxForwardsHeader maxForwardsHeader;
                ack.setMethod("ACK");
                ack.setCallIdHeader(invite.getCallIdHeader());
                ack.setFromHeader(invite.getFromHeader());
                ack.setRequestURI(invite.getRequestURI());
                ack.setToHeader(this.m_lastResponse.getToHeader());
                ack.setHeader(invite.getHeader("Via", true), true);
                CSeqHeader cseqHeader = SipJainFactories.getInstance().getHeaderFactory().createCSeqHeader(invite.getCSeqHeader().getSequenceNumber(), "ACK");
                ack.setCSeqHeader(cseqHeader);
                HeaderIterator routes = invite.getRouteHeaders();
                if (routes != null) {
                    while (routes.hasNext()) {
                        Header route = routes.next();
                        ack.addHeader(route, false);
                    }
                }
                if ((maxForwardsHeader = invite.getMaxForwardsHeader()) != null) {
                    ack.setMaxForwardsHeader(maxForwardsHeader);
                }
                if (this._ibmDestinationHeader != null) {
                    ack.addHeader(this._ibmDestinationHeader, true);
                }
                if (this._ibmPO != null && this.outboundEnable) {
                    ack.addHeader(this._ibmPO, true);
                }
                if (invite.isLoopback()) {
                    ack.setLoopback(true);
                }
                try {
                    this.sendRequestToTransport(ack);
                }
                catch (SIPTransportException e2) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "sendAutomaticAckRequest", e2.getMessage(), e2);
                    }
                }
            }
            catch (IllegalArgumentException e3) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "sendAutomaticAckRequest", e3.getMessage(), e3);
                }
            }
            catch (SipParseException e4) {
                if (!c_logger.isTraceDebugEnabled()) break block13;
                c_logger.traceDebug(this, "sendAutomaticAckRequest", e4.getMessage(), e4);
            }
        }
    }

    @Override
    public synchronized void destroyTransaction() {
        this.setState(3);
        if (this.m_timerA != null) {
            this.m_timerA.cancel();
        }
        if (this.m_timerB != null) {
            this.m_timerB.cancel();
        }
        if (this.m_timerD != null) {
            this.m_timerD.cancel();
        }
        this.startAPITimer();
    }

    private void notCalling() {
        if (this.m_timerA != null) {
            this.m_timerA.cancel();
        }
        if (this.m_timerB != null) {
            this.m_timerB.cancel();
        }
    }

    @Override
    public Response getMostRecentResponse() {
        return this.m_lastResponse;
    }

    @Override
    protected String getType() {
        return "Client INVITE";
    }

    @Override
    public LogMgr getLoger() {
        return c_logger;
    }

    @Override
    public String getStateAsString() {
        switch (this.getState()) {
            case 0: {
                return "Calling";
            }
        }
        return super.getStateAsString();
    }

    private static class CancelTimer
    extends TimerEvent {
        private SIPInviteClientTransactionImpl m_ct;

        CancelTimer(SIPInviteClientTransactionImpl ct, String callId) {
            super(callId);
            this.m_ct = ct;
        }

        @Override
        public void onExecute() {
            this.m_ct.cancelTimerFired();
        }
    }

    static class TimerD
    extends TimerEvent {
        SIPInviteClientTransactionImpl m_ct;

        TimerD(SIPInviteClientTransactionImpl ct, String callId) {
            super(callId);
            this.m_ct = ct;
        }

        @Override
        public void onExecute() {
            if (this.m_ct != null) {
                this.m_ct.timerDfired();
            }
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }
    }

    static class TimerB
    extends TimerEvent {
        SIPInviteClientTransactionImpl m_ct;

        TimerB(SIPInviteClientTransactionImpl ct, String callId) {
            super(callId);
            this.m_ct = ct;
        }

        @Override
        public void onExecute() {
            if (this.m_ct != null) {
                this.m_ct.timerBfired();
            }
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }
    }

    static class TimerA
    extends TimerEvent {
        SIPInviteClientTransactionImpl m_transaction;

        TimerA(SIPInviteClientTransactionImpl transaction, String callId) {
            super(callId);
            this.m_transaction = transaction;
        }

        @Override
        public void onExecute() {
            this.m_transaction.timerAfired();
        }
    }
}

