/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.properties;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.properties.SipPropertiesMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DeclarativeServiceProperties {
    private static final TraceComponent tc = Tr.register(DeclarativeServiceProperties.class);
    private Map<String, Object> properties;
    private Map<String, Object> changes;
    private SipPropertiesMap sipPropertyMap = PropertiesStore.getInstance().getProperties();

    public DeclarativeServiceProperties(Map<String, Object> dsProperties) {
        this.properties = dsProperties;
    }

    private Object validateProperty(String key) {
        Object prop = this.properties.get(key);
        if (prop == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DeclarativeServiceProperties validateProperty. property key=" + key + " not found"), (Object[])new Object[]{this.properties});
        }
        return prop;
    }

    public String getString(String key, boolean useGlobalDefault) {
        return this.get(key, this.sipPropertyMap.getString(key), useGlobalDefault);
    }

    public int getInt(String key, boolean useGlobalDefault) {
        return this.getInt(key, this.sipPropertyMap.getInt(key), useGlobalDefault);
    }

    public long getLong(String key, boolean useGlobalDefault) {
        return this.getLong(key, this.sipPropertyMap.getLong(key), useGlobalDefault);
    }

    public boolean getBoolean(String key, boolean useGlobalDefault) {
        return this.getBoolean(key, this.sipPropertyMap.getBoolean(key), useGlobalDefault);
    }

    private String get(String key, String defaultValue, boolean useDefault) {
        Object value = this.validateProperty(key);
        return value == null && useDefault ? defaultValue : value.toString();
    }

    private int getInt(String key, int defaultValue, boolean useDefault) {
        Object value = this.validateProperty(key);
        return value == null && useDefault ? defaultValue : (Integer)value;
    }

    private long getLong(String key, long defaultValue, boolean useDefault) {
        Object value = this.validateProperty(key);
        return value == null && useDefault ? defaultValue : (Long)value;
    }

    private boolean getBoolean(String key, boolean defaultValue, boolean useDefault) {
        Object value = this.validateProperty(key);
        return value == null && useDefault ? defaultValue : (Boolean)value;
    }

    void storeChangedFromValue(String key, Object oldValue) {
        if (this.changes == null) {
            this.changes = new HashMap<String, Object>();
        }
        this.changes.put(key, oldValue);
    }

    public Set<String> getUpdatedProperties() {
        return this.changes.keySet();
    }

    public boolean wasChanged(String key) {
        return this.changes.get(key) != null;
    }

    public Object previousValue(String key) {
        return this.changes.get(key);
    }
}

