/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.sessions;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import jain.protocol.ip.sip.message.Message;
import javax.servlet.sip.SipServletMessage;

public class SessionId {
    private static final LogMgr c_logger = Log.get(SessionId.class);
    private String m_localTag;
    private String m_remoteTag;
    private String m_callId;

    public static SessionId fromInboundMessage(SipServletMessage message) {
        Message jainSIPMsg = ((SipServletMessageImpl)message).getMessage();
        return SessionId.fromInboundMessage(jainSIPMsg);
    }

    public static SessionId fromInboundMessage(Message message) {
        SessionId sessionId = null;
        String localTag = message.getToHeader().getTag();
        String remoteTag = message.getFromHeader().getTag();
        if (null == localTag) {
            localTag = "";
        }
        if (null == remoteTag) {
            remoteTag = "";
        }
        String callId = message.getCallIdHeader().getCallId();
        sessionId = new SessionId(callId, localTag, remoteTag);
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer b = new StringBuffer(64);
            b.append("Created ");
            b.append(sessionId);
            b.append(" \nFor Message: ");
            b.append(message.getStartLine());
            c_logger.traceDebug((Object)"SessionId", "fromMessage", b.toString());
        }
        return sessionId;
    }

    public SessionId(String callId, String localPartyTag, String remotePartyTag) {
        this.m_callId = callId;
        this.m_localTag = localPartyTag;
        this.m_remoteTag = remotePartyTag;
    }

    public boolean equals(Object obj) {
        boolean rc = false;
        if (obj instanceof SessionId) {
            SessionId other = (SessionId)obj;
            if (other.m_callId.equals(this.m_callId) && other.m_remoteTag.equals(this.m_remoteTag) && other.m_localTag.equals(this.m_localTag)) {
                rc = true;
            }
        }
        return rc;
    }

    public int hashCode() {
        return this.m_callId.hashCode() ^ this.m_localTag.hashCode() ^ this.m_remoteTag.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("SessionId, CallId: ");
        buffer.append(this.m_callId);
        buffer.append(" ,Local  tag: ");
        buffer.append(this.m_localTag);
        buffer.append(" ,Remote tag: ");
        buffer.append(this.m_remoteTag);
        return buffer.toString();
    }
}

