/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.session;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.servlet.session.IBMApplicationSession;
import com.ibm.websphere.servlet.session.IBMSession;
import com.ibm.ws.sip.container.converged.session.ApplicationSessionCreator;
import com.ibm.ws.sip.container.servlets.SipServletsFactoryImpl;
import com.ibm.ws.sip.container.servlets.WASXSipApplicationSessionImpl;
import java.util.StringTokenizer;
import javax.servlet.http.HttpSession;

public class SipApplicationSessionCreator
implements ApplicationSessionCreator {
    private static final transient LogMgr c_logger = Log.get(SipApplicationSessionCreator.class);
    private static final String DELIM = ";";
    private static final String ATTRIBUTE_APP_SESSION_ID = "com.ws.ibm.sip.application.sessionID";

    public IBMApplicationSession createApplicationSession(IBMSession httpSession, String appName) {
        return this.createApplicationSession(httpSession, appName, null);
    }

    @Override
    public IBMApplicationSession createApplicationSession(IBMSession httpSession, String appName, String pathInfo) {
        boolean isAttributeExists;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "createApplicationSession", (Object)(httpSession.toString() + " " + appName + " " + pathInfo));
        }
        WASXSipApplicationSessionImpl appSession = null;
        String ibmAppId = null;
        ibmAppId = (String)httpSession.getAttribute(ATTRIBUTE_APP_SESSION_ID);
        boolean bl = isAttributeExists = ibmAppId != null && ibmAppId.length() > 0;
        if (!isAttributeExists && pathInfo != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createApplicationSession", "pathInfo[" + pathInfo + "]");
            }
            StringTokenizer tokenizer = new StringTokenizer(pathInfo, DELIM);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "createApplicationSession", "token[" + token + "]");
                }
                if (!token.startsWith("ibmappid")) continue;
                ibmAppId = token.substring("ibmappid".length() + 1);
                if (!c_logger.isTraceDebugEnabled()) break;
                c_logger.traceDebug(this, "createApplicationSession", "ibmAppId[" + ibmAppId + "]");
                break;
            }
        }
        if (ibmAppId != null) {
            appSession = (WASXSipApplicationSessionImpl)WASXSipApplicationSessionImpl.getAppSession(ibmAppId);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createApplicationSession", "found AppSessionID[" + ibmAppId + "], AppSession[" + appSession + "]");
            }
        }
        if (appSession == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createApplicationSession", "creating new AppSession");
            }
            appSession = (WASXSipApplicationSessionImpl)((SipServletsFactoryImpl)SipServletsFactoryImpl.getInstance(appName)).createApplicationSession();
            appSession.addToApplicationSessionsTable();
        }
        appSession.addHttpSession((HttpSession)httpSession);
        if (!isAttributeExists) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createApplicationSession", "Setting new attribute " + appSession.getId());
            }
            httpSession.setAttribute(ATTRIBUTE_APP_SESSION_ID, (Object)appSession.getId());
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "createApplicationSession", "returning application session=" + appSession);
        }
        return appSession;
    }

    @Override
    public String encodeURL(String url) {
        return "";
    }

    @Override
    public String encodeURL(String relativePath, String scheme) {
        return "";
    }
}

