/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.events.EventsDispatcher;
import com.ibm.ws.sip.container.servlets.WASXSipApplicationSessionImpl;
import com.ibm.ws.sip.container.was.WASHttpSessionListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.sip.ConvergedHttpSession;

public class WASXHttpSessionListener
implements WASHttpSessionListener {
    private static final LogMgr c_logger = Log.get(WASXHttpSessionListener.class);

    public void sessionCreated(HttpSessionEvent session) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "sessionCreated", "http session [" + session.getSession().getId() + "] created");
        }
    }

    public void sessionDestroyed(HttpSessionEvent session) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "sessionDestroyed", "http session [" + session.getSession().getId() + "] destroyed");
        }
        if (session.getSession() instanceof ConvergedHttpSession) {
            EventsDispatcher.httpSessionDestroyed(SipContainer.getHttpSessionListener(), session.getSession());
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "sessionDestroyed", "Unknown http session [" + session.getSession().getId() + "], ignoring...");
        }
    }

    @Override
    public void handleHttpSessionDestoyEvent(HttpSession session) {
        ConvergedHttpSession convergedHTTPSession = (ConvergedHttpSession)session;
        WASXSipApplicationSessionImpl appSession = (WASXSipApplicationSessionImpl)convergedHTTPSession.getApplicationSession();
        if (appSession == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleHttpSessionDestoyEvent", "Unable to remove http session: " + session.getId());
            }
        } else {
            appSession.removeHttpSession(session.getId());
            if (appSession.isReadyToInvalidate()) {
                appSession.invalidate();
            }
        }
    }
}

