/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.header.GenericParametersHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersHeaderImpl;
import com.ibm.ws.sip.container.servlets.EmptyIterator;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.header.NameAddressHeader;
import jain.protocol.ip.sip.header.ParametersHeader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.sip.Parameterable;

public class ParameterableImpl
implements Parameterable,
Serializable {
    static final long serialVersionUID = 1637732213269414559L;
    private static final LogMgr c_logger = Log.get(ParameterableImpl.class);
    protected ParametersHeader _parametersHeader;

    public ParameterableImpl(ParametersHeader parametersHeader) {
        if (parametersHeader == null) {
            throw new IllegalArgumentException("parametersHeader cannot be null");
        }
        this._parametersHeader = parametersHeader;
    }

    @Override
    public Object clone() {
        ParameterableImpl cloned;
        block2: {
            cloned = null;
            try {
                cloned = (ParameterableImpl)super.clone();
                cloned._parametersHeader = (ParametersHeader)this._parametersHeader.clone();
            }
            catch (CloneNotSupportedException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                c_logger.error("error.cloning.address", "Create", null, (Throwable)e2);
            }
        }
        return cloned;
    }

    @Override
    public String getParameter(String name) {
        if (name == null) {
            throw new NullPointerException("javax.servlet.sip.Parameterable#getParameter(java.lang.String name): name must not be null");
        }
        return this._parametersHeader.getParameter(name);
    }

    @Override
    public Iterator<String> getParameterNames() {
        Iterator<String> iter = this._parametersHeader.getParameters();
        if (null == iter) {
            iter = EmptyIterator.getInstance();
        }
        return iter;
    }

    @Override
    public void removeParameter(String name) {
        if (name == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("removeParameter:  name is null, throwing exception");
            }
            throw new NullPointerException("name is null");
        }
        this._parametersHeader.removeParameter(name);
    }

    @Override
    public void setParameter(String name, String value) {
        block6: {
            if (name == null) {
                throw new NullPointerException("javax.servlet.sip.Parameterable#setParameter(java.lang.String name, java.lang.String value): name must not be null");
            }
            if (value == null) {
                this.removeParameter(name);
                return;
            }
            try {
                this._parametersHeader.setParameter(name, value);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{name, value};
                    c_logger.error("error.set.parameter", "Request", args, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block6;
                Object[] args = new Object[]{name, value};
                c_logger.error("error.set.parameter", "Request", args, (Throwable)e3);
            }
        }
    }

    @Override
    public Set<Map.Entry<String, String>> getParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator localIter = this._parametersHeader.getParameters();
        while (localIter != null && localIter.hasNext()) {
            String paramName = (String)localIter.next();
            String localParam = this._parametersHeader.getParameter(paramName);
            map.put(paramName, localParam);
        }
        return map.entrySet();
    }

    @Override
    public String getValue() {
        String value;
        ParametersHeader parametersHeader = this._parametersHeader;
        if (c_logger.isTraceDebugEnabled()) {
            String headerAsString = parametersHeader == null ? null : parametersHeader.getName() + ": " + parametersHeader.getValue();
            c_logger.traceDebug(this, "getValue", headerAsString);
        }
        if (parametersHeader == null) {
            value = null;
        } else if (parametersHeader instanceof GenericParametersHeaderImpl) {
            GenericParametersHeaderImpl genericParametersHeaderImpl = (GenericParametersHeaderImpl)parametersHeader;
            value = genericParametersHeaderImpl.getFieldValue();
        } else if (parametersHeader instanceof NameAddressHeader) {
            NameAddressHeader nameAddressHeader = (NameAddressHeader)parametersHeader;
            NameAddress nameAddress = nameAddressHeader.getNameAddress();
            value = nameAddress == null ? null : nameAddress.toString();
        } else {
            value = parametersHeader.getValue();
            int semi = value.indexOf(59);
            if (semi != -1) {
                value = value.substring(0, semi);
            }
        }
        return value;
    }

    @Override
    public void setValue(String value) throws IllegalStateException {
        GenericParametersHeaderImpl genericParametersHeaderImpl;
        if (value == null) {
            throw new NullPointerException("null parameterable value");
        }
        ParametersHeader parametersHeader = this._parametersHeader;
        if (c_logger.isTraceDebugEnabled()) {
            String headerAsString = parametersHeader.toString();
            c_logger.traceDebug(this, "setValue", headerAsString);
        }
        if (parametersHeader instanceof GenericParametersHeaderImpl) {
            genericParametersHeaderImpl = (GenericParametersHeaderImpl)parametersHeader;
        } else {
            genericParametersHeaderImpl = new GenericParametersHeaderImpl("IBM-GenericParametersHeader");
            genericParametersHeaderImpl.assign((ParametersHeaderImpl)parametersHeader);
            this._parametersHeader = genericParametersHeaderImpl;
        }
        genericParametersHeaderImpl.setFieldValue(value);
    }

    public String toString() {
        return this._parametersHeader.getValue();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParameterableImpl)) {
            return false;
        }
        ParameterableImpl otherParameterable = (ParameterableImpl)other;
        ParametersHeader thisParameters = this._parametersHeader;
        ParametersHeader otherParameters = otherParameterable._parametersHeader;
        if (thisParameters == otherParameters) {
            return true;
        }
        if (thisParameters == null || otherParameters == null) {
            return false;
        }
        if (!this.compareParameters(other)) {
            return false;
        }
        if (thisParameters instanceof NameAddressHeader && otherParameters instanceof NameAddressHeader) {
            NameAddress otherAddress;
            NameAddressHeader thisAddressHeader = (NameAddressHeader)thisParameters;
            NameAddressHeader otherAddressHeader = (NameAddressHeader)otherParameters;
            NameAddress thisAddress = thisAddressHeader.getNameAddress();
            if (thisAddress != (otherAddress = otherAddressHeader.getNameAddress())) {
                if (thisAddress == null || otherAddress == null) {
                    return false;
                }
                if (!thisAddress.equals(otherAddress)) {
                    return false;
                }
            }
        } else {
            String otherValue;
            String thisValue = this.getValue();
            if (thisValue != (otherValue = otherParameterable.getValue())) {
                return false;
            }
            if (thisValue == null || otherValue == null) {
                return false;
            }
        }
        return true;
    }

    protected boolean compareParameters(Object obj) {
        if (!(obj instanceof ParameterableImpl)) {
            return false;
        }
        ParameterableImpl other = (ParameterableImpl)obj;
        ParametersHeader parameters = other._parametersHeader;
        if (!this._parametersHeader.hasParameters() || !parameters.hasParameters()) {
            return true;
        }
        Iterator localIter = this._parametersHeader.getParameters();
        boolean rc = true;
        while (localIter.hasNext()) {
            String paramName = (String)localIter.next();
            String localParam = this._parametersHeader.getParameter(paramName);
            String otherParam = parameters.getParameter(paramName);
            if (otherParam == null || localParam.equals(otherParam)) continue;
            rc = false;
            break;
        }
        return rc;
    }

    public int hashCode() {
        return this._parametersHeader.getValue().hashCode();
    }

    public ParametersHeader getParametersHeader() {
        return this._parametersHeader;
    }
}

