/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.jain.protocol.ip.sip.SipProviderImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.MessageImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.RequestImpl;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.proxy.ProxyBranchImpl;
import com.ibm.ws.sip.container.proxy.SipProxyInfo;
import com.ibm.ws.sip.container.router.CompositionData;
import com.ibm.ws.sip.container.router.CompositionInfoMap;
import com.ibm.ws.sip.container.router.SipRouter;
import com.ibm.ws.sip.container.servlets.AddressImpl;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletCancelRequest;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.sessions.SipTransactionUserTable;
import com.ibm.ws.sip.container.transaction.ClientTransaction;
import com.ibm.ws.sip.container.transaction.ClientTransactionListener;
import com.ibm.ws.sip.container.transaction.TransactionTable;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.SipUtil;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import com.ibm.ws.sip.stack.util.SipStackUtil;
import jain.protocol.ip.sip.ListeningPoint;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.header.CallIdHeader;
import jain.protocol.ip.sip.header.ContentTypeHeader;
import jain.protocol.ip.sip.header.EndPointHeader;
import jain.protocol.ip.sip.header.FromHeader;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.MaxForwardsHeader;
import jain.protocol.ip.sip.header.NameAddressHeader;
import jain.protocol.ip.sip.header.RouteHeader;
import jain.protocol.ip.sip.header.ToHeader;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Request;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.sip.Address;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.UAMode;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;

public class OutgoingSipServletRequest
extends SipServletRequestImpl {
    static final long serialVersionUID = -756987237986445115L;
    private static final LogMgr c_logger = Log.get(OutgoingSipServletRequest.class);
    private transient boolean m_contactRemovedByApp = false;
    private transient ClientTransactionListener m_clientTransactionListener;
    private static transient boolean s_firstRequestSent = false;
    private transient Proxy m_proxy;
    private transient boolean m_isSubsequentRequest;
    private transient Header m_destinationHeader = null;
    private transient Header m_preferredOutbound = null;
    private boolean markedForErrorResponse = false;
    private String appInvokedName = null;

    public OutgoingSipServletRequest() {
    }

    public OutgoingSipServletRequest(TransactionUserWrapper transcactionUser, String method, Address from, Address to, boolean initial) {
        String callId = transcactionUser.getCallId();
        this.createRequest(method, from, to, callId, transcactionUser.getSipProvider(), initial);
        long cSeq = transcactionUser.getNextCSeqNumber();
        this.addCSeqHeader(cSeq, method);
        this.setTransactionUser(transcactionUser);
        this.setIsCommited(false);
        this.testAndSetFromTag();
        SipServletRequestImpl origReq = (SipServletRequestImpl)transcactionUser.getSipServletRequest();
        if (origReq != null) {
            this.setExternalRoute(origReq.isExternalRoute());
            this.addToExcludeSipletsList(origReq);
            Serializable stateInfo = origReq.getStateInfo();
            String nextApp = origReq.getNextApplication();
            SipApplicationRoutingDirective appDir = origReq.getDirective();
            SipApplicationRoutingRegion routingRegion = origReq.getRegion();
            this.setStateInfo(stateInfo);
            this.setNextApplication(nextApp);
            this.setDirective(appDir);
            this.setRoutingRegion(routingRegion);
        }
    }

    @Override
    public SipSession getProxySession(boolean create) {
        return this.getTransactionUser().getSipSession(create);
    }

    public OutgoingSipServletRequest(String method, Address from, Address to, String callId, SipProvider sipProvider, SipApplicationSessionImpl appSession, SipServletRequestImpl origReq) {
        this.createRequest(method, from, to, callId, sipProvider, true);
        SipTransactionUserTable transactionUsersTable = SipTransactionUserTable.getInstance();
        TransactionUserWrapper tUser = transactionUsersTable.createTransactionUserWrapper(this, false, appSession, false);
        this.init(method, origReq, tUser, false);
        this.testAndSetFromTag();
    }

    public OutgoingSipServletRequest(String method, Address from, Address to, String callId, SipProvider sipProvider, SipServletRequestImpl origReq, boolean forProxy) {
        this.createRequest(method, from, to, callId, sipProvider, true);
        this.init(method, origReq, origReq.getTransactionUser(), forProxy);
    }

    private void createRequest(String method, Address from, Address to, String callId, SipProvider sipProvider, boolean initial) {
        this.createJainRequest(method, from, to, callId);
        this.setSipProvider(sipProvider);
        this.setIsInital(initial);
    }

    private void init(String method, SipServletRequestImpl origReq, TransactionUserWrapper tUser, boolean forProxy) {
        this.setIsCommited(false);
        long cSeq = 1L;
        if (origReq != null) {
            CSeqHeader cSeqH = origReq.getJainSipMessage().getCSeqHeader();
            if (null != cSeqH) {
                cSeq = cSeqH.getSequenceNumber();
                if (tUser != null) {
                    tUser.setcSeq(cSeq);
                }
            }
            this.setExternalRoute(origReq.isExternalRoute());
            this.addToExcludeSipletsList(origReq);
            this._initialPoppedRoute = origReq.getInitialPoppedRoute();
        }
        if (!forProxy) {
            cSeq = tUser.getNextCSeqNumber();
        }
        this.addCSeqHeader(cSeq, method);
        this.setTransactionUser(tUser);
    }

    @Override
    public SipSession getSession(boolean create) {
        if (!this.isLiveMessage("getSession")) {
            return null;
        }
        if (this.m_transactionUser == null && this.m_proxy != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getSession", "getting the session from the proxy original request session");
            }
            return this.m_proxy.getOriginalRequest().getSession(create);
        }
        if (this.m_transactionUser.isProxying()) {
            return this.getProxySession(create);
        }
        return this.m_transactionUser.getSipSession(create);
    }

    @Override
    public SipApplicationSession getApplicationSession(boolean create) {
        if (!this.isLiveMessage("getApplicationSession")) {
            return null;
        }
        if (this.m_transactionUser == null && this.m_proxy != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getSession", "getting the app session from the proxy original request app session");
            }
            return this.m_proxy.getOriginalRequest().getApplicationSession(create);
        }
        if (this.m_transactionUser == null) {
            return null;
        }
        return this.m_transactionUser.getApplicationSession(create);
    }

    @Override
    public String getVirtualHost() {
        String virtualHost = null;
        virtualHost = this.m_proxy != null ? ((SipServletRequestImpl)this.m_proxy.getOriginalRequest()).getVirtualHost() : super.getVirtualHost();
        return virtualHost;
    }

    private void createJainRequest(String method, Address from, Address to, String callId) {
        block4: {
            RequestImpl req = new RequestImpl();
            try {
                req.setMethod(method);
                FromHeader fromH = this.createFromHeader((AddressImpl)from);
                req.setFromHeader(fromH);
                ToHeader toH = this.createToHeader((AddressImpl)to);
                req.setToHeader(toH);
                CallIdHeader callIdH = this.createCallIdHeader(callId);
                req.setCallIdHeader(callIdH);
                MaxForwardsHeader maxForwards = this.getHeadersFactory().createMaxForwardsHeader(70);
                req.setHeader(maxForwards, true);
                this.setMessage(req);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.exception", "Create", null, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block4;
                c_logger.error("error.exception", "Create", null, (Throwable)e3);
            }
        }
    }

    private void addCSeqHeader(long cSeq, String method) {
        block4: {
            try {
                CSeqHeader cSeqHeader = this.getHeadersFactory().createCSeqHeader(cSeq, method);
                this.getRequest().setCSeqHeader(cSeqHeader);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.exception", "Create", null, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block4;
                c_logger.error("error.exception", "Create", null, (Throwable)e3);
            }
        }
    }

    protected void addToExcludeSipletsList(SipServletRequestImpl origReq) {
        this.addToExcludeSipletsList(origReq.getExcludedAppsList());
        TransactionUserWrapper tUser = origReq.getTransactionUser();
        SipServletDesc siplet = tUser.getSipServletDesc();
        if (siplet != null) {
            this.addToExcludeAppsList(siplet.getSipApp());
        }
    }

    @Override
    public String getMethod() {
        String method;
        block2: {
            method = null;
            try {
                method = this.getRequest().getMethod();
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                c_logger.error("error.exception", "Create", null, (Throwable)e2);
            }
        }
        return method;
    }

    public void setRequestUriAccordingToRouteSet(Address remoteTarget) {
        boolean reqUriWasSet;
        block7: {
            Request jainReq = this.getRequest();
            HeaderIterator routeSet = jainReq.getRouteHeaders();
            reqUriWasSet = false;
            if (routeSet != null && routeSet.hasNext()) {
                try {
                    RouteHeader topRoute = (RouteHeader)routeSet.next();
                    if (!((SipURL)topRoute.getNameAddress().getAddress()).hasParameter("lr")) {
                        jainReq.setRequestURI(topRoute.getNameAddress().getAddress());
                        if (routeSet.hasNext()) {
                            topRoute = (RouteHeader)routeSet.next();
                            ((SipURL)topRoute.getNameAddress().getAddress()).setParameter("ibmsr", "");
                        } else {
                            remoteTarget.setParameter("ibmsr", "");
                        }
                        jainReq.removeHeader("Route", true);
                        this.addAddressHeader("Route", remoteTarget, false);
                        reqUriWasSet = true;
                    }
                }
                catch (SipParseException e2) {
                    if (!c_logger.isTraceDebugEnabled()) break block7;
                    StringBuffer buff = new StringBuffer();
                    buff.append("Failed to parse the top Route in request ");
                    buff.append(jainReq);
                    c_logger.traceDebug(this, "setRequestUriAccordingToRouteSet", buff.toString());
                }
            }
        }
        if (!reqUriWasSet) {
            this.setRequestURI(remoteTarget.getURI());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send() throws IOException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "send");
        }
        Class<OutgoingSipServletRequest> clazz = OutgoingSipServletRequest.class;
        synchronized (OutgoingSipServletRequest.class) {
            if (!s_firstRequestSent) {
                SipContainerComponent.activateSipApplicationRouter();
                s_firstRequestSent = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (!this.isLiveMessage("send")) {
                return;
            }
            if (this.isCommitted()) {
                throw new IllegalStateException("Can not modify committed message");
            }
            this.isSessionIsValid();
            this.resetContentLength();
            if (null == this.m_clientTransactionListener) {
                this.m_clientTransactionListener = this.getTransactionUser();
            }
            if (this.getTransactionUser() != null && this.getTransactionUser().isProxying() && this._origContact != null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "send", "");
                }
                super.setAddressHeader("Contact", this._origContact);
            }
            this.send(this.m_clientTransactionListener);
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "send");
            }
            return;
        }
    }

    public synchronized void send(ClientTransactionListener listener) throws IOException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "send", (Object)listener);
        }
        if (!this.isLiveMessage("send")) {
            return;
        }
        if (this.isCommitted()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "send", "Send Failed, Request already Commited");
            }
            return;
        }
        ClientTransaction transaction = TransactionTable.getInstance().createClientTransaction(this);
        transaction.setClientTransactionListener(listener);
        this.setTransaction(transaction);
        boolean wasSent = transaction.sendRequest();
        if (wasSent) {
            this.setIsCommited(true);
            this.m_clientTransactionListener = null;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "send");
        }
    }

    public long sendImpl() throws IOException {
        return 1L;
    }

    public void updateParamAccordingToDestination() throws IOException {
        try {
            NameAddressHeader destination = (NameAddressHeader)this.getRequest().getHeader("IBM-Destination", true);
            if (destination != null) {
                String transport = null;
                if (destination.getNameAddress().getAddress().getScheme().equalsIgnoreCase("sips")) {
                    transport = "tls";
                }
                if (transport == null) {
                    transport = ((SipURL)destination.getNameAddress().getAddress()).getTransport();
                }
                if (this.selectProvider(transport)) {
                    this.getRequest().removeHeader("Via", true);
                    this.addViaHeader();
                }
            }
        }
        catch (SipParseException e2) {
            throw new IOException(e2.getMessage());
        }
    }

    @Override
    protected SipURI constructContactHeaderURI() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "constructContactHeaderURI");
        }
        TransactionUserWrapper tu = this.getTransactionUser();
        SipURI sipURI = null;
        if (tu != null && !tu.isProxying()) {
            SipProxyInfo proxyInfo;
            block12: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "constructContactHeaderURI", "TU Id [" + tu.getId() + "] ,is proxy mode [" + tu.isProxying() + "]");
                }
                proxyInfo = SipProxyInfo.getInstance();
                if (this.getSipProvider() == null) {
                    try {
                        SipURL target = (SipURL)SipStackUtil.createTargetFromMessage(this.getRequest()).clone();
                        this.setProvider(target);
                    }
                    catch (IllegalArgumentException e2) {
                        if (c_logger.isErrorEnabled()) {
                            c_logger.error("error.exception", "Create", null, (Throwable)e2);
                        }
                    }
                    catch (IOException e3) {
                        if (!c_logger.isErrorEnabled()) break block12;
                        c_logger.error("error.exception", "Create", null, (Throwable)e3);
                    }
                }
            }
            if (this.getSipProvider() != null) {
                ListeningPoint lPoint = this.getSipProvider().getListeningPoint();
                String transport = lPoint.getTransport();
                int index = tu.getPreferedOutboundIface(transport);
                sipURI = index == -1 ? proxyInfo.getDefaultOutboundIface(transport) : proxyInfo.getOutboundInterface(index, transport);
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "constructContactHeaderURI", "Can't set Contact header, provider is null");
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit((Object)this, "constructContactHeaderURI", sipURI);
        }
        return sipURI;
    }

    public void setupParametersBeforeSent(SipURL target, boolean isLoopBack) throws IOException {
        if (!this.isLiveMessage("sendImpl")) {
            return;
        }
        try {
            int ibmPOIndex;
            Request req = this.getRequest();
            this.setProvider(target);
            this.addViaHeader();
            TransactionUserWrapper tu = this.getTransactionUser();
            SipURI sipURI = null;
            if (tu != null && !tu.isProxying()) {
                sipURI = this.constructContactHeaderURI();
                this.setupContactHeaderBeforeSent(sipURI);
            } else if (c_logger.isTraceDebugEnabled()) {
                if (tu == null) {
                    c_logger.traceDebug(this, "setupParametersBeforeSent", "TU is null. Can't access prefered outbound interface. Using default for contact header.");
                } else {
                    c_logger.traceDebug(this, "setupParametersBeforeSent", "TU is for proxy, no need to change the contact header");
                }
            }
            if (isLoopBack) {
                String ibmClientAddr = this.createIBMClientAddrHeaderForLoopbackMessages();
                if (ibmClientAddr != null) {
                    this.addHeader("IBM-Client-Address", ibmClientAddr);
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "setupParametersBeforeSent", "Loopback message, adding header IBM-Client-Address = " + ibmClientAddr);
                }
                ((MessageImpl)((Object)req)).setLoopback(true);
            }
            String ibmPOHeader = this.getHeader("IBM-PO");
            boolean outboundEnable = PropertiesStore.getInstance().getProperties().getBoolean("enableSetOutboundIF");
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setupParametersBeforeSent", "current IBM-PO =  " + ibmPOHeader);
            }
            if (tu != null && !outboundEnable) {
                SipProxyInfo.getInstance().addPreferedOutboundHeader(this, tu.getPreferedOutboundIface(this.getTransport()));
            } else if (ibmPOHeader == null && (ibmPOIndex = this.getPreferedOutboundIface()) != -1) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "setupParametersBeforeSent", "setting IBM-PO to =  " + ibmPOIndex);
                }
                SipProxyInfo.getInstance().addPreferedOutboundHeader(this, ibmPOIndex);
            }
            boolean isAddIBMPO = PropertiesStore.getInstance().getProperties().getBoolean("addIBMPOLBMsg");
            if (tu != null && isLoopBack && !isAddIBMPO) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "setupParametersBeforeSent", "removing IBM-PO from the loopback message");
                }
                this.removeHeader("IBM-PO");
            }
        }
        catch (SipParseException e2) {
            if (c_logger.isErrorEnabled()) {
                Object[] args = new Object[]{this};
                c_logger.error("error.send.request", "Request", args, (Throwable)e2);
            }
            this.logExceptionToSessionLog(0x100004, e2);
            throw new IOException(e2.getMessage());
        }
    }

    private boolean isSameSender(SipServletRequest request1, Request request2) {
        boolean returnVal = false;
        String fromHeaderTag1 = request1.getFrom().getParameter("tag");
        String fromHeaderTag2 = request2.getFromHeader().getTag();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "isSameSender", "originalFromHeaderTag = " + fromHeaderTag1);
            c_logger.traceDebug(this, "isSameSender", "fromHeaderTag = " + fromHeaderTag2);
        }
        if (fromHeaderTag1 != null && fromHeaderTag2 != null && fromHeaderTag1.compareTo(fromHeaderTag2) == 0) {
            returnVal = true;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "isSameSender", "" + returnVal);
        }
        return returnVal;
    }

    @Override
    public String getTransport() {
        String transport = this.getTransportInt();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)OutgoingSipServletRequest.class.getName(), "getTransport", transport);
        }
        return transport;
    }

    private void setupContactHeaderBeforeSent(SipURI sipURI) throws IllegalArgumentException, SipParseException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{sipURI};
            c_logger.traceEntry((Object)OutgoingSipServletRequest.class.getName(), "setupContactHeaderBeforeSent", params);
        }
        if (this.checkIsSystemContactHeader()) {
            if (sipURI != null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "setupContactHeaderBeforeSent", "Using preferred outbound interface for contact header.");
                }
                this.addContactHeader(sipURI);
            } else {
                this.addContactHeader(null);
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setupContactHeaderBeforeSent", "the Contact is not a System header, no update.");
        }
    }

    public long sendImpl(long transactionId) throws IOException {
        Request req = this.getRequest();
        try {
            if (req.getMethod().equals("INVITE")) {
                this.m_destinationHeader = req.getHeader("IBM-Destination", true);
                this.m_preferredOutbound = req.getHeader("IBM-PO", true);
            }
        }
        catch (HeaderParseException headerParseException) {
            throw new IOException("bad header [IBM-Destination]");
        }
        catch (SipParseException sipParseException) {
            throw new IOException("unknown request method");
        }
        this.setTransactionId(transactionId);
        SipProviderImpl provider = (SipProviderImpl)this.getSipProvider();
        try {
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer b = new StringBuffer(64);
                b.append("Sent OutGoing Request, Transaction Id:");
                b.append(transactionId);
                b.append("\r\n");
                b.append(req);
                c_logger.traceDebug(this, "sendImpl", b.toString());
            }
            provider.sendRequest(req, transactionId);
            return transactionId;
        }
        catch (SipException e2) {
            if (c_logger.isErrorEnabled()) {
                Object[] args = new Object[]{this};
                c_logger.error("error.send.request", "Request", args, (Throwable)e2);
            }
            this.logExceptionToSessionLog(0x100004, e2);
            throw new IOException(e2.getMessage());
        }
    }

    public boolean checkIsLoopback() throws IllegalArgumentException, SipParseException {
        if (!c_appCompositionEnabled) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "checkIsLoopback", "Application composition is not enabled: loopback = false");
            }
            return false;
        }
        boolean isLoopback = false;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "checkIsLoopback", "m_isSubsequentRequest: " + this.m_isSubsequentRequest + " isExternalRoute: " + this.isExternalRoute());
        }
        if (!this.m_isSubsequentRequest && !this.isExternalRoute()) {
            if (this.checkForApplicationComposition()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "checkIsLoopback", "application composition is true");
                }
                isLoopback = true;
            }
            if (isLoopback || !this.isExternalRoute()) {
                this.addCompositionHeader();
            }
        } else {
            TransactionUserWrapper tUser = SipTransactionUserTable.getInstance().getTransactionUserForOutboundRequest(this);
            if (tUser != null) {
                String outboundReqVH = tUser.getSipServletDesc().getSipApp().getVirtualHostName();
                String requestVH = this.getVirtualHost();
                if (outboundReqVH != null && requestVH != null && !outboundReqVH.equals(requestVH)) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "checkIsLoopback", "outbound request VH and current request VH are different, loopback is false");
                    }
                    return false;
                }
                isLoopback = true;
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "checkIsLoopback", "Is loopback: " + isLoopback);
        }
        return isLoopback;
    }

    private void addViaHeader() throws IllegalArgumentException, SipParseException {
        ViaHeader viaHeader;
        ListeningPoint lPoint = this.getSipProvider().getListeningPoint();
        String transport = ((ListeningPointImpl)lPoint).isSecure() ? "tls" : lPoint.getTransport();
        TransactionUserWrapper tUser = this.getTransactionUser();
        int index = -1;
        boolean outboundEnable = PropertiesStore.getInstance().getProperties().getBoolean("enableSetOutboundIF");
        if (outboundEnable) {
            index = this.getPreferedOutboundIface();
        } else {
            int n = index = null == tUser ? -1 : tUser.getPreferedOutboundIface(transport);
        }
        if (index < 0) {
            viaHeader = this.getHeadersFactory().createViaHeader(lPoint.getPort(), lPoint.getSentBy());
            viaHeader.setTransport(transport);
        } else {
            SipProxyInfo proxyInfo = SipProxyInfo.getInstance();
            SipURI sipURI = proxyInfo.getOutboundInterface(index, transport);
            viaHeader = this.getHeadersFactory().createViaHeader(sipURI.getHost(), sipURI.getPort(), transport);
        }
        viaHeader.setRPort();
        if (null == tUser && this.m_proxy != null) {
            tUser = ((SipServletRequestImpl)this.m_proxy.getOriginalRequest()).getTransactionUser();
        }
        if (null != tUser) {
            viaHeader.setParameter("ibmsid", tUser.getId());
            this.createViaBranchBasedOnIncomingRequest(viaHeader, tUser);
        }
        this.getRequest().addHeader(viaHeader, true);
    }

    protected int getPreferedOutboundIface() {
        TransactionUserWrapper tu = this.getTransactionUser();
        int outboundIface = -1;
        if (tu != null) {
            boolean isSenderOriginator = true;
            Request req = this.getRequest();
            ProxyBranchImpl proxyBranch = tu.getBranch();
            if (proxyBranch != null && (isSenderOriginator = this.isSameSender(tu.getBranch().getOriginalRequest(), req))) {
                outboundIface = proxyBranch.getPreferedOutboundIface(this.getTransport());
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getPreferedOutboundIface", "using proxy outbound interface =  " + outboundIface);
                }
            }
            if (outboundIface == -1) {
                outboundIface = isSenderOriginator ? tu.getPreferedOutboundIface(this.getTransport()) : tu.getOriginatorPreferedOutboundIface(this.getTransport());
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getPreferedOutboundIface", "using tu outbound interface =  " + outboundIface);
                }
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getPreferedOutboundIface", "outbound interface: " + outboundIface);
        }
        return outboundIface;
    }

    private void createViaBranchBasedOnIncomingRequest(ViaHeader viaHeader, TransactionUserWrapper tUser) throws SipParseException, IllegalArgumentException {
        B2buaHelper helper = this.getB2buaHelper(false, UAMode.UAC);
        if (helper == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createViaBranchBasedOnIncomingRequest", "we are not in B2b mode, branch will be created randomly on stack");
            }
            return;
        }
        SipServletRequestImpl req = (SipServletRequestImpl)helper.getLinkedSipServletRequest(this);
        if (req == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createViaBranchBasedOnIncomingRequest", "no B2B request came in, branch will be created randomly on stack");
            }
            return;
        }
        String reqViaBranch = ((ViaHeader)req.getMessage().getHeader("Via", true)).getBranch();
        if (reqViaBranch == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createViaBranchBasedOnIncomingRequest", "Incoming message had no VIA branch, branch will be created randomly on stack");
            }
            return;
        }
        if (tUser == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createViaBranchBasedOnIncomingRequest", "TransactionUser was null, branch will be created randomly on stack");
            }
            return;
        }
        StringBuffer hashedID = new StringBuffer(reqViaBranch.length() + 9);
        hashedID.append(reqViaBranch);
        hashedID.append("_");
        int result = 1;
        result = 31 * result + tUser.getSharedID().hashCode();
        result = 31 * result + (int)this.getRequest().getCSeqHeader().getSequenceNumber();
        hashedID.append(result);
        viaHeader.setBranch(hashedID.toString());
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createViaBranchBasedOnIncomingRequest", "reqViaBranch = " + reqViaBranch + ", Incoming Request: " + req.getMethod() + " incoming callid= " + req.getCallId() + ", tUser.getSharedID() = " + tUser.getSharedID() + ", getRequest().getCSeqHeader().getSequenceNumber() = " + this.getRequest().getCSeqHeader().getSequenceNumber() + ", via branch = " + viaHeader.getBranch());
        }
    }

    public void setProvider(SipURL sipURL) {
        block4: {
            String transport = null;
            String scheme = null;
            try {
                transport = sipURL.getTransport();
                scheme = sipURL.getScheme();
                if (transport == null) {
                    transport = "udp";
                }
                if (scheme.equalsIgnoreCase("sips")) {
                    transport = "tls";
                }
                this.selectProvider(transport);
            }
            catch (Exception e2) {
                if (!c_logger.isTraceDebugEnabled()) break block4;
                c_logger.traceDebug(this, "setProvider", "The following Exception has occurred: ", e2);
            }
        }
    }

    public void addCompositionHeader() throws IllegalArgumentException, SipParseException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "addCompositionHeader");
        }
        try {
            if (this.getNextApplication() != null) {
                String compositionId = UUID.randomUUID().toString();
                CompositionData compositionData = new CompositionData();
                compositionData.setInitialPoppedRoute(this.getInitialPoppedRoute());
                compositionData.setNextApplication(this.getNextApplication());
                compositionData.setRoutingDirective(this.getDirective());
                compositionData.setRoutingRegion(this.getRegion());
                compositionData.setStateInfo(this.getStateInfo());
                compositionData.setSubscriberUri(this.getSubscriberURI());
                CompositionInfoMap.getInstance().addCompositionInfo(compositionId, compositionData);
                Header compositionIdHeader = this.getHeadersFactory().createHeader("Composition-Id", compositionId);
                this.getRequest().addHeader(compositionIdHeader, true);
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("\n").append("Composition data copied to the map: \n").append("----------------- \n").append("Composition Id    = " + compositionId + " \n").append("Next application  = " + this.getNextApplication() + " \n").append("Subscriber uri    = " + this.getSubscriberURI() + " \n").append("Routing region    = " + this.getRegion() + " \n").append("Routing directive = " + (Object)((Object)this.getDirective()) + " \n\n");
                    c_logger.traceDebug(this, "addCompositionHeader", buff.toString());
                }
            }
        }
        catch (HeaderParseException e2) {
            c_logger.error(e2.getMessage());
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "addCompositionHeader");
        }
    }

    private boolean checkForApplicationComposition() {
        SipRouter router = SipContainer.getInstance().getRouter();
        String nextApplication = router.checkForApplicationComposition(this);
        if (nextApplication != null) {
            this.setNextApplication(nextApplication);
        }
        return nextApplication != null;
    }

    private CallIdHeader createCallIdHeader(String callId) throws IllegalArgumentException, SipParseException {
        if (callId == null) {
            callId = SIPStackUtil.generateCallIdentifier(this.getSipProvider().getListeningPoint().getCallIdValue());
        }
        return this.getHeadersFactory().createCallIdHeader(callId);
    }

    private ToHeader createToHeader(AddressImpl to) throws IllegalArgumentException, SipParseException {
        NameAddress nameAddress = (NameAddress)to.getNameAddressHeader().getNameAddress().clone();
        ToHeader toHeader = this.getHeadersFactory().createToHeader(nameAddress);
        this.copyParameters(to, toHeader);
        return toHeader;
    }

    private FromHeader createFromHeader(AddressImpl from) throws IllegalArgumentException, SipParseException {
        NameAddress nameAddress = (NameAddress)from.getNameAddressHeader().getNameAddress().clone();
        FromHeader fromHeader = this.getHeadersFactory().createFromHeader(nameAddress);
        this.copyParameters(from, fromHeader);
        return fromHeader;
    }

    private void copyParameters(AddressImpl jsr, EndPointHeader jain) throws IllegalArgumentException, SipParseException {
        Iterator<String> i = jsr.getParameterNames();
        while (i.hasNext()) {
            String name = i.next();
            String value = jsr.getParameter(name);
            jain.setParameter(name, value);
        }
    }

    private void testAndSetFromTag() {
        block5: {
            FromHeader from = this.getRequest().getFromHeader();
            String tag = from.getTag();
            if (null == tag || tag.trim().length() == 0) {
                tag = this.getTransactionUser().generateLocalTag();
                try {
                    from.setTag(tag);
                }
                catch (IllegalArgumentException e2) {
                    if (c_logger.isErrorEnabled()) {
                        c_logger.error("error.exception", "Create", null, (Throwable)e2);
                    }
                }
                catch (SipParseException e3) {
                    if (!c_logger.isErrorEnabled()) break block5;
                    c_logger.error("error.exception", "Create", null, (Throwable)e3);
                }
            }
        }
    }

    protected ContentTypeHeader getContentTypeHeader() throws IllegalArgumentException, SipParseException {
        ContentTypeHeader contentTypeHeader = (ContentTypeHeader)this.findHeader("Content-Type");
        return contentTypeHeader;
    }

    private jain.protocol.ip.sip.address.URI generateJainRequestURI() throws IllegalArgumentException, SipParseException, IOException {
        Address contact;
        jain.protocol.ip.sip.address.URI reqURI = null;
        TransactionUserWrapper tUser = this.getTransactionUser();
        if (null != tUser && tUser.isServerTransaction() && (contact = tUser.getContactHeader()) != null) {
            reqURI = this.createJainRequestURI(contact.getURI());
        }
        if (null == reqURI) {
            reqURI = (jain.protocol.ip.sip.address.URI)this.getRequest().getToHeader().getNameAddress().getAddress().clone();
            if (this.getMethod().equalsIgnoreCase("REGISTER") && reqURI instanceof SipURL) {
                ((SipURL)reqURI).removeUserName();
                ((SipURL)reqURI).removeUserPassword();
                ((SipURL)reqURI).removeUserType();
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "generateJainRequestURI", "createdURI: " + reqURI);
        }
        if (null == reqURI) {
            String err = "Failed to generate a URI for the outgoing request";
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "generateJainRequestURI", err);
            }
            throw new IOException(err);
        }
        return reqURI;
    }

    @Override
    public URI getRequestURI() {
        URI reqUri = super.getRequestURI();
        if (null == reqUri) {
            try {
                jain.protocol.ip.sip.address.URI reqURI = this.generateJainRequestURI();
                this.getRequest().setRequestURI(reqURI);
                reqUri = super.getRequestURI();
            }
            catch (IllegalArgumentException e2) {
                this.logException(e2);
            }
            catch (SipParseException e3) {
                this.logException(e3);
            }
            catch (IOException e4) {
                this.logException(e4);
            }
        }
        return reqUri;
    }

    @Override
    Address getLocalParty() {
        return this.getFrom();
    }

    @Override
    Address getRemoteParty() {
        return this.getTo();
    }

    @Override
    public SipServletRequest createCancel() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "createCancel");
        }
        if (!this.isLiveMessage("createCancel")) {
            return null;
        }
        if (!this.isCommitted()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createCancel", "Can not cancel an outgoing request that is not commited");
            }
            throw new IllegalStateException("Can not cancel an outgoing request that is not commited");
        }
        if (this.getTransaction().isTerminated()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createCancel", "Can not cancel an outgoing request when transaction is terminated");
            }
            throw new IllegalStateException("Can not cancel an outgoing request when transaction is terminated");
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "createCancel");
        }
        return new OutgoingSipServletCancelRequest(this);
    }

    @Override
    public SipServletResponse createResponse(int statusCode, String reasonPhrase) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createResponse", "Can not create a response for outgoing request");
        }
        throw new IllegalStateException("Can not create responses for locally generated requests");
    }

    @Override
    public SipServletResponse createResponse(int statuscode) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createResponse", "Can not create a response for outgoing request");
        }
        throw new IllegalStateException("Can not create responses for locally generated requests");
    }

    public void setAddrHeader(String name, Address addr) {
        super.setAddressHeader(name, addr);
    }

    @Override
    public void addHeader(String name, String value) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        this.checkIsLegalHeader(name);
        this.checkNewHeader(name, value);
        this.addHeaderImpl(name, value, false);
    }

    public void addHeaderToFromAllowed(String name, List<String> values, boolean allowToFromChange) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)OutgoingSipServletRequest.class.getName(), "addHeaderToFromAllowed", name, values, allowToFromChange);
        }
        if (allowToFromChange) {
            if ("From".equalsIgnoreCase(name)) {
                block13: {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "addHeaderToFromAllowed", "adding From header without tag part");
                    }
                    String tag = this.getRequest().getFromHeader().getTag();
                    if (values.size() > 1) {
                        throw new IllegalArgumentException("Illegal operation, Trying to set more than one From header value");
                    }
                    String value = values.get(0);
                    this.removeHeader("From", false);
                    this.addHeaderImpl("From", value, true);
                    this.getRequest().getFromHeader().removeTag();
                    try {
                        this.getRequest().getFromHeader().setTag(tag);
                    }
                    catch (IllegalArgumentException e2) {
                        throw e2;
                    }
                    catch (SipParseException e3) {
                        if (!c_logger.isErrorEnabled()) break block13;
                        c_logger.error("setting tag failed", null, null, (Throwable)e3);
                    }
                }
                return;
            }
            if (name.equals("To")) {
                if (values.size() > 1) {
                    throw new IllegalArgumentException("Illegal operation, Trying to set more than one To header value");
                }
                String value = values.get(0);
                this.removeHeader("To", false);
                this.addHeaderImpl(name, value, false);
                this.getRequest().getToHeader().removeTag();
                return;
            }
        }
        if (!"Route".equalsIgnoreCase(name)) {
            this.checkIsLegalHeader(name);
            this.removeHeader(name, false);
        }
        for (String value : values) {
            this.checkNewHeader(name, value);
            this.addHeaderImpl(name, value, false);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(OutgoingSipServletRequest.class.getName(), "addHeaderToFromAllowed");
        }
    }

    private void addHeaderImpl(String name, String value, boolean first) {
        block6: {
            if (this.isCommitted()) {
                if (c_logger.isTraceDebugEnabled() && c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "addHeaderImpl", "addHeader failed, Request already Commited");
                }
                return;
            }
            try {
                Header header = this.getHeadersFactory().createHeader(name, value);
                this.addHeader(header, first);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{name, value};
                    c_logger.error("error.add.header", "Request", args, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block6;
                Object[] args = new Object[]{name, value};
                c_logger.error("error.add.header", "Request", args, (Throwable)e3);
            }
        }
    }

    public void checkNewHeader(String name, String value) {
        if (name.equalsIgnoreCase("Require") && value.equals("100rel") && !this.getMethod().equals("INVITE") && !this.getMethod().equals("PRACK")) {
            throw new IllegalStateException("Illegal operation, 100rel can be requiered only for INVITE");
        }
    }

    @Override
    public void setHeader(String name, String value, boolean checkIsLegalHeader) {
        if (this.isCommitted()) {
            if (this.isJSR289Application()) {
                throw new IllegalStateException("Can not modify committed message");
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setHeader", "setHeader failed, Request already Committed");
            }
            return;
        }
        this.checkNewHeader(name, value);
        super.setHeader(name, value, checkIsLegalHeader);
    }

    @Override
    public void removeHeader(String name) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "removeHeader", (Object)name);
        }
        if (this.isCommitted()) {
            if (this.isJSR289Application()) {
                throw new IllegalStateException("Can not modify committed message");
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "removeHeader", "removeHeader failed, Request already Committed");
            }
            return;
        }
        if ("Contact".equalsIgnoreCase(name)) {
            this.m_contactRemovedByApp = true;
        }
        this.removeHeader(name, true);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "removeHeader");
        }
    }

    public void setClientTransactionListener(ClientTransactionListener listener) {
        this.m_clientTransactionListener = listener;
    }

    @Override
    public Proxy getProxy(boolean create) throws TooManyHopsException {
        if (!this.isLiveMessage("getProxy")) {
            return null;
        }
        if (this.m_proxy != null) {
            return this.m_proxy;
        }
        return super.getProxy(create);
    }

    public void setProxy(Proxy proxy) {
        if (!this.isLiveMessage("setProxy")) {
            return;
        }
        this.m_proxy = proxy;
    }

    public void setIsSubsequentRequest(boolean isSubsequentRequest) {
        this.m_isSubsequentRequest = isSubsequentRequest;
    }

    Header getDestinationURI() {
        return this.m_destinationHeader;
    }

    Header getPreferredOutbound() {
        return this.m_preferredOutbound;
    }

    @Override
    protected void updateUnCommittedMessagesList(boolean isCommited) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addContactHeader(SipURI sipURI) throws IllegalArgumentException, SipParseException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{sipURI};
            c_logger.traceEntry((Object)OutgoingSipServletRequest.class.getName(), "addContactHeader", params);
        }
        try {
            if (this.m_contactRemovedByApp) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "addContactHeader", "Can't addContactHeader, contact explicitly removed by App");
                }
                return;
            }
            String method = this.getMethod();
            if (SipUtil.shouldContainContact(method)) {
                Request req = this.getRequest();
                if (req.getHeader("Contact", true) != null && !this.m_isDefaultContactHeader) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "addContactHeader", "Can't addContactHeader, contact exist");
                    }
                    return;
                }
                this.createAndSetContactHeader(req, sipURI, true);
            }
        }
        finally {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)OutgoingSipServletRequest.class.getName(), "addContactHeader", this.getContactHeader());
            }
        }
    }

    @Override
    protected void setContactScheme(SipURL sipUrl) throws IllegalArgumentException, SipParseException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        if (sipUrl.getScheme().equalsIgnoreCase("sip")) {
            boolean secure = false;
            if (this.getRequestURI() != null && this.getRequestURI().getScheme().equalsIgnoreCase("sips")) {
                secure = true;
            } else {
                String scheme;
                RouteHeader topRoute = (RouteHeader)this.findHeader("Route");
                if (topRoute != null && (scheme = topRoute.getNameAddress().getAddress().getScheme()).equalsIgnoreCase("sips")) {
                    secure = true;
                }
            }
            if (secure) {
                sipUrl.setScheme("sips");
            }
        }
    }

    @Override
    public void setRoutingDirective(SipApplicationRoutingDirective directive, SipServletRequest origRequest) {
        if (directive.equals((Object)SipApplicationRoutingDirective.CONTINUE) || directive.equals((Object)SipApplicationRoutingDirective.REVERSE)) {
            if (origRequest != null && !origRequest.isInitial()) {
                throw new IllegalStateException("Can't set CONTINUE or REVERSE directive when  origRequest is not initial");
            }
            if (origRequest != null) {
                this.setStateInfo(((SipServletRequestImpl)origRequest).getStateInfo());
            }
        }
        if (directive.equals((Object)SipApplicationRoutingDirective.NEW)) {
            this.setStateInfo(null);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("setRoutingDirective: " + (Object)((Object)directive));
        }
        this.setDirective(directive);
    }

    @Override
    public B2buaHelper getB2buaHelper() throws IllegalStateException {
        return this.getB2buaHelper(true, UAMode.UAC);
    }

    @Override
    protected boolean shouldCreateContactIfNotExist() {
        return true;
    }

    public boolean isMarkedForErrorResponse() {
        return this.markedForErrorResponse;
    }

    public void setMarkedForErrorResponse(boolean markedForErrorResponse) {
        this.markedForErrorResponse = markedForErrorResponse;
    }

    @Override
    public void imitateInitialForComposition() {
        this.setIsInital(true);
    }

    @Override
    public void cleanInitialForComposition() {
        this.setIsInital(false);
    }

    @Override
    public void cleanExpiredCompositionHeaders() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("cleanExpiredCompositionHeaders. CallID=" + this.getCallId());
        }
        this.removeHeader("Composition-Id");
    }

    @Override
    public void processCompositionErrorResponse() {
        this.setMarkedForErrorResponse(true);
    }

    @Override
    public String getAppInvokedName() {
        return this.appInvokedName;
    }

    @Override
    public void setAppInvokedName(String appInvokedName) {
        this.appInvokedName = appInvokedName;
    }

    @Override
    public boolean isAppInvoked116Type() {
        return this.appInvokedName != null;
    }

    @Override
    public Proxy getProxy() {
        return null;
    }

    public void setupRequestUri() throws IOException {
        try {
            Request req = this.getRequest();
            jain.protocol.ip.sip.address.URI reqURI = req.getRequestURI();
            if (reqURI == null) {
                if (this.m_isSubsequentRequest) {
                    TransactionUserWrapper tu = this.getTransactionUser();
                    String sessionId = tu == null ? "null" : tu.getId();
                    throw new IllegalStateException("no remote contact for sending in-dialog request [" + req.getCallIdHeader() + "] session [" + sessionId + ']');
                }
                reqURI = this.generateJainRequestURI();
                req.setRequestURI(reqURI);
            }
        }
        catch (SipParseException e2) {
            if (c_logger.isErrorEnabled()) {
                Object[] args = new Object[]{this};
                c_logger.error("error.send.request", "Request", args, (Throwable)e2);
            }
            this.logExceptionToSessionLog(0x100004, e2);
            throw new IOException(e2.getMessage());
        }
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public AsyncContext startAsync() {
        return null;
    }

    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) {
        return null;
    }
}

