/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.extensions.RAckHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.RSeqHeader;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletAckRequest;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.header.ContactHeader;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.message.Response;
import java.io.IOException;
import javax.servlet.sip.Address;
import javax.servlet.sip.Rel100Exception;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.UAMode;

public class IncomingSipServletResponse
extends SipServletResponseImpl {
    static final long serialVersionUID = 4841030986553876807L;
    private static final LogMgr c_logger = Log.get(IncomingSipServletResponse.class);
    private boolean m_ackCreated;

    public IncomingSipServletResponse() {
    }

    public IncomingSipServletResponse(Response response, long transactionId, SipProvider provider) {
        super(response, transactionId, provider);
        if (this.isReliableResponse()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "IncomingSipServletResponse", "the message is an incoming reliable provisional response, and there for un-committed");
            }
            this.setIsCommited(false);
        } else if (this.getStatus() >= 200 && this.getStatus() < 300 && response.getCSeqHeader().getMethod().equals("INVITE")) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "IncomingSipServletResponse", "message is an incoming final response to an INVITE transaction - set un-committed stated");
            }
            this.setIsCommited(false);
        }
    }

    @Override
    public SipSession getProxySession(boolean create) {
        return this.getTransactionUser().getSipSession(create);
    }

    @Override
    Address getLocalParty() {
        return this.getTo();
    }

    @Override
    Address getRemoteParty() {
        return this.getFrom();
    }

    @Override
    public void send() throws IOException {
        String err = "Can not send a Committed Response";
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "send", err);
        }
        throw new IllegalStateException(err);
    }

    @Override
    public void sendReliably() throws Rel100Exception {
        if (!this.isLiveMessage("sendReliably")) {
            return;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "sendReliably", "Can not send a Committed Response");
        }
        throw new Rel100Exception(3);
    }

    @Override
    public SipServletRequest createPrack() throws Rel100Exception {
        this.setIsCommited(true);
        if (!this.isReliableResponse()) {
            throw new Rel100Exception(3);
        }
        SipServletRequestImpl prackReq = (SipServletRequestImpl)this.getTransactionUser().createRequest("PRACK");
        try {
            RSeqHeader h = (RSeqHeader)this.getResponse().getHeader("RSeq", true);
            long rSeq = 0L;
            if (h != null) {
                rSeq = h.getResponseNumber();
            }
            CSeqHeader ch = (CSeqHeader)this.getResponse().getHeader("CSeq", true);
            long cSeq = 0L;
            if (h != null) {
                cSeq = ch.getSequenceNumber();
            }
            RAckHeaderImpl rack = new RAckHeaderImpl();
            rack.setResponseNumber(rSeq);
            rack.setSequenceNumber(cSeq);
            rack.setMethod(this.getRequest().getMethod());
            prackReq.getRequest().setHeader(rack, true);
        }
        catch (HeaderParseException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "ReliableResponse", "Somthing was wrong in the RSeqHeader");
            }
            throw new IllegalStateException("Corrupted RSeqHeader in incoming response");
        }
        catch (IllegalArgumentException e3) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "ReliableResponse", "Corrupted RSeqHeader in incoming response");
            }
            throw new IllegalStateException("Corrupted RSeqHeader in incoming response");
        }
        catch (SipParseException e4) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "ReliableResponse", "Failed to generate RSeq header");
            }
            throw new IllegalStateException("Failed to generate RSeq header");
        }
        return prackReq;
    }

    @Override
    public SipServletRequest createAck() {
        block6: {
            if (!this.isLiveMessage("createAck")) {
                return null;
            }
            if (!this.getMethod().equals("INVITE")) {
                throw new IllegalStateException("ACK can only be created for INVITE requests");
            }
            if (this.m_ackCreated) {
                throw new IllegalStateException("ACK can only be generated once per response");
            }
            try {
                if (this.getRequest().getProxy(false) != null) {
                    throw new IllegalStateException("ACK Cannot be generated by the application in proxy mode");
                }
            }
            catch (TooManyHopsException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block6;
                c_logger.traceDebug(this, "createAck", "Cannot get proxy object - Too many hops");
            }
        }
        this.setIsCommited(true);
        OutgoingSipServletAckRequest ack = new OutgoingSipServletAckRequest(this);
        this.m_ackCreated = true;
        return ack;
    }

    @Override
    public String getLocalAddr() {
        if (this._isInternallyGenerated) {
            return null;
        }
        if (null == this.m_localAddr) {
            try {
                this.parseTransport();
            }
            catch (HeaderParseException e2) {
                this.log("getLocaleAddr", "Unable to get local transport", e2);
            }
        }
        return this.m_localAddr;
    }

    @Override
    public int getLocalPort() {
        if (this._isInternallyGenerated) {
            return -1;
        }
        if (-1 == this.m_localPort) {
            try {
                this.parseTransport();
            }
            catch (HeaderParseException e2) {
                this.log("getLocalPort", "Unable to get local transport", e2);
            }
        }
        return this.m_localPort;
    }

    @Override
    public String getTransport() {
        if (!this.isLiveMessage("getTransport")) {
            return null;
        }
        return this.getSipProvider().getListeningPoint().getTransport();
    }

    @Override
    public String getRemoteAddr() {
        if (this._isInternallyGenerated) {
            return null;
        }
        if (null == this.m_remoteAddr) {
            try {
                this.parseTransport();
            }
            catch (HeaderParseException e2) {
                this.log("getRemoteAddr", "Unable to get remote transport", e2);
            }
        }
        return this.m_remoteAddr;
    }

    @Override
    public int getRemotePort() {
        if (this._isInternallyGenerated) {
            return -1;
        }
        if (-1 == this.m_remotePort) {
            try {
                this.parseTransport();
            }
            catch (HeaderParseException e2) {
                this.log("getRemotePort", "Unable to get remote transport", e2);
            }
        }
        return this.m_remotePort;
    }

    @Override
    protected void updateUnCommittedMessagesList(boolean isCommited) {
        TransactionUserWrapper transactionUser = this.getTransactionUser();
        if (isCommited) {
            transactionUser.removeB2BPendingMsg(this, UAMode.UAC);
        } else {
            transactionUser.addB2BPendingMsg(this, UAMode.UAC);
        }
    }

    protected ContactHeader createContactHeader() throws SipParseException {
        return null;
    }

    @Override
    protected boolean shouldCreateContactIfNotExist() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "shouldCreateContactIfNotExist", "shouldn't create contact on incoming response");
        }
        return false;
    }

    public void setInternal(boolean isInternal) {
        this._isInternallyGenerated = isInternal;
    }
}

