/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.security;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.ViaHeader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.servlet.sip.SipServletMessage;

public class IPAuthenticator {
    private static final LogMgr c_logger = Log.get(IPAuthenticator.class);
    private static IPAuthenticator s_instance = null;
    private InetAddress[] m_ips = null;
    private int[] m_masks = null;
    private int[] m_subnets = null;
    private boolean m_hasCheck = false;

    private static int ip2Int(InetAddress address) {
        byte[] bytes = address.getAddress();
        int j = 0;
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            j <<= 8;
            k = bytes[i];
            if (k < 0) {
                k += 256;
            }
            j += k;
        }
        return j;
    }

    private static String int2Ip(int ip) throws UnknownHostException {
        byte[] bytes = new byte[]{0, 0, 0, 0};
        for (int i = 0; i < 4; ++i) {
            bytes[3 - i] = (byte)ip;
            ip >>= 8;
        }
        return InetAddressCache.getHostAddress(InetAddress.getByAddress(bytes));
    }

    private void parseList(String ipList) {
        int i;
        ArrayList<InetAddress> ips = new ArrayList<InetAddress>(2);
        ArrayList<Integer> masks = new ArrayList<Integer>(2);
        ArrayList<Integer> subnets = new ArrayList<Integer>(2);
        StringTokenizer ipListTokenizer = new StringTokenizer(ipList, ",");
        String token = null;
        int index = -1;
        while (ipListTokenizer.hasMoreTokens()) {
            token = ipListTokenizer.nextToken();
            index = (token = token.trim()).indexOf(47);
            if (index == -1) {
                try {
                    InetAddress address = InetAddressCache.getByName(token);
                    ips.add(address);
                }
                catch (Exception e2) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "IPAuthenticator", "not valid address [" + token + "]");
                    }
                    System.out.println("IPAuthenticator - not valid address [" + token + "]");
                }
                continue;
            }
            String ip = token.substring(0, index);
            String mask = token.substring(index + 1);
            try {
                int intIp = IPAuthenticator.ip2Int(InetAddressCache.getByName(ip));
                int intMask = IPAuthenticator.ip2Int(InetAddressCache.getByName(mask));
                int intSubnet = intIp & intMask;
                masks.add(new Integer(intMask));
                subnets.add(new Integer(intSubnet));
            }
            catch (UnknownHostException e3) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.ip.host", "Start", null, (Throwable)e3);
                }
                System.out.println("IPAuthenticator - not valid subnet [" + ip + "/" + mask + "]");
            }
            catch (Exception e4) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "IPAuthenticator", "not valid subnet [" + ip + "/" + mask + "]");
                }
                System.out.println("IPAuthenticator - not valid subnet [" + ip + "/" + mask + "]");
            }
        }
        int len = ips.size();
        this.m_ips = new InetAddress[len];
        for (i = 0; i < len; ++i) {
            this.m_ips[i] = (InetAddress)ips.get(i);
        }
        len = masks.size();
        this.m_masks = new int[len];
        this.m_subnets = new int[len];
        for (i = 0; i < len; ++i) {
            this.m_masks[i] = (Integer)masks.get(i);
            this.m_subnets[i] = (Integer)subnets.get(i);
        }
    }

    private IPAuthenticator() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "<init>");
        }
        String ipList = PropertiesStore.getInstance().getProperties().getString("trustedIpList");
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "IPAuthenticator", "iplist=[" + ipList + "]");
        }
        if (ipList != null) {
            this.parseList(ipList);
            if (this.m_ips != null || this.m_subnets != null) {
                this.m_hasCheck = true;
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "<init>");
        }
    }

    private IPAuthenticator(String ipList) {
        this.parseList(ipList);
    }

    private static boolean checkIp(String ip) {
        block6: {
            try {
                int i;
                InetAddress address = InetAddressCache.getByName(ip);
                int intIp = IPAuthenticator.ip2Int(address);
                for (i = 0; i < IPAuthenticator.s_instance.m_masks.length; ++i) {
                    int tmp = intIp & IPAuthenticator.s_instance.m_masks[i];
                    if (tmp != IPAuthenticator.s_instance.m_subnets[i]) continue;
                    return true;
                }
                for (i = 0; i < IPAuthenticator.s_instance.m_ips.length; ++i) {
                    String ip2;
                    String ip1 = InetAddressCache.getHostAddress(address);
                    if (ip1.equals(ip2 = InetAddressCache.getHostAddress(IPAuthenticator.s_instance.m_ips[i]))) {
                        return true;
                    }
                    if (PropertiesStore.getInstance().getProperties().getBoolean("ipAuthenticatorCheckHostName")) {
                        if (!address.getHostName().equals(IPAuthenticator.s_instance.m_ips[i].getHostName())) continue;
                        return true;
                    }
                    if (!c_logger.isTraceDebugEnabled()) continue;
                    c_logger.traceDebug(IPAuthenticator.class, "checkIp", "skipping host name comparison");
                }
            }
            catch (UnknownHostException e2) {
                if (!c_logger.isErrorEnabled()) break block6;
                c_logger.error("error.ip.host", "Start", null, (Throwable)e2);
            }
        }
        return false;
    }

    public static boolean isIPAuthenticated(SipServletMessage message) {
        SipServletMessageImpl msg;
        HeaderIterator viaHeaders;
        if (IPAuthenticator.s_instance.m_hasCheck && (viaHeaders = (msg = (SipServletMessageImpl)message).getMessage().getViaHeaders()) != null) {
            for (int i = 0; i < 2; ++i) {
                if (!viaHeaders.hasNext()) continue;
                try {
                    ViaHeader via = (ViaHeader)viaHeaders.next();
                    String host = via.getHost();
                    boolean checkVia = IPAuthenticator.checkIp(host);
                    if (checkVia) {
                        return true;
                    }
                    continue;
                }
                catch (HeaderParseException e2) {
                    if (!c_logger.isErrorEnabled()) continue;
                    c_logger.error("error.ip.header.parse", "Start", null, (Throwable)e2);
                    continue;
                }
                catch (NoSuchElementException e3) {
                    if (!c_logger.isErrorEnabled()) continue;
                    c_logger.error("error.ip.header.exception", "Start", null, (Throwable)e3);
                }
            }
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(IPAuthenticator.checkIp("121.55.44.33"));
        System.out.println(IPAuthenticator.checkIp("10.10.1.1"));
        System.out.println(IPAuthenticator.checkIp("122.55.44.33"));
        System.out.println(IPAuthenticator.checkIp("192.168.12.3"));
        System.out.println(IPAuthenticator.checkIp("192.168.13.1"));
        System.out.println(IPAuthenticator.checkIp("192.161.1.2"));
        System.out.println(IPAuthenticator.checkIp("192.162.5.5"));
        System.out.println(IPAuthenticator.checkIp("192.161.133.122"));
    }

    static {
        s_instance = new IPAuthenticator();
    }
}

