/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.router.tasks;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.router.tasks.RoutedTask;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.transaction.ClientTransaction;
import com.ibm.ws.sip.container.transaction.ServerTransaction;
import com.ibm.ws.sip.container.transaction.SipTransaction;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import javax.servlet.sip.SipApplicationSession;

public class ResponseRoutedTask
extends RoutedTask {
    private static final LogMgr c_logger = Log.get(ResponseRoutedTask.class);
    private SipTransaction _transaction;
    private SipServletResponseImpl _response;
    private boolean _isOnClientTransaction = false;

    public static ResponseRoutedTask getInstance(SipTransaction transaction, TransactionUserWrapper transactionUser, SipServletResponseImpl response) {
        return new ResponseRoutedTask(transaction, transactionUser, response);
    }

    public static ResponseRoutedTask getInstance(SipTransaction transaction, String sessionId, SipServletResponseImpl response) {
        return new ResponseRoutedTask(transaction, sessionId, response);
    }

    public ResponseRoutedTask(SipTransaction transaction, TransactionUserWrapper transactionUser, SipServletResponseImpl response) {
        super(transactionUser);
        this._response = response;
        this._transaction = transaction;
        this._isOnClientTransaction = this._transaction instanceof ClientTransaction;
        if (this._transactionUser == null && this._isOnClientTransaction) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "ResponseRoutedTask", "Could not locate TU, executing task on current thread");
            }
            this.setForDispatching(false);
        }
    }

    public ResponseRoutedTask(SipTransaction transaction, String sessionId, SipServletResponseImpl response) {
        super(sessionId);
        this._response = response;
        this._transaction = transaction;
        this._isOnClientTransaction = this._transaction instanceof ClientTransaction;
    }

    @Override
    protected void doTask() {
        boolean isTransInvalidating = false;
        if (this._transactionUser != null && this._transactionUser.isInvalidating()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "doTask", "got response on invalidating server transaction: " + this._transaction);
            }
            isTransInvalidating = true;
        }
        if (this._isOnClientTransaction) {
            ClientTransaction clientTransaction = (ClientTransaction)this._transaction;
            this._response.setTransaction(this._transaction);
            if (isTransInvalidating) {
                if (this._response.getStatus() >= 200) {
                    clientTransaction.onFinalResponse(this._response);
                }
            } else {
                clientTransaction.processResponse(this._response);
            }
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "doTask", "got response on server transaction: " + this._transaction);
            }
            ServerTransaction serverTransaction = (ServerTransaction)this._transaction;
            serverTransaction.processTimeout();
        }
    }

    @Override
    public String getMethod() {
        return this._response.getMethod();
    }

    @Override
    public int priority() {
        return 100;
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        return this._response.getApplicationSession(false);
    }

    @Override
    public TransactionUserWrapper getTuWrapper() {
        if (this._transactionUser == null) {
            return this._response.getTransactionUser();
        }
        return this._transactionUser;
    }
}

