/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.proxy;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.proxy.RecordRouteProxy;
import com.ibm.ws.sip.container.servlets.IncomingSipServletRequest;
import com.ibm.ws.sip.container.servlets.IncomingSipServletResponse;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.transaction.ClientTransactionListener;
import com.ibm.ws.sip.container.util.SipUtil;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.SipURL;
import javax.servlet.sip.SipServletRequest;

public class SubsequentRequestListener
implements ClientTransactionListener {
    private static final LogMgr c_logger = Log.get(SubsequentRequestListener.class);
    private IncomingSipServletRequest _originalRequest;
    private SipURL _latestDestination;

    protected SubsequentRequestListener(SipServletRequest request) {
        this._originalRequest = (IncomingSipServletRequest)request;
    }

    @Override
    public void processResponse(SipServletResponseImpl response) {
        RecordRouteProxy.proxyResponse(this._originalRequest, response);
    }

    @Override
    public void processTimeout(SipServletRequestImpl request) {
        IncomingSipServletResponse response;
        block5: {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processTimeout", "Subsequent request timedout: " + this._originalRequest);
            }
            response = null;
            try {
                response = SipUtil.createResponse(408, request);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.exception", "Create", null, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block5;
                c_logger.error("error.exception", "Create", null, (Throwable)e3);
            }
        }
        RecordRouteProxy.proxyResponse(this._originalRequest, response);
    }

    @Override
    public void processCompositionError(SipServletRequestImpl request) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "processCompositionError", "Subsequent request should not be there: " + this._originalRequest);
        }
    }

    @Override
    public boolean onSendingRequest(SipServletRequestImpl request) {
        return request.getTransactionUser().onSendingRequest(request);
    }

    @Override
    public void clientTransactionTerminated(SipServletRequestImpl request) {
        request.getTransactionUser().clientTransactionTerminated(request);
    }

    @Override
    public void setUsedDestination(SipURL lastUsedDestination) {
        this._latestDestination = lastUsedDestination;
    }

    @Override
    public SipURL getUsedDestination() {
        return this._latestDestination;
    }

    @Override
    public void removeTransaction(String method) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeTransaction", "removeTransaction from TU = " + this._originalRequest.getTransactionUser().getId());
        }
        this._originalRequest.getTransactionUser().removeTransaction(method);
    }

    @Override
    public void addTransaction(String method) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addTransaction", "add transaction to TU = " + this._originalRequest.getTransactionUser().getId());
        }
        this._originalRequest.getTransactionUser().addTransaction(method);
    }
}

