/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.proxy;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.proxy.ProxyBranchImpl;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.timer.BaseTimer;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import javax.servlet.sip.SipApplicationSession;

public class ProxyBranchTimer
extends BaseTimer {
    private static final LogMgr c_logger = Log.get(ProxyBranchTimer.class);
    private ProxyBranchImpl _branch;
    SipServletRequestImpl _origReqImp;

    public ProxyBranchTimer(ProxyBranchImpl branch) {
        this._branch = branch;
        this._origReqImp = (SipServletRequestImpl)this._branch.getOriginalRequest();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "ProxyBranchTimer", "Created For Branch: " + branch);
        }
        this.setQueueIndex(this.extractQueueIndex());
    }

    @Override
    protected int extractQueueIndex() {
        int result = -1;
        if (this._origReqImp != null) {
            TransactionUserWrapper tuImpl = this._origReqImp.getTransactionUser();
            if (tuImpl != null) {
                String sessId = tuImpl.getApplicationId();
                result = SipApplicationSessionImpl.extractAppSessionCounter(sessId);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceEntry(this, "getQueueIndex - sessId = " + sessId + " QueueIndex result = " + result);
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "getQueueIndex - can't find the appropriate TU for incoming request ...");
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "getQueueIndex - can't find incoming request ...");
        }
        return result;
    }

    @Override
    public void run() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "run");
        }
        this._branch.proxyBranchTimeout();
    }

    @Override
    public String getAppName() {
        SipApplicationSessionImpl sApp;
        if (this._origReqImp != null && (sApp = (SipApplicationSessionImpl)this._origReqImp.getApplicationSession()) != null && sApp.getAppDescriptor() != null) {
            return sApp.getAppDescriptor().getAppName();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted origReqImp is null...");
        }
        return null;
    }

    @Override
    public Integer getAppIndexForPMI() {
        SipApplicationSessionImpl sApp;
        if (this._origReqImp != null && (sApp = (SipApplicationSessionImpl)this._origReqImp.getApplicationSession()) != null && sApp.getAppDescriptor() != null) {
            return sApp.getAppDescriptor().getAppIndexForPmi();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted origReqImp is null...");
        }
        return null;
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        if (this._origReqImp != null) {
            return this._origReqImp.getApplicationSession();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted origReqImp is null...");
        }
        return null;
    }

    @Override
    public TransactionUserWrapper getTuWrapper() {
        if (this._branch != null && this._branch.isCancelled()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "Related ProxyBranch was already canceled. Timeout is irrelevant.");
            }
            return null;
        }
        if (this._origReqImp != null) {
            SipSessionImplementation sSession = (SipSessionImplementation)this._origReqImp.getSession();
            if (sSession != null) {
                return sSession.getInternalTuWrapper();
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted origReqImp is null...");
        }
        return null;
    }
}

