/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.pmi.taskduration;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;

public class TaskDurationCounter {
    private int _totalTasks = 0;
    private long _totalTime = 0L;
    private long _avgTaskDuration = 0L;
    private long _maxTaskDuration = 0L;
    private long _minTaskDuration = 0L;
    private static final LogMgr s_logger = Log.get(TaskDurationCounter.class);

    public synchronized void updateTaskDurationStatistics(long ms) {
        ++this._totalTasks;
        this._totalTime += ms;
        if (this._totalTasks == 1) {
            this._maxTaskDuration = ms;
        } else if (ms > this._maxTaskDuration) {
            this._maxTaskDuration = ms;
        }
        if (this._totalTasks == 1) {
            this._minTaskDuration = ms;
        } else if (ms < this._minTaskDuration) {
            this._minTaskDuration = ms;
        }
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "updateTaskDurationStatistics", "task duration average = " + this._avgTaskDuration + " min task duration = " + this._minTaskDuration + " max task duration = " + this._maxTaskDuration + " total tasks = " + this._totalTasks + " total time = " + this._totalTime);
        }
    }

    public synchronized long getAvgTaskDurationOut() {
        this._avgTaskDuration = this._totalTime == 0L || this._totalTasks == 0 ? 0L : (long)((float)this._totalTime / (float)this._totalTasks);
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "getAvgTaskDurationOut", "task duration average = " + this._avgTaskDuration + " total tasks = " + this._totalTasks + " total time = " + this._totalTime);
        }
        return this._avgTaskDuration;
    }

    public synchronized long getMaxTaskDurationOut() {
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "getMaxTaskDurationOut", "maximum task duration = " + this._maxTaskDuration);
        }
        return this._maxTaskDuration;
    }

    public synchronized long getMinTaskDurationOut() {
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "getMinTaskDurationOut", "minimum task duration = " + this._minTaskDuration);
        }
        return this._minTaskDuration;
    }

    public synchronized void init() {
        this._totalTasks = 0;
        this._totalTime = 0L;
        this._avgTaskDuration = 0L;
        this._maxTaskDuration = 0L;
        this._minTaskDuration = 0L;
    }
}

