/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.pmi;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;

public class TaskDurationMeasurer {
    private long _startTime = 0L;
    private long _totalTime = 0L;
    private static final LogMgr c_logger = Log.get(TaskDurationMeasurer.class);

    public void startMeasuring() {
        PerformanceMgr perfMgr;
        if (this._startTime != 0L && c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "startMeasuring", "TaskDurationMeasurer was already initialized before, initializing again");
        }
        if ((perfMgr = PerformanceMgr.getInstance()) != null) {
            this._startTime = perfMgr.getCurrentCachedTime();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "startMeasuring", " getCurrentCachedTime = " + this._startTime);
            }
        }
    }

    public long takeTimeMeasurement() {
        PerformanceMgr perfMgr = PerformanceMgr.getInstance();
        if (perfMgr == null) {
            return 0L;
        }
        long currentTime = perfMgr.getCurrentCachedTime();
        if (this._startTime == 0L) {
            return 0L;
        }
        this._totalTime = currentTime - this._startTime;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "takeTimeMeasurement", " meassured task duration = " + this._totalTime);
        }
        return this._totalTime;
    }
}

