/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.pmi;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.container.load.ApplicationQueueCounter;
import com.ibm.ws.sip.container.load.ApplicationSessionCounter;
import com.ibm.ws.sip.container.load.ConcurentLoadListener;
import com.ibm.ws.sip.container.load.DisabledCounter;
import com.ibm.ws.sip.container.load.MPAPCounter;
import com.ibm.ws.sip.container.load.ResponseTimeCounter;
import com.ibm.ws.sip.container.load.Weighable;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.pmi.CachedTimerService;
import com.ibm.ws.sip.container.pmi.LoadManager;
import com.ibm.ws.sip.container.pmi.LoadedApplicationsContainer;
import com.ibm.ws.sip.container.pmi.PerfUtil;
import com.ibm.ws.sip.container.pmi.basic.SipContainerCounter;
import com.ibm.ws.sip.container.pmi.listener.ApplicationsPMIListener;
import com.ibm.ws.sip.container.pmi.listener.SipContainerPMIListener;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.properties.SipPropertiesMap;
import com.ibm.ws.sip.stack.util.StackExternalizedPerformanceMgr;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={PerformanceMgr.class}, configurationPolicy=ConfigurationPolicy.OPTIONAL, name="com.ibm.ws.sip.container.pmi", configurationPid={"com.ibm.ws.sip.container.pmi"}, property={"service.vendor=IBM"})
public class PerformanceMgr
implements ConcurentLoadListener,
StackExternalizedPerformanceMgr {
    private static final TraceComponent tc = Tr.register(PerformanceMgr.class);
    private static final LogMgr c_logger = Log.get(PerformanceMgr.class);
    private int _statUpdateRange = 10000;
    private int _loadUpdatePeriod = 1000;
    private int _statAveragePeriod = 1000;
    private SipContainerPMIListener _pmiModule = null;
    private ApplicationsPMIListener _appsPMIModule = null;
    public static final String _appName = "SipContainer";
    private long _receivedMsgCounter = 0L;
    private long _newSipAppCounter = 0L;
    private long _summaryResponseTime = 0L;
    private long _responcesCounter = 0L;
    private long _rejectedMessagesCounter = 0L;
    private long _sipTimersInvocations = 0L;
    private int _maxSipAppSessionsAllowed = 120000;
    private int _maxMessageRate = 5000;
    private int _maxResponseTime = 0;
    private int _maxMsgQueueSize = 1000;
    private LoadedApplicationsContainer _applicationsContainer;
    private SipContainerCounter _commonCounter = new SipContainerCounter();
    private Weighable[] _loadCounters;
    private static PerformanceMgr s_singleton = null;
    private boolean _isOverloadProtectionEnabled = true;
    private int _lastWeightIndex = -1;
    private int _lastWeight = -1;
    private ScheduledFuture<?> _pmiTimer;
    private ScheduledFuture<?> _weightTimer;
    private ScheduledExecutorService scheduledExecutorService;
    private Object _sessionSynchronizer = new Object();
    private Object _appSessionSynchronizer = new Object();
    private Object _rejectedMessagesSynchronizer = new Object();
    private Object _sipTimersInvocationsSynchronizer = new Object();
    private Object _pmiTimerCreationSynchronizer = new Object();
    private boolean _pmiTimerCreated = false;
    private boolean _perfMgrInitialized = false;
    private static boolean _isApplicationDurationPMIEnabled = true;
    CachedTimerService _timerService = null;
    int _timerServiceGranularity = 10;

    public static PerformanceMgr getInstance() {
        return s_singleton;
    }

    protected void activate(Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"PerformanceMgr activated", (Object[])new Object[]{properties});
        }
        s_singleton = this;
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        int newRange;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"PerformanceMgr modified", (Object[])new Object[]{properties});
        }
        SipPropertiesMap prop = PropertiesStore.getInstance().getProperties();
        prop.updateProperties(properties);
        if (this.isPMIEnabled() && (newRange = this.readProperty(prop, "pmiUpdateRange", this._statUpdateRange, false)) != this._statUpdateRange) {
            this._statUpdateRange = newRange;
            this.cancelTimer(this._pmiTimer, TimerPMIListener.class.getName());
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "modified", "Re-creating TimerPMIListener, statUpdateRange=" + this._statUpdateRange);
            }
            this._pmiTimer = this.scheduledExecutorService.scheduleAtFixedRate(new TimerPMIListener(), 0L, this._statUpdateRange, TimeUnit.MILLISECONDS);
        }
    }

    public void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("PerformanceMgr deactivated, reason=" + reason), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(SipPropertiesMap prop) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "PerformanceMgr -> init");
        }
        this._applicationsContainer = LoadedApplicationsContainer.getInstance();
        this._maxSipAppSessionsAllowed = this.readProperty(prop, "maxAppSessions", this._maxSipAppSessionsAllowed, true);
        this._maxMessageRate = this.readProperty(prop, "maxMessageRate", this._maxMessageRate, true);
        this._maxResponseTime = this.readDurationProperty(prop, "maxResponseTime", this._maxResponseTime, true);
        this._maxMsgQueueSize = this.readProperty(prop, "dispatcherMessageQueueSize", this._maxMsgQueueSize, true);
        this._statUpdateRange = this.readProperty(prop, "pmiUpdateRange", this._statUpdateRange, false);
        this._statAveragePeriod = this.readProperty(prop, "pmiUpdatePeriod", this._statAveragePeriod, false);
        this._loadUpdatePeriod = this.readProperty(prop, "loadUpdateWeightPeriod", this._loadUpdatePeriod, false);
        this._timerServiceGranularity = this.readProperty(prop, "pmiTimerServiceGranularity", this._timerServiceGranularity, false);
        if (this._statAveragePeriod > this._statUpdateRange) {
            this._statUpdateRange = this._statAveragePeriod;
        }
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer b = new StringBuffer(180);
            b.append("_maxSipAppSessionsAllowed = ");
            b.append(this._maxSipAppSessionsAllowed);
            b.append("_maxTrafficAllowed = ");
            b.append(this._maxMessageRate);
            b.append("_maxResponseTime = ");
            b.append(this._maxResponseTime);
            b.append("_statAveragePeriod = ");
            b.append(this._statAveragePeriod);
            b.append("_pmiUpdateTempo = ");
            b.append(this._statUpdateRange);
            b.append("_loadUpdateTempo = ");
            b.append(this._loadUpdatePeriod);
            b.append("_maxMsgQueueSize = ");
            b.append(this._maxMsgQueueSize);
            c_logger.traceDebug(this, "PerformanceMgr -> init", b.toString());
        }
        this._isOverloadProtectionEnabled = prop.getBoolean("enableLoadMonitoring");
        if (!this._isOverloadProtectionEnabled) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "init", "Overload protection is disabled...");
            }
        } else {
            c_logger.traceDebug(this, "init", "Overload protection is enabled...");
            this.createLoadConters();
            this.createWeightTimer();
        }
        Object object = this._pmiTimerCreationSynchronizer;
        synchronized (object) {
            if (!this._pmiTimerCreated && this.isPMIEnabled()) {
                this.createPMITimer();
                this._pmiTimerCreated = true;
            }
            this._perfMgrInitialized = true;
        }
    }

    @Reference
    protected void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    private void createWeightTimer() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createWeightTimer", "Creating TimeWeightListener, loadUpdatePeriod=" + this._loadUpdatePeriod);
        }
        this._weightTimer = this.scheduledExecutorService.scheduleAtFixedRate(new TimeWeightListener(), 0L, this._loadUpdatePeriod, TimeUnit.MILLISECONDS);
    }

    public void createPMITimer() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createPMITimer", "Creating TimerPMIListener, statUpdateRange=" + this._statUpdateRange);
        }
        this._pmiTimer = this.scheduledExecutorService.scheduleAtFixedRate(new TimerPMIListener(), 0L, this._statUpdateRange, TimeUnit.MILLISECONDS);
        if (this._timerService == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createPMITimer", "Creating CachedTimerService, timerServiceGranularity=" + this._timerServiceGranularity);
            }
            this._timerService = new CachedTimerService(this._timerServiceGranularity);
        }
    }

    private void createLoadConters() {
        this._loadCounters = new Weighable[4];
        this._loadCounters[0] = new ApplicationSessionCounter(this._maxSipAppSessionsAllowed, LoadManager.getInstance().getLowWaterMarkSize(), 2, this);
        this._loadCounters[1] = new MPAPCounter(this._maxMessageRate, LoadManager.getInstance().getLowWaterMarkSize(), 2, this._statAveragePeriod);
        this._loadCounters[2] = this._maxResponseTime == 0 ? new DisabledCounter(2) : new ResponseTimeCounter(this._maxResponseTime, LoadManager.getInstance().getLowWaterMarkSize(), 2, 1000);
        this._loadCounters[3] = new ApplicationQueueCounter(this._maxMsgQueueSize, LoadManager.getInstance().getLowWaterMarkSize(), 2, this);
    }

    private int readProperty(SipPropertiesMap prop, String propertyName, int defaultValue, boolean canBeDisabled) {
        int int_value = prop.getInt(propertyName);
        if (int_value <= 0) {
            if (canBeDisabled) {
                int_value = 0;
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("propertyName = ");
                    buff.append(" Set default Value ");
                    c_logger.traceDebug(this, "readProperty", buff.toString());
                }
                int_value = defaultValue;
            }
        }
        return int_value;
    }

    private int readDurationProperty(SipPropertiesMap prop, String propertyName, int defaultValue, boolean canBeDisabled) {
        int int_value = prop.getDuration(propertyName);
        if (int_value <= 0) {
            if (canBeDisabled) {
                int_value = 0;
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("propertyName = ");
                    buff.append(" Set default Value ");
                    c_logger.traceDebug(this, "readProperty", buff.toString());
                }
                int_value = defaultValue;
            }
        }
        return int_value;
    }

    public void appLoaded(String applicationName, SipAppDesc desc) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "appLoaded", applicationName, desc);
        }
        if (this.isToCreateAppModule()) {
            this._applicationsContainer.appLoaded(applicationName, desc);
        }
    }

    public void appUnloaded(String applicationName, Integer appIndex) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "appUnloaded , name = " + applicationName);
        }
        if (this.isToCreateAppModule()) {
            this._applicationsContainer.appUnloaded(applicationName, appIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sipAppSessionCreated(String applicationName, Integer appIndex) {
        Object object = this._appSessionSynchronizer;
        synchronized (object) {
            if (this.isPMIEnabled()) {
                this._applicationsContainer.sipAppSessionCreated(applicationName, appIndex);
                ++this._newSipAppCounter;
                this._commonCounter.getSessionsCounter().sipAppSessionIncrement();
            }
            if (this._isOverloadProtectionEnabled) {
                this._loadCounters[0].increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sipAppSessionDestroyed(String applicationName, Integer appIndex) {
        Object object = this._appSessionSynchronizer;
        synchronized (object) {
            if (this.isPMIEnabled()) {
                this._applicationsContainer.sipAppSessionDestroyed(applicationName, appIndex);
                this._commonCounter.getSessionsCounter().sipAppSessionDecrement();
            }
            if (this._isOverloadProtectionEnabled) {
                this._loadCounters[0].decrement();
            }
        }
    }

    public void setServerWeight(int weight) {
    }

    public int getCurrentServerWeight() {
        return LoadManager.getInstance().getCurrentWeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sipSessionCreated(String applicationName, Integer appIndex) {
        if (!this.isPMIEnabled()) {
            return;
        }
        Object object = this._sessionSynchronizer;
        synchronized (object) {
            this._applicationsContainer.sipSessionCreated(applicationName, appIndex);
            this._commonCounter.getSessionsCounter().sipSessionIncrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sipSessionDestroyed(String applicationName, Integer appIndex) {
        if (!this.isPMIEnabled()) {
            return;
        }
        Object object = this._sessionSynchronizer;
        synchronized (object) {
            this._applicationsContainer.sipSessionDestroyed(applicationName, appIndex);
            this._commonCounter.getSessionsCounter().sipSessionDecrement();
        }
    }

    public void requestReceived() {
        if (this._isOverloadProtectionEnabled) {
            this._loadCounters[1].increment();
        }
        if (this.isPMIEnabled()) {
            this.incrementSIPMsgCounter();
        }
    }

    public void responseReceived() {
        if (this._isOverloadProtectionEnabled) {
            this._loadCounters[1].increment();
        }
        if (this.isPMIEnabled()) {
            this.incrementSIPMsgCounter();
        }
    }

    public void inRequest(String applicationName, Integer appIndex, String method) {
        if (this.isPMIEnabled()) {
            this._applicationsContainer.inRequest(applicationName, appIndex, method);
        }
    }

    public void outRequest(String applicationName, Integer appIndex, String method) {
        if (this.isPMIEnabled()) {
            this._applicationsContainer.outRequest(applicationName, appIndex, method);
        }
    }

    public void inResponse(String applicationName, Integer appIndex, int status) {
        if (this.isPMIEnabled()) {
            this._applicationsContainer.inResponse(applicationName, appIndex, status);
        }
    }

    public void outResponse(String applicationName, Integer appIndex, int status) {
        if (this.isPMIEnabled()) {
            this._applicationsContainer.outResponse(applicationName, appIndex, status);
        }
    }

    private void incrementSIPMsgCounter() {
        ++this._receivedMsgCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRejectedMessagesCounter() {
        Object object = this._rejectedMessagesSynchronizer;
        synchronized (object) {
            ++this._rejectedMessagesCounter;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "updateRejectedMessagesCounter, rejected messages counter = " + this._rejectedMessagesCounter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSipTimersInvocationsCounter() {
        Object object = this._sipTimersInvocationsSynchronizer;
        synchronized (object) {
            ++this._sipTimersInvocations;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "updateSipTimersInvocationsCounter, sip timers invocations counter = " + this._sipTimersInvocations);
        }
    }

    public void measureTaskDurationProcessingQueue(long ms) {
        if (this._pmiModule != null) {
            this._pmiModule.updateTaskDurationProcessingQueueStatistics(ms);
        }
    }

    @Override
    public void measureTaskDurationOutboundQueue(long ms) {
        if (this._pmiModule != null) {
            this._pmiModule.updateTaskDurationOutboundQueueStatistics(ms);
        }
    }

    public void measureInApplicationTaskDuration(String applicationName, Integer appIndex, long ms) {
        if (this.isPMIEnabled()) {
            this._applicationsContainer.updateApplicationTaskDurationStatistics(applicationName, appIndex, ms);
        }
    }

    public boolean isApplicationDurationPMIEnabled() {
        if (this.isPMIEnabled()) {
            return _isApplicationDurationPMIEnabled;
        }
        return false;
    }

    public static void setIsApplicationDurationPMIEnabled(boolean isEnabled) {
        _isApplicationDurationPMIEnabled = isEnabled;
    }

    public void responseSent(long arrivedTime) {
        long responseTime = System.currentTimeMillis() - arrivedTime;
        if (this.isPMIEnabled() && arrivedTime != -1L) {
            this._summaryResponseTime += responseTime;
            ++this._responcesCounter;
        }
        if (this._isOverloadProtectionEnabled) {
            this._loadCounters[2].setCounter(responseTime);
        }
    }

    @Override
    public synchronized void setNewWeight(Weighable counter, long currentLoad) {
        int newWeight = counter.getWeight();
        if (newWeight < this._lastWeight) {
            this._lastWeight = newWeight;
            this._lastWeightIndex = counter.getCounterID();
            this.callToSetNewWeight(currentLoad);
        } else if (newWeight > this._lastWeight && this._lastWeightIndex == counter.getCounterID() && this.calculateNewWeight()) {
            this.callToSetNewWeight(currentLoad);
        }
    }

    public synchronized void updateServerWeight() {
        for (int i = 0; i < this._loadCounters.length; ++i) {
            this._loadCounters[i].calculateWeight();
        }
        if (this.calculateNewWeight()) {
            this.callToSetNewWeight(this._loadCounters[this._lastWeightIndex].getLoadUsedForLastWeightCalc());
        }
    }

    private void callToSetNewWeight(long currentLoad) {
        boolean changed = LoadManager.getInstance().updateNewWeight(this._loadCounters[this._lastWeightIndex], this._lastWeight, currentLoad);
        if (changed && c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < this._loadCounters.length; ++i) {
                Weighable counter = this._loadCounters[i];
                buff.append("\n\r CounterInfo = ");
                buff.append(counter.getCurrentState());
            }
            c_logger.traceDebug(this, "callToSetNewWeight", buff.toString());
        }
    }

    private synchronized boolean calculateNewWeight() {
        int index = 0;
        int weight = this._loadCounters[index].getWeight();
        boolean weightChanged = false;
        for (int i = 1; i < this._loadCounters.length; ++i) {
            if (weight <= this._loadCounters[i].getWeight()) continue;
            weight = this._loadCounters[i].getWeight();
            index = i;
        }
        if (index != this._lastWeightIndex) {
            this._lastWeightIndex = index;
        }
        if (weight != this._lastWeight) {
            this._lastWeight = weight;
            weightChanged = true;
        }
        if (weightChanged && c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("New weight is = ");
            buff.append(this._lastWeight);
            buff.append(" changed by counter ");
            buff.append(PerfUtil.getOverloadedMsgByType(index));
            c_logger.traceDebug(this, "calculateNewWeight", buff.toString());
        }
        return weightChanged;
    }

    private void updateStatistic() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "updateStatistic");
        }
        if (this.isPMIEnabled()) {
            this._pmiModule.updateAppSessionNum(this._commonCounter.getSipAppSessions());
            this._pmiModule.updateSipSessionNum(this._commonCounter.getSipSessions());
            this._pmiModule.updateInvokeCounter(this._commonCounter.getInvokeQueueSize());
            this._pmiModule.updateRejectedMessagesCounter(this._rejectedMessagesCounter);
            this._pmiModule.updateSipTimersInvocationsCounter(this._sipTimersInvocations);
            this._applicationsContainer.updatePmi();
            long requestProcessing_avg = 0L;
            if (this._responcesCounter > 0L) {
                requestProcessing_avg = this._summaryResponseTime / this._responcesCounter;
            }
            this._pmiModule.updatedProcessingRequest(requestProcessing_avg);
            long receivedMsg_avg = this.calculateAvarageOfTheCounter(this._receivedMsgCounter);
            this._pmiModule.updateReceivedMsgs(receivedMsg_avg);
            long newSipApp_avg = this.calculateAvarageOfTheCounter(this._newSipAppCounter);
            this._pmiModule.updateNewSipAppCreated(newSipApp_avg);
            this._pmiModule.updateTaskDurationPMICounters();
            this._pmiModule.updateQueueMonitoringPMICounters();
        }
        this.nullifyInternalCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nullifyInternalCounters() {
        this._summaryResponseTime = 0L;
        this._responcesCounter = 0L;
        this._receivedMsgCounter = 0L;
        this._newSipAppCounter = 0L;
        Object object = this._rejectedMessagesSynchronizer;
        synchronized (object) {
            this._rejectedMessagesCounter = 0L;
        }
        object = this._sipTimersInvocationsSynchronizer;
        synchronized (object) {
            this._sipTimersInvocations = 0L;
        }
    }

    private long calculateAvarageOfTheCounter(long counter) {
        long average = counter * (long)this._statAveragePeriod / (long)this._statUpdateRange;
        return average;
    }

    public void incrementInvokeCounter() {
        if (this.isPMIEnabled()) {
            this._commonCounter.invokeQueueIncrement();
        }
    }

    public void decrementInvokeCounter() {
        if (this.isPMIEnabled()) {
            this._commonCounter.invokeQueueDecrement();
        }
    }

    public void setQueueSize(long size) {
        if (this._isOverloadProtectionEnabled) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setQueueSize", "new Size is = " + size);
            }
            this._loadCounters[3].setCounter(size);
        }
    }

    public boolean isOverload() {
        if (!this._isOverloadProtectionEnabled) {
            return false;
        }
        return LoadManager.getInstance().getLastWeight() == 0;
    }

    public void stopTimers() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "stopTimers", "Stop timers");
        }
        this.cancelTimer(this._pmiTimer, TimerPMIListener.class.getName());
        this.cancelTimer(this._weightTimer, TimeWeightListener.class.getName());
        if (this.isPMIEnabled() && this._timerService != null) {
            this._timerService.destroy();
            this._timerService = null;
        }
    }

    private void cancelTimer(ScheduledFuture<?> timerToCancel, String timerClass) {
        if (timerToCancel != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "cancelTimer", "Canceling " + timerClass);
            }
            timerToCancel.cancel(true);
            timerToCancel = null;
        }
    }

    public int getAveragingPeriod() {
        return this._statAveragePeriod;
    }

    private boolean isToCreateAppModule() {
        boolean isAppModulesShouldBeCreated = false;
        if (this.isPMIEnabled()) {
            isAppModulesShouldBeCreated = true;
        }
        return isAppModulesShouldBeCreated;
    }

    @Override
    public long getCurrentCachedTime() {
        return this._timerService.getCurrentTime();
    }

    @Override
    public boolean isPMIEnabled() {
        return this._pmiModule != null;
    }

    public boolean isTaskDurationProcessingQueuePMIEnabled() {
        if (this._pmiModule != null) {
            return this._pmiModule.isProcessingQueuePMIEnabled();
        }
        return false;
    }

    @Override
    public boolean isTaskDurationOutboundQueuePMIEnabled() {
        if (this._pmiModule != null) {
            return this._pmiModule.isTaskDurationOutboundQueuePMIEnabled();
        }
        return false;
    }

    @Override
    public boolean isQueueMonitoringOutboundQueuePMIEnabled() {
        if (this._pmiModule != null) {
            return this._pmiModule.isQueueMonitoringOutboundQueuePMIEnabled();
        }
        return false;
    }

    public boolean isQueueMonitoringProcessingQueuePMIEnabled() {
        if (this._pmiModule != null) {
            return this._pmiModule.isQueueMonitoringProcessingQueuePMIEnabled();
        }
        return false;
    }

    @Override
    public void updateQueueMonitoringTaskQueuedInOutboundQueue() {
        if (this._pmiModule != null) {
            this._pmiModule.updateQueueMonitoringTaskQueuedInOutboundQueue();
        }
    }

    @Override
    public void updateQueueMonitoringTaskDequeuedFromOutboundQueue() {
        if (this._pmiModule != null) {
            this._pmiModule.updateQueueMonitoringTaskDequeuedFromOutboundQueue();
        }
    }

    public void updateQueueMonitoringTaskQueuedInProcessingQueue() {
        if (this._pmiModule != null) {
            this._pmiModule.updateQueueMonitoringTaskQueuedInProcessingQueue();
        }
    }

    public void updateQueueMonitoringTaskDequeuedFromProcessingQueue() {
        if (this._pmiModule != null) {
            this._pmiModule.updateQueueMonitoringTaskDequeuedFromProcessingQueue();
        }
    }

    public void incrementReplicatedSipSessionsCounter() {
        if (this.isPMIEnabled()) {
            this._commonCounter.incrementReplicatedSipSessionsCounter();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "incrementReplicatedSipSessionsCounter, replicated Sip Sessions num = " + this._commonCounter.getReplicatedSipSessionsCounter());
            }
        }
    }

    public void decrementReplicatedSipSessionsCounter() {
        if (this.isPMIEnabled()) {
            this._commonCounter.decrementReplicatedSipSessionsCounter();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "decrementReplicatedSipSessionsCounter, replicated Sip Sessions num = " + this._commonCounter.getReplicatedSipSessionsCounter());
            }
        }
    }

    public void incrementNotReplicatedSipSessionsCounter() {
        if (this.isPMIEnabled()) {
            this._commonCounter.incrementNotReplicatedSipSessionsCounter();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "incrementNotReplicatedSipSessionsCounter, not replicated Sip Sessions num = " + this._commonCounter.getNotReplicatedSipSessionsCounter());
            }
        }
    }

    public void incrementReplicatedSipAppSessionsCounter() {
        if (this.isPMIEnabled()) {
            this._commonCounter.incrementReplicatedSipAppSessionsCounter();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "incrementReplicatedSipAppSessionsCounter, replicated Sip App Sessions num = " + this._commonCounter.getReplicatedSipAppSessionsCounter());
            }
        }
    }

    public void decrementReplicatedSipAppSessionsCounter() {
        if (this.isPMIEnabled()) {
            this._commonCounter.decrementReplicatedSipAppSessionsCounter();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "decrementReplicatedSipAppSessionsCounter, replicated Sip App Sessions num = " + this._commonCounter.getReplicatedSipAppSessionsCounter());
            }
        }
    }

    public void incrementNotReplicatedSipAppSessionsCounter() {
        if (this.isPMIEnabled()) {
            this._commonCounter.incrementNotReplicatedSipAppSessionsCounter();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "incrementNotReplicatedSipAppSessionsCounter, not replicated Sip App Sessions num = " + this._commonCounter.getNotReplicatedSipAppSessionsCounter());
            }
        }
    }

    public void decrementNotReplicatedSipAppSessionsCounter() {
        if (this.isPMIEnabled()) {
            this._commonCounter.decrementNotReplicatedSipAppSessionsCounter();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "decrementNotReplicatedSipAppSessionsCounter, not replicated Sip App Sessions num = " + this._commonCounter.getNotReplicatedSipAppSessionsCounter());
            }
        }
    }

    public void decrementNotReplicatedSipSessionsCounter() {
        if (this.isPMIEnabled()) {
            this._commonCounter.decrementNotReplicatedSipSessionsCounter();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "decrementNotReplicatedSipSessionsCounter, not replicated Sip Sessions num = " + this._commonCounter.getNotReplicatedSipSessionsCounter());
            }
        }
    }

    public void updatePmiInRequest(String method, TransactionUserWrapper tuWrapper, SipServletDesc sipDesc) {
        SipAppDesc appDesc;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{tuWrapper.getAppName(), tuWrapper.getId(), method};
            c_logger.traceEntry((Object)tuWrapper.getTuImpl(), "updatePmiInRequest", params);
        }
        if (null != (appDesc = sipDesc != null ? sipDesc.getSipApp() : tuWrapper.getSipServletDesc().getSipApp())) {
            this.inRequest(appDesc.getApplicationName(), appDesc.getAppIndexForPmi(), method);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(tuWrapper.getTuImpl(), "updatePmiInRequest", "Unable to update PerfManager SIP app descriptor not available");
        }
    }

    public void updatePmiOutRequest(String method, TransactionUserWrapper tuWrapper) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{tuWrapper.getAppName(), tuWrapper.getId()};
            c_logger.traceEntry((Object)tuWrapper.getTuImpl(), "updatePmiOutRequest", params);
        }
        SipServletDesc servletDesc = tuWrapper.getSipServletDesc();
        SipAppDesc appDesc = null;
        if (servletDesc != null) {
            appDesc = tuWrapper.getSipServletDesc().getSipApp();
        }
        if (null != appDesc) {
            this.outRequest(appDesc.getApplicationName(), appDesc.getAppIndexForPmi(), method);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(tuWrapper.getTuImpl(), "updatePmiOutRequest", "Unable to update PerfManager SIP app descriptor not available");
        }
    }

    public void updatePmiInResponse(int status, TransactionUserWrapper tuWrapper) {
        SipAppDesc appDesc;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{tuWrapper.getAppName(), tuWrapper.getId(), status};
            c_logger.traceEntry((Object)tuWrapper.getTuImpl(), "updatePmiInResponse", params);
        }
        if (null != (appDesc = tuWrapper.getSipServletDesc().getSipApp())) {
            this.inResponse(appDesc.getApplicationName(), appDesc.getAppIndexForPmi(), status);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(tuWrapper.getTuImpl(), "updatePmiInResponse", "Unable to update PerfManager SIP app descriptor not available");
        }
    }

    public void updatePmiOutResponse(int status, TransactionUserWrapper tuWrapper) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{tuWrapper.getAppName(), tuWrapper.getId()};
            c_logger.traceEntry((Object)tuWrapper.getTuImpl(), "updatePmiOutResponse", params);
        }
        SipAppDesc appDesc = null;
        if (tuWrapper != null && tuWrapper.getSipServletDesc() != null) {
            appDesc = tuWrapper.getSipServletDesc().getSipApp();
        }
        if (null != appDesc) {
            this.outResponse(appDesc.getApplicationName(), appDesc.getAppIndexForPmi(), status);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(tuWrapper.getTuImpl(), "updatePmiOutResponse", "Unable to update PerfManager SIP app descriptor not available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setSipContainerPMIListener(SipContainerPMIListener pmiModule) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "SipContainerPMIListener set listener", (Object)this._pmiModule);
        }
        if (pmiModule.isTraditionalPMIEnabled()) {
            c_logger.warn("warning.traditional.enabled", null);
        } else {
            Object object = this._pmiTimerCreationSynchronizer;
            synchronized (object) {
                this._pmiModule = pmiModule;
                if (this._perfMgrInitialized && !this._pmiTimerCreated) {
                    this.createPMITimer();
                }
            }
        }
    }

    protected synchronized void unsetSipContainerPMIListener(SipContainerPMIListener pmiModule) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipContainerPMIListener unset listener");
        }
        this._pmiModule = null;
        this.cancelTimer(this._pmiTimer, TimerPMIListener.class.getName());
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setApplicationsPMIListener(ApplicationsPMIListener appsModule) {
        this._appsPMIModule = appsModule;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("ApplicationsPMIListener set listener", this._appsPMIModule);
        }
    }

    protected synchronized void unsetApplicationsPMIListener(ApplicationsPMIListener appModule) {
        this._appsPMIModule = null;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("ApplicationsPMIListener unset listener");
        }
    }

    public ApplicationsPMIListener getApplicationsPMIListener() {
        return this._appsPMIModule;
    }

    class TimeWeightListener
    implements Runnable {
        TimeWeightListener() {
        }

        @Override
        public void run() {
            PerformanceMgr.this.updateServerWeight();
        }
    }

    class TimerPMIListener
    extends TimerTask {
        TimerPMIListener() {
        }

        @Override
        public void run() {
            PerformanceMgr.this.updateStatistic();
        }
    }
}

