/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.failover.repository;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.failover.repository.TimerRepository;
import com.ibm.ws.sip.container.timer.BaseTimer;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.sip.SipApplicationSession;

public class StandAloneTimersRepoMgr
implements TimerRepository {
    private static final LogMgr c_logger = Log.get(StandAloneTimersRepoMgr.class);
    private Hashtable<String, HashMap> m_sessionsTbl = null;

    @Override
    public BaseTimer get(String appSessionId, Integer timerId) {
        HashMap attributes;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "get", appSessionId, timerId);
        }
        BaseTimer baseTimer = null;
        Hashtable<String, HashMap> sessionsTbl = this.getSessionsTbl(false);
        if (sessionsTbl != null && (attributes = sessionsTbl.get(appSessionId)) != null) {
            baseTimer = (BaseTimer)attributes.get(timerId);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "get", baseTimer);
        }
        return baseTimer;
    }

    @Override
    public BaseTimer put(SipApplicationSession sipAppSession, BaseTimer timer) {
        Hashtable<String, HashMap> sessionsTbl;
        HashMap<Integer, BaseTimer> timers;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "put", sipAppSession, timer);
        }
        if ((timers = (sessionsTbl = this.getSessionsTbl(true)).get(sipAppSession.getId())) == null) {
            timers = new HashMap<Integer, BaseTimer>();
            sessionsTbl.put(sipAppSession.getId(), timers);
        }
        return timers.put(timer.getTimerId(), timer);
    }

    @Override
    public BaseTimer remove(String appSessionId, Integer timerId) {
        HashMap attributes;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "remove", appSessionId, timerId);
        }
        BaseTimer removed = null;
        Hashtable<String, HashMap> sessionsTbl = this.getSessionsTbl(false);
        if (sessionsTbl != null && (attributes = sessionsTbl.get(appSessionId)) != null) {
            removed = (BaseTimer)attributes.remove(timerId);
            if (attributes.isEmpty()) {
                sessionsTbl.remove(appSessionId);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "remove", removed);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable<String, HashMap> getSessionsTbl(boolean create) {
        Hashtable<String, HashMap> sessionsTbl = this.m_sessionsTbl;
        if (sessionsTbl == null && create) {
            StandAloneTimersRepoMgr standAloneTimersRepoMgr = this;
            synchronized (standAloneTimersRepoMgr) {
                if (this.m_sessionsTbl == null) {
                    this.m_sessionsTbl = new Hashtable();
                }
            }
            sessionsTbl = this.m_sessionsTbl;
        }
        return sessionsTbl;
    }

    @Override
    public Object beginTx() {
        return null;
    }

    @Override
    public Object commitTx(Object txKey) {
        return null;
    }

    @Override
    public Object rollback(Object txKey) {
        return null;
    }
}

