/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.annotation;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.servlets.SipSessionsUtilImpl;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.factory.ResourceInfo;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={ObjectFactory.class, SipSessionsUtilObjectFactory.class})
public class SipSessionsUtilObjectFactory
implements ObjectFactory {
    private static final LogMgr c_logger = Log.get(SipSessionsUtilObjectFactory.class);

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (!(obj instanceof Reference)) {
            throw new InjectionException("Binding object is not a Reference : " + obj);
        }
        Reference ref = (Reference)obj;
        if (!ref.getFactoryClassName().equals(this.getClass().getName())) {
            throw new InjectionException("Incorrect factory for Reference : " + obj);
        }
        RefAddr addr = ref.get("ResourceInfo");
        if (addr == null) {
            throw new RuntimeException("The address for this Reference is empty (null)");
        }
        ResourceInfo info = (ResourceInfo)addr.getContent();
        String appName = info.getComponent();
        if (appName != null) {
            return new SipSessionsUtilImpl(appName);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Could not locate application name, returning default sip session util.");
        }
        return new SipSessionsUtilImpl(null);
    }
}

