/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.annotation;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.servlets.SipServletsFactoryImpl;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.factory.ResourceInfo;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={ObjectFactory.class, SipFactoryObjectFactory.class})
public class SipFactoryObjectFactory
implements ObjectFactory {
    private static final LogMgr c_logger = Log.get(SipFactoryObjectFactory.class);
    private static final String SIP_PREFIX = "sip";
    private static final String SIP_FACTORY_POSTFIX = "SipFactory";

    public void activate(Map<String, Object> properties) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipFactoryObjectFactory activated", properties);
        }
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (!(obj instanceof Reference)) {
            throw new InjectionException("Binding object is not a Reference : " + obj);
        }
        Reference ref = (Reference)obj;
        if (!ref.getFactoryClassName().equals(this.getClass().getName())) {
            throw new InjectionException("Incorrect factory for Reference : " + obj);
        }
        RefAddr addr = ref.get("ResourceInfo");
        if (addr == null) {
            throw new RuntimeException("The address for this Reference is empty (null)");
        }
        ResourceInfo info = (ResourceInfo)addr.getContent();
        String appName = this.retrieveAppName(info);
        if (appName != null) {
            return SipServletsFactoryImpl.getInstance(appName);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Could not locate application name, returning default factory");
        }
        return SipServletsFactoryImpl.getInstance();
    }

    private String retrieveAppName(ResourceInfo info) {
        String appName = "";
        String jndiName = info.getName();
        if (jndiName != null) {
            String[] result;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("retrieveAppName", "jndiName=" + jndiName);
            }
            if (jndiName.startsWith(SIP_PREFIX) && jndiName.endsWith(SIP_FACTORY_POSTFIX) && (result = jndiName.split("/")).length == 3) {
                appName = result[1];
            }
        }
        if (appName == null || appName.equals("")) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("retrieveAppName", "Retrieving app name from component");
            }
            appName = info.getComponent();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("retrieveAppName", "appName=" + appName);
        }
        return appName;
    }
}

