/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.message;

import com.ibm.ws.jain.protocol.ip.sip.message.SipVersion;
import com.ibm.ws.jain.protocol.ip.sip.message.SipVersion20Impl;
import com.ibm.ws.jain.protocol.ip.sip.message.SipVersionImpl;
import jain.protocol.ip.sip.SipParseException;

public final class SipVersionFactory {
    private static final SipVersion20Impl SIP_VERSION_2_0Impl = new SipVersion20Impl();

    public static SipVersion createVersion() {
        return SIP_VERSION_2_0Impl;
    }

    public static SipVersion createSipVersion(char[] buffer, int offset, int length) throws SipParseException {
        if (buffer == null || length < 4) {
            throw new SipParseException("unsupported SIP version");
        }
        if (buffer[offset + 3] == '/' && buffer[offset + 4] == '2' && buffer[offset + 5] == '.' && buffer[offset + 6] == '0') {
            return SIP_VERSION_2_0Impl;
        }
        String otherVersions = new String(buffer, offset, length);
        return new SipVersionImpl(otherVersions);
    }

    public static SipVersion createSipVersion(int major, int minor) {
        if (major == 2 && minor == 0) {
            return SIP_VERSION_2_0Impl;
        }
        return new SipVersionImpl(major, minor);
    }
}

