/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.PriorityHeader;

public class PriorityHeaderImpl
extends HeaderImpl
implements PriorityHeader {
    private static final long serialVersionUID = -5171776118010606561L;
    private String m_priority;

    @Override
    public String getPriority() {
        return this.m_priority;
    }

    @Override
    public void setPriority(String prio) throws IllegalArgumentException, SipParseException {
        if (prio == null) {
            throw new IllegalArgumentException("Null priority");
        }
        if (!(prio.equals("normal") || prio.equals("urgent") || prio.equals("non-urgent") || prio.equals("emergency"))) {
            throw new SipParseException("Unknown priority" + prio);
        }
        this.m_priority = prio;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        this.m_priority = parser.toString();
    }

    @Override
    protected void encodeValue(CharsBuffer buf) {
        buf.append(this.m_priority);
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!(other instanceof PriorityHeaderImpl)) {
            return false;
        }
        PriorityHeaderImpl o = (PriorityHeaderImpl)other;
        if (this.m_priority == null || this.m_priority.length() == 0) {
            return o.m_priority == null || o.m_priority.length() == 0;
        }
        if (o.m_priority == null || o.m_priority.length() == 0) {
            return false;
        }
        return this.m_priority.equals(o.m_priority);
    }

    @Override
    public String getName() {
        return "Priority";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return true;
    }
}

