/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.address.NameAddressImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersHeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.header.NameAddressHeader;

public abstract class NameAddressHeaderImpl
extends ParametersHeaderImpl
implements NameAddressHeader {
    private static final long serialVersionUID = 7650958641914669533L;
    private NameAddressImpl m_nameAddress;

    @Override
    public void setNameAddress(NameAddress nameAddress) throws IllegalArgumentException {
        if (nameAddress == null) {
            throw new IllegalArgumentException("NameAddressHeader: null arg");
        }
        if (!(nameAddress instanceof NameAddressImpl)) {
            throw new IllegalArgumentException("NameAddressHeader: expected same JAIN SIP implementation");
        }
        this.m_nameAddress = (NameAddressImpl)nameAddress;
    }

    @Override
    public NameAddress getNameAddress() {
        return this.m_nameAddress;
    }

    private boolean isAddrSpecFormatAllowed() {
        String n = this.getName();
        return n != null && !NameAddressHeaderImpl.headerNamesEqual(n, "Route") && !NameAddressHeaderImpl.headerNamesEqual(n, "Record-Route") && !NameAddressHeaderImpl.headerNamesEqual(n, "Path") && !NameAddressHeaderImpl.headerNamesEqual(n, "Call-Info") && !NameAddressHeaderImpl.headerNamesEqual(n, "Alert-Info") && !NameAddressHeaderImpl.headerNamesEqual(n, "Error-Info");
    }

    @Override
    protected void encodeValue(CharsBuffer buffer) {
        boolean addrSpecFormatAllowed = this.isAddrSpecFormatAllowed();
        this.m_nameAddress.writeToCharBuffer(buffer, addrSpecFormatAllowed);
        super.encodeValue(buffer);
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        NameAddress address = parser.parseNameAddress();
        this.setNameAddress(address);
        super.parseValue(parser);
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!super.valueEquals(other)) {
            return false;
        }
        if (!(other instanceof NameAddressHeaderImpl)) {
            return false;
        }
        NameAddressHeaderImpl o = (NameAddressHeaderImpl)other;
        if (this.m_nameAddress == null) {
            return o.m_nameAddress == null;
        }
        if (o.m_nameAddress == null) {
            return false;
        }
        return this.m_nameAddress.equals(o.m_nameAddress);
    }

    @Override
    public Object clone() {
        NameAddressHeaderImpl ret = (NameAddressHeaderImpl)super.clone();
        if (this.m_nameAddress != null) {
            ret.m_nameAddress = (NameAddressImpl)this.m_nameAddress.clone();
        }
        return ret;
    }

    public void assign(NameAddressHeader source) {
        NameAddressHeaderImpl o = (NameAddressHeaderImpl)source;
        this.m_nameAddress = o.m_nameAddress;
        super.assign(o);
    }
}

