/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderSeparator;
import com.ibm.ws.sip.parser.CharArray;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;

public class ExtendedHeader
extends HeaderImpl {
    private final String m_name;
    private String m_value;

    public ExtendedHeader(String name) throws IllegalArgumentException {
        this(name, null);
    }

    public ExtendedHeader(String name, CharArray value) throws IllegalArgumentException {
        super(value);
        if (name == null) {
            throw new IllegalArgumentException("ExtendedHeader: null name");
        }
        this.m_name = name;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        this.m_value = parser.toString();
    }

    @Override
    protected void encodeValue(CharsBuffer buf) {
        buf.append(this.m_value);
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!(other instanceof ExtendedHeader)) {
            return false;
        }
        ExtendedHeader o = (ExtendedHeader)other;
        if (this.m_value == null || this.m_value.length() == 0) {
            return o.m_value == null || o.m_value.length() == 0;
        }
        if (o.m_value == null || o.m_value.length() == 0) {
            return false;
        }
        return this.m_value.equals(o.m_value);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public boolean isNested() {
        return true;
    }

    @Override
    public String getName(boolean isUseCompactHeaders) {
        if (isUseCompactHeaders && this.getName().equals("Refer-To")) {
            return String.valueOf('r');
        }
        return this.getName();
    }

    public boolean isInCommaSeparated() {
        HeaderSeparator hs = HeaderSeparator.instance();
        boolean nested = hs.isCommaSeparated(this.m_name, true);
        return nested;
    }
}

