/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.sip.parser.CharArray;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.CSeqHeader;

public class CSeqHeaderImpl
extends HeaderImpl
implements CSeqHeader {
    private static final long serialVersionUID = 1501450667995306211L;
    private String m_method;
    private long m_seqNumber;

    public CSeqHeaderImpl() {
    }

    public CSeqHeaderImpl(CharArray value) {
        super(value);
    }

    @Override
    public void setSequenceNumber(long sequenceNumber) throws SipParseException {
        this.m_seqNumber = sequenceNumber;
    }

    @Override
    public void setMethod(String meth) throws IllegalArgumentException, SipParseException {
        if (meth == null) {
            throw new IllegalArgumentException("Cseq: Null method");
        }
        this.m_method = meth;
    }

    @Override
    public long getSequenceNumber() {
        return this.m_seqNumber;
    }

    @Override
    public String getMethod() {
        return this.m_method;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        long sequenceNumber = parser.longNumber();
        if (!Character.isSpaceChar(parser.LA())) {
            throw new SipParseException("Bad CSeq", "");
        }
        String method = parser.nextToken('\u0000');
        this.setSequenceNumber(sequenceNumber);
        this.setMethod(method);
    }

    @Override
    protected void encodeValue(CharsBuffer ret) {
        ret.append(this.m_seqNumber).append(' ').append(this.m_method.toUpperCase());
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!(other instanceof CSeqHeaderImpl)) {
            return false;
        }
        CSeqHeaderImpl o = (CSeqHeaderImpl)other;
        if (this.m_seqNumber != o.m_seqNumber) {
            return false;
        }
        if (this.m_method == null || this.m_method.length() == 0) {
            return o.m_method == null || o.m_method.length() == 0;
        }
        if (o.m_method == null || o.m_method.length() == 0) {
            return false;
        }
        return this.m_method.equals(o.m_method);
    }

    @Override
    public int hashCode() {
        if (!this.isParsed()) {
            return super.hashCode();
        }
        int nameHash = "CSeq".hashCode();
        int valueHash = this.m_method.hashCode() ^ (int)this.m_seqNumber;
        int hash = nameHash ^ valueHash;
        return hash;
    }

    @Override
    public String getName() {
        return "CSeq";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return false;
    }
}

