/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.extensions;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.extensions.InfoHeader;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersHeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.URI;

public abstract class InfoHeaderImpl
extends ParametersHeaderImpl
implements InfoHeader {
    private static final long serialVersionUID = -7949035921981846005L;
    private static final LogMgr s_logger = Log.get(InfoHeaderImpl.class);
    protected URI m_uri;

    @Override
    public URI getURI() {
        return this.m_uri;
    }

    @Override
    public void setURI(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("AlertInfo: null uri");
        }
        this.m_uri = uri;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        this.setURI(parser.parseNameAddress().getAddress());
        super.parseValue(parser);
    }

    @Override
    protected void encodeValue(CharsBuffer ret) {
        if (this.m_uri == null) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug(this, "encodeValue", "null URI", new RuntimeException());
            }
        } else {
            ret.append('<');
            ret.append(this.m_uri.toString());
            ret.append('>');
        }
        super.encodeValue(ret);
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!super.valueEquals(other)) {
            return false;
        }
        if (!(other instanceof InfoHeaderImpl)) {
            return false;
        }
        InfoHeaderImpl o = (InfoHeaderImpl)other;
        if (this.m_uri == null) {
            return o.m_uri == null;
        }
        if (o.m_uri == null) {
            return false;
        }
        return this.m_uri.equals(o.m_uri);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    protected char getListSeparator() {
        return ';';
    }

    @Override
    protected char getParamSeparator() {
        return ';';
    }
}

