/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.address;

import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;

public class SipUserInfo {
    String m_userName;
    String m_password;
    String m_type = "ip";

    public String getType() {
        return this.m_type;
    }

    public String getName() {
        return this.m_userName;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        this.m_userName = name;
        if (name.indexOf(35) >= 0 || name.indexOf(59) >= 0) {
            this.setUserType("phone");
        }
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public void setUserType(String userType) throws IllegalArgumentException {
        if (userType == null) {
            throw new IllegalArgumentException("SipUserInfo: null userType");
        }
        if (!userType.equals("ip") && !userType.equals("phone")) {
            throw new IllegalArgumentException("SipUserInfo: unknown user type");
        }
        this.m_type = userType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SipUserInfo)) {
            return false;
        }
        SipUserInfo other = (SipUserInfo)obj;
        if (!this.m_type.equals(other.m_type)) {
            return false;
        }
        if (!this.m_userName.equalsIgnoreCase(other.m_userName)) {
            return false;
        }
        if (this.m_password != null && other.m_password == null) {
            return false;
        }
        if (other.m_password != null && this.m_password == null) {
            return false;
        }
        return this.m_password.equals(other.m_password);
    }

    public String toString() {
        CharsBuffer buffer = CharsBuffersPool.getBuffer();
        this.writeToCharBuffer(buffer);
        String value = buffer.toString();
        CharsBuffersPool.putBufferBack(buffer);
        return value;
    }

    public void writeToCharBuffer(CharsBuffer ret) {
        ret.append(this.m_userName);
        if (this.m_password != null) {
            ret.append(':');
            ret.append(this.m_password);
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

