/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.service.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.wsat.Constants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EffectivePolicyImpl;
import org.apache.cxf.ws.policy.EndpointPolicyImpl;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyEngineImpl;
import org.apache.cxf.ws.policy.PolicyOutInterceptor;
import org.apache.neethi.Policy;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSATPolicyOverrideInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent TC = Tr.register(WSATPolicyOverrideInterceptor.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private static final String PATH = "/META-INF/wsat-policy.xml";
    private static final boolean ISREMOVE = false;
    private final boolean remove;
    static final long serialVersionUID = 1183077065762915668L;

    public WSATPolicyOverrideInterceptor() {
        super("setup");
        this.getAfter().add(PolicyOutInterceptor.class.getName());
        this.remove = false;
    }

    public WSATPolicyOverrideInterceptor(boolean remove) {
        super("setup");
        this.getAfter().add(PolicyOutInterceptor.class.getName());
        this.remove = remove;
    }

    private Policy generateWSATPolicy(Message msg) throws Throwable {
        InputStream is;
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Start to loadd policy from template", (Object[])new Object[]{PATH});
        }
        if ((is = ((Object)((Object)this)).getClass().getResourceAsStream(PATH)) == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"InputStream is NULL??", (Object[])new Object[0]);
            }
            throw new RuntimeException("InputStream Object is null, not able to generate ws-at policy...");
        }
        Element policyElement = DOMUtils.readXml((InputStream)is).getDocumentElement();
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Try getting policy element", (Object[])new Object[]{policyElement});
        }
        PolicyBuilder builder = (PolicyBuilder)msg.getExchange().getBus().getExtension(PolicyBuilder.class);
        Policy wsatPolicy = builder.getPolicy((Object)policyElement);
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Try extract to policy object : ", (Object[])new Object[]{wsatPolicy});
        }
        return wsatPolicy;
    }

    private void insertPolicy(Message msg, Policy p, AssertionInfoMap map) throws Throwable {
        Exchange exchange = msg.getExchange();
        Bus bus = (Bus)exchange.get(Bus.class);
        BindingOperationInfo boi = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        if (null == boi) {
            throw new RuntimeException("Failed to get binding operation info");
        }
        Endpoint e = (Endpoint)exchange.get(Endpoint.class);
        if (null == e) {
            throw new RuntimeException("Failed to get endpoint");
        }
        PolicyEngine pe = (PolicyEngine)bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            throw new RuntimeException("Failed to get policy engine");
        }
        EndpointPolicyImpl endpi = new EndpointPolicyImpl(p);
        EffectivePolicyImpl effectivePolicy = new EffectivePolicyImpl();
        effectivePolicy.initialise(endpi, (PolicyEngineImpl)pe, false);
        ArrayList assertions = new ArrayList();
        assertions.addAll(effectivePolicy.getChosenAlternative());
        AssertionInfoMap tempMap = new AssertionInfoMap(assertions);
        map.putAll((Map)tempMap);
        msg.getInterceptorChain().add((Collection)effectivePolicy.getInterceptors());
    }

    /*
     * WARNING - void declaration
     */
    public void handleMessage(Message msg) throws Fault {
        try {
            AssertionInfoMap map = (AssertionInfoMap)msg.get(AssertionInfoMap.class);
            if (!this.remove && map.getAssertionInfo(Constants.AT_ASSERTION_QNAME).isEmpty()) {
                Policy p = this.generateWSATPolicy(msg);
                this.insertPolicy(msg, p, map);
            } else if (this.remove && !map.getAssertionInfo(Constants.AT_ASSERTION_QNAME).isEmpty()) {
                map.remove((Object)Constants.AT_ASSERTION_QNAME);
            }
        }
        catch (Throwable map) {
            void e;
            FFDCFilter.processException((Throwable)map, (String)"com.ibm.ws.wsat.service.impl.WSATPolicyOverrideInterceptor", (String)"141", (Object)((Object)this), (Object[])new Object[]{msg});
            throw new Fault((Throwable)e);
        }
    }
}

