/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.openidconnect;

import com.ibm.ws.webcontainer.security.jwk.JSONWebKey;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public interface OidcServerConfig {
    public String getProviderId();

    public String getOauthProviderName();

    public String getOauthProviderPid();

    public String getUserIdentifier();

    public String getUniqueUserIdentifier();

    public String getIssuerIdentifier();

    public String getAudience();

    public String getUserIdentity();

    public String getGroupIdentifier();

    public boolean isCustomClaimsEnabled();

    public boolean allowDefaultSsoCookieName();

    public boolean cacheIDToken();

    public Set<String> getCustomClaims();

    public boolean isJTIClaimEnabled();

    public String getDefaultScope();

    public String getExternalClaimNames();

    public Properties getScopeToClaimMap();

    public Properties getClaimToUserRegistryMap();

    public String getSignatureAlgorithm();

    public PrivateKey getPrivateKey() throws KeyStoreException, CertificateException;

    public boolean isSessionManaged();

    public long getIdTokenLifetime();

    public String getCheckSessionIframeEndpointUrl();

    public String[] getResponseTypesSupported();

    public String[] getSubjectTypesSupported();

    public String getIdTokenSigningAlgValuesSupported();

    public String[] getScopesSupported();

    public String[] getClaimsSupported();

    public String[] getResponseModesSupported();

    public String[] getGrantTypesSupported();

    public String[] getTokenEndpointAuthMethodsSupported();

    public String[] getDisplayValuesSupported();

    public String[] getClaimTypesSupported();

    public boolean isClaimsParameterSupported();

    public boolean isRequestParameterSupported();

    public boolean isRequestUriParameterSupported();

    public boolean isRequireRequestUriRegistration();

    public String getBackingIdpUriPrefix();

    public String getAuthProxyEndpointUrl();

    public String getTrustStoreRef();

    public PublicKey getPublicKey(String var1) throws KeyStoreException, CertificateException;

    public Pattern getProtectedEndpointsPattern();

    public Pattern getEndpointsPattern();

    public Pattern getNonEndpointsPattern();

    public boolean isJwkEnabled();

    public String getJwkJsonString();

    public JSONWebKey getJSONWebKey();

    public long getJwkRotationTime();

    public int getJwkSigningKeySize();

    public boolean isOpenidScopeRequiredForUserInfo();

    public String getKeyStoreRef();

    public String getKeyAliasName();
}

