/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.archive.ArchiveEntryConfig;
import com.ibm.ws.kernel.boot.archive.ArchiveFactory;
import com.ibm.ws.kernel.boot.archive.DirEntryConfig;
import com.ibm.ws.kernel.boot.archive.DirPattern;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import com.ibm.ws.kernel.boot.internal.commands.ArchiveProcessor;
import com.ibm.ws.kernel.boot.internal.commands.ProcessorUtils;
import com.ibm.ws.kernel.provisioning.ProductExtension;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;

public class PackageProcessor
implements ArchiveProcessor {
    private final String processName;
    private final File packageFile;
    private final BootstrapConfig bootProps;
    private final Map<PackageOption, String> options;
    protected static final String DEFAULT_CONFIG_LOCATION_KEY = "configLocation";
    private final File wlpUserDir;
    private final File processConfigDir;
    private final File workAreaTmpDir;
    private final Set<File> looseFiles = new HashSet<File>();
    private final Set<String> processContent;
    final File installRoot;
    final String wlpProperty = "/lib/versions/WebSphereApplicationServer.properties";
    final String wlpPropertyBackup = "WebSphereApplicationServer.properties.bak";
    protected static final String PACKAGE_ARCHIVE_PREFIX = "wlp/";
    public String packageArchiveEntryPrefix = "wlp/";
    public boolean isServerRootOptionSet = false;

    public PackageProcessor(String processName, File packageFile, BootstrapConfig bootProps, List<ArchiveProcessor.Pair<PackageOption, String>> options, Set<String> processContent) {
        this.processName = processName;
        this.packageFile = packageFile;
        this.bootProps = bootProps;
        this.installRoot = bootProps.getInstallRoot();
        this.options = new HashMap<PackageOption, String>();
        if (options != null) {
            for (ArchiveProcessor.Pair<PackageOption, String> option : options) {
                this.options.put(option.getPairKey(), option.getPairValue());
            }
        }
        this.wlpUserDir = bootProps.getUserRoot();
        this.processConfigDir = bootProps.getConfigFile(null);
        this.processContent = processContent;
        this.workAreaTmpDir = new File(bootProps.get("server.tmp.dir"));
        this.workAreaTmpDir.mkdirs();
    }

    private boolean isIncludeOptionEqualToUsr() {
        String val = this.options.get((Object)PackageOption.INCLUDE);
        return IncludeOption.USR.matches(val);
    }

    protected File buildManifestForIncludeEqualsUsr(File installationManifest) throws IOException {
        Manifest mf = new Manifest();
        mf.read(new FileInputStream(installationManifest));
        mf.getMainAttributes().remove(new Attributes.Name("License-Agreement"));
        mf.getMainAttributes().remove(new Attributes.Name("License-Information"));
        mf.getMainAttributes().remove(new Attributes.Name("Applies-To"));
        mf.getMainAttributes().remove(new Attributes.Name("Extract-Installer"));
        mf.getMainAttributes().putValue("Applies-To", "com.ibm.websphere.appserver");
        mf.getMainAttributes().putValue("Extract-Installer", "false");
        File newMani = new File(this.workAreaTmpDir, "MANIFEST.usrinclude.tmp");
        try (FileOutputStream out = new FileOutputStream(newMani);){
            mf.write(out);
        }
        return newMani;
    }

    private boolean doesIncludeOptionHaveRunnable() {
        String val = this.options.get((Object)PackageOption.INCLUDE);
        return IncludeOption.RUNNABLE.matches(val);
    }

    protected File buildManifestForIncludeHasRunnable(File installationManifest) throws IOException {
        Manifest mf = new Manifest();
        mf.read(new FileInputStream(installationManifest));
        mf.getMainAttributes().remove(new Attributes.Name("License-Agreement"));
        mf.getMainAttributes().remove(new Attributes.Name("License-Information"));
        mf.getMainAttributes().putValue("Main-Class", "wlp.lib.extract.SelfExtractRun");
        mf.getMainAttributes().putValue("Server-Name", this.processName);
        if (System.getProperty("java.specification.version") != null && !System.getProperty("java.specification.version").startsWith("1.")) {
            HashMap<String, String> map = this.readJava9Options();
            mf.getMainAttributes().putValue("Add-Exports", map.get("exports"));
            mf.getMainAttributes().putValue("Add-Opens", map.get("opens"));
        }
        File newMani = new File(this.workAreaTmpDir, "MANIFEST.usrinclude.tmp");
        try (FileOutputStream out = new FileOutputStream(newMani);){
            mf.write(out);
        }
        return newMani;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ReturnCode execute(boolean runtimeOnly) {
        block21: {
            block20: {
                archive = null;
                rc = this.backupWebSphereApplicationServerProperty(this.installRoot);
                if (!rc.equals(ReturnCode.OK)) {
                    return rc;
                }
                if (!this.isIncludeOptionEqualToUsr() || !this.isArchiveJar()) break block20;
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.package.usr.jar"), new Object[]{this.processName}));
                var4_4 = ReturnCode.ERROR_SERVER_PACKAGE;
                Utils.tryToClose(archive);
                this.restoreWebSphereApplicationServerProperty(this.installRoot);
                FileUtils.recursiveClean(this.workAreaTmpDir);
                return var4_4;
            }
            archive = ArchiveFactory.create(this.packageFile, this.java2SecurityEnabled());
            if (!this.isArchiveJar()) ** GOTO lbl43
            manifest = new File(this.bootProps.getInstallRoot(), "lib/extract/META-INF/MANIFEST.MF");
            if (!manifest.exists()) {
                manifest = new File(this.bootProps.getInstallRoot().getParentFile(), "META-INF/MANIFEST.MF");
            }
            if (manifest.exists()) break block21;
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.minify.missing.manifest"), new Object[]{this.processName}));
            var5_7 = ReturnCode.ERROR_SERVER_PACKAGE;
            Utils.tryToClose(archive);
            this.restoreWebSphereApplicationServerProperty(this.installRoot);
            FileUtils.recursiveClean(this.workAreaTmpDir);
            return var5_7;
        }
        try {
            if (this.isIncludeOptionEqualToUsr()) {
                archive.addFileEntry("META-INF/MANIFEST.MF", this.buildManifestForIncludeEqualsUsr(manifest));
            } else if (this.doesIncludeOptionHaveRunnable()) {
                archive.addFileEntry("META-INF/MANIFEST.MF", this.buildManifestForIncludeHasRunnable(manifest));
            } else {
                archive.addFileEntry("META-INF/MANIFEST.MF", manifest);
            }
            archive.addEntryConfigs(this.createSelfExtractEntryConfigs());
lbl43:
            // 2 sources

            if (this.options.isEmpty()) {
                archive.addEntryConfigs(this.createAllConfigs(this.processName, runtimeOnly));
            } else {
                val = this.options.get((Object)PackageOption.INCLUDE);
                if (this.includeAllorNoMinifyRunnable(val)) {
                    archive.addEntryConfigs(this.createAllConfigs(this.processName, runtimeOnly));
                } else if (this.includeUsr(val)) {
                    archive.addEntryConfigs(this.createUsrConfigs(this.processName, true));
                } else if (this.bootProps.getProcessType() != "client" && this.includeMinifyorMinifyRunnable(val)) {
                    archive.addEntryConfigs(this.createMinifyConfigs(this.processName));
                } else {
                    System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("warn.packageServer.include.unknownOption"), new Object[]{val}));
                    archive.addEntryConfigs(this.createAllConfigs(this.processName, runtimeOnly));
                }
            }
            archive.create();
        }
        catch (IOException e) {
            try {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.unableZipDir"), new Object[]{e}));
                Debug.printStackTrace(e);
                var5_8 = ReturnCode.ERROR_SERVER_PACKAGE;
            }
            catch (Throwable var6_9) {
                Utils.tryToClose(archive);
                this.restoreWebSphereApplicationServerProperty(this.installRoot);
                FileUtils.recursiveClean(this.workAreaTmpDir);
                throw var6_9;
            }
            Utils.tryToClose(archive);
            this.restoreWebSphereApplicationServerProperty(this.installRoot);
            FileUtils.recursiveClean(this.workAreaTmpDir);
            return var5_8;
        }
        Utils.tryToClose(archive);
        this.restoreWebSphereApplicationServerProperty(this.installRoot);
        FileUtils.recursiveClean(this.workAreaTmpDir);
        return ReturnCode.OK;
    }

    private boolean includeAllorNoMinifyRunnable(String val) {
        return IncludeOption.ALL.matches(val) || IncludeOption.RUNNABLE.matches(val) && !IncludeOption.MINIFY.matches(val);
    }

    private boolean includeMinifyorMinifyRunnable(String val) {
        return IncludeOption.MINIFY.matches(val);
    }

    private boolean includeUsr(String val) {
        return IncludeOption.USR.matches(val);
    }

    private List<ArchiveEntryConfig> createSelfExtractEntryConfigs() throws IOException {
        ArrayList<ArchiveEntryConfig> entryConfigs = new ArrayList<ArchiveEntryConfig>();
        File metaInf = new File(this.bootProps.getInstallRoot(), "lib/extract/META-INF");
        if (!metaInf.exists()) {
            File aboveRoot = this.bootProps.getInstallRoot().getParentFile();
            metaInf = new File(aboveRoot, "META-INF");
        }
        DirEntryConfig metaInfDirConfig = new DirEntryConfig("META-INF/", metaInf, false, DirPattern.PatternStrategy.IncludePreference);
        metaInfDirConfig.exclude(Pattern.compile(Pattern.quote(new File(metaInf, "MANIFEST.MF").getAbsolutePath())));
        entryConfigs.add(metaInfDirConfig);
        this.addLibExtractDir(entryConfigs);
        return entryConfigs;
    }

    private List<ArchiveEntryConfig> createMinifyConfigs(String processName) throws IOException {
        ArrayList<ArchiveEntryConfig> entryConfigs = new ArrayList<ArchiveEntryConfig>();
        Set<String> featureResourcePaths = this.processContent;
        DirEntryConfig rootDirConfig = new DirEntryConfig(this.packageArchiveEntryPrefix, this.bootProps.getInstallRoot(), false, DirPattern.PatternStrategy.ExcludePreference);
        entryConfigs.add(rootDirConfig);
        ArrayList<DirEntryConfig> extensionDirConfigs = new ArrayList<DirEntryConfig>();
        for (ProductExtensionInfo info : ProductExtension.getProductExtensions()) {
            File extensionDir = new File(info.getLocation());
            if (!extensionDir.isAbsolute()) {
                File parentDir = this.bootProps.getInstallRoot().getParentFile();
                extensionDir = ProcessorUtils.getFileFromDirectory(parentDir, info.getLocation());
            }
            DirEntryConfig looseExtensionDirConfig = new DirEntryConfig(info.getLocation(), extensionDir, false, DirPattern.PatternStrategy.ExcludePreference);
            extensionDirConfigs.add(looseExtensionDirConfig);
        }
        for (String s : featureResourcePaths) {
            String match = Pattern.quote(s);
            Pattern featurePattern = Pattern.compile(match);
            rootDirConfig.include(featurePattern);
            for (DirEntryConfig extensionDirConfig : extensionDirConfigs) {
                extensionDirConfig.include(featurePattern);
                entryConfigs.add(extensionDirConfig);
            }
        }
        boolean isJarPackage = this.packageFile.getName().endsWith(".jar");
        File lafilesDir = new File(this.bootProps.getInstallRoot(), "lafiles");
        if (lafilesDir.exists()) {
            DirEntryConfig lafilesDirConfig = new DirEntryConfig(this.packageArchiveEntryPrefix + "lafiles", lafilesDir, true, DirPattern.PatternStrategy.IncludePreference);
            entryConfigs.add(lafilesDirConfig);
        }
        File templatesDir = new File(this.bootProps.getInstallRoot(), "templates");
        DirEntryConfig templatesDirConfig = new DirEntryConfig(this.packageArchiveEntryPrefix + "templates", templatesDir, true, DirPattern.PatternStrategy.IncludePreference);
        entryConfigs.add(templatesDirConfig);
        if (!isJarPackage) {
            this.addLibExtractDir(entryConfigs);
        }
        entryConfigs.addAll(this.createUsrConfigs(processName, false));
        entryConfigs.addAll(this.createPkgInfoConfigs(processName));
        return entryConfigs;
    }

    private void addLibExtractDir(List<ArchiveEntryConfig> entryConfigs) throws IOException {
        try {
            File libExtractDir = new File(this.bootProps.getInstallRoot(), "lib/extract");
            DirEntryConfig libExtractDirConfig = new DirEntryConfig(this.packageArchiveEntryPrefix + "lib/extract", libExtractDir, true, DirPattern.PatternStrategy.IncludePreference);
            entryConfigs.add(libExtractDirConfig);
        }
        catch (FileNotFoundException ex) {
            System.out.println(BootstrapConstants.messages.getString("error.package.missingLibExtractDir"));
            throw ex;
        }
    }

    private List<ArchiveEntryConfig> createAllConfigs(String processName, boolean runtimeOnly) throws IOException {
        ArrayList<ArchiveEntryConfig> entryConfigs = new ArrayList<ArchiveEntryConfig>();
        String regexInstallRootName = Pattern.quote(this.bootProps.getInstallRoot().getName());
        DirEntryConfig rootDirConfig = new DirEntryConfig(this.packageArchiveEntryPrefix, this.bootProps.getInstallRoot(), true, DirPattern.PatternStrategy.IncludePreference);
        entryConfigs.add(rootDirConfig);
        rootDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexInstallRootName + REGEX_SEPARATOR + "usr"));
        if (this.packageFile.getName().endsWith(".jar")) {
            File libExtract = new File(this.bootProps.getInstallRoot(), "lib/extract");
            rootDirConfig.exclude(Pattern.compile(Pattern.quote(libExtract.getAbsolutePath())));
        }
        String installRootAbsPath = this.bootProps.getInstallRoot().getAbsolutePath();
        String userRootAbsPath = this.bootProps.getUserRoot().getAbsolutePath();
        String processOutputAbsPath = this.bootProps.getOutputFile(null).getAbsolutePath();
        if (userRootAbsPath.contains(installRootAbsPath)) {
            rootDirConfig.exclude(Pattern.compile(Pattern.quote(userRootAbsPath)));
        }
        if (processOutputAbsPath.contains(installRootAbsPath)) {
            rootDirConfig.exclude(Pattern.compile(Pattern.quote(processOutputAbsPath)));
        }
        if (!runtimeOnly) {
            entryConfigs.addAll(this.createUsrConfigs(processName, true));
        }
        entryConfigs.addAll(this.createPkgInfoConfigs(processName));
        File prodExtDir = ProcessorUtils.getFileFromDirectory(this.wlpUserDir.getParentFile(), "/etc/extensions");
        if (prodExtDir.exists()) {
            DirEntryConfig prodExtDirConfig = new DirEntryConfig(this.packageArchiveEntryPrefix + "etc/extensions", prodExtDir, true, DirPattern.PatternStrategy.IncludePreference);
            entryConfigs.add(prodExtDirConfig);
        }
        for (ProductExtensionInfo info : ProductExtension.getProductExtensions()) {
            File extensionDir = new File(info.getLocation());
            if (!extensionDir.isAbsolute()) {
                File parentDir = this.bootProps.getInstallRoot().getParentFile();
                extensionDir = ProcessorUtils.getFileFromDirectory(parentDir, info.getLocation());
            }
            DirEntryConfig looseExtensionDirConfig = new DirEntryConfig(info.getLocation(), extensionDir, true, DirPattern.PatternStrategy.IncludePreference);
            entryConfigs.add(looseExtensionDirConfig);
        }
        return entryConfigs;
    }

    private List<ArchiveEntryConfig> createUsrConfigs(String processName, boolean addUsrExtension) throws IOException {
        ArrayList<ArchiveEntryConfig> entryConfigs = new ArrayList<ArchiveEntryConfig>();
        this.getReferencedResources(entryConfigs);
        String locAreaName = "servers";
        if (this.bootProps.getProcessType() == "client") {
            locAreaName = "clients";
        }
        DirEntryConfig processConfigDirConfig = null;
        processConfigDirConfig = this.isServerRootOptionSet && this.includeUsr(this.options.get((Object)PackageOption.INCLUDE)) ? new DirEntryConfig(this.packageArchiveEntryPrefix + locAreaName + "/" + processName + "/", this.processConfigDir, true, DirPattern.PatternStrategy.IncludePreference) : new DirEntryConfig(this.packageArchiveEntryPrefix + "usr" + "/" + locAreaName + "/" + processName + "/", this.processConfigDir, true, DirPattern.PatternStrategy.IncludePreference);
        entryConfigs.add(processConfigDirConfig);
        String regexProcessName = Pattern.quote(processName);
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "workarea"));
        processConfigDirConfig.include(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "workarea" + REGEX_SEPARATOR + "\\.sLock$"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "logs"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "dump_" + "\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "core\\.[^\\\\/]+\\.dmp"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "heapdump\\.[^\\\\/]+\\.phd"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "java\\.[^\\\\/]+\\.hprof"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "javacore\\.[^\\\\/]+\\.txt"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "javadump\\.[^\\\\/]+\\.txt"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + "\\.(zip|pax|jar)$"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + "\\.dump-" + "\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d" + "\\.(zip|pax)$"));
        processConfigDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "package_" + "\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d" + "\\.txt"));
        for (File app : this.looseFiles) {
            String appName = "." + app.getName().replace(".", "\\.");
            processConfigDirConfig.exclude(Pattern.compile(appName));
        }
        File sharedDir = ProcessorUtils.getFileFromDirectory(this.wlpUserDir, "shared");
        if (sharedDir.exists()) {
            DirEntryConfig serverSharedDirConfig = null;
            serverSharedDirConfig = this.isServerRootOptionSet && this.includeUsr(this.options.get((Object)PackageOption.INCLUDE)) ? new DirEntryConfig(this.packageArchiveEntryPrefix + "shared" + "/", sharedDir, true, DirPattern.PatternStrategy.IncludePreference) : new DirEntryConfig(this.packageArchiveEntryPrefix + "usr" + "/" + "shared" + "/", sharedDir, true, DirPattern.PatternStrategy.IncludePreference);
            entryConfigs.add(serverSharedDirConfig);
            serverSharedDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + "resources" + REGEX_SEPARATOR + "security" + REGEX_SEPARATOR + "key.jks"));
            serverSharedDirConfig.exclude(Pattern.compile(REGEX_SEPARATOR + "resources" + REGEX_SEPARATOR + "security" + REGEX_SEPARATOR + "key.p12"));
            for (File app : this.looseFiles) {
                String appName = "." + app.getName().replace(".", "\\.");
                if (!FileUtils.isUnderDirectory(app, sharedDir)) continue;
                serverSharedDirConfig.exclude(Pattern.compile(appName));
            }
        }
        if (addUsrExtension) {
            File extensionDir = ProcessorUtils.getFileFromDirectory(this.wlpUserDir, "extension");
            DirEntryConfig serverExtensionDirConfig = null;
            if (extensionDir.exists()) {
                serverExtensionDirConfig = this.isServerRootOptionSet && this.includeUsr(this.options.get((Object)PackageOption.INCLUDE)) ? new DirEntryConfig(this.packageArchiveEntryPrefix + "extension" + "/", extensionDir, true, DirPattern.PatternStrategy.IncludePreference) : new DirEntryConfig(this.packageArchiveEntryPrefix + "usr" + "/" + "extension" + "/", extensionDir, true, DirPattern.PatternStrategy.IncludePreference);
                entryConfigs.add(serverExtensionDirConfig);
            }
        }
        return entryConfigs;
    }

    private List<ArchiveEntryConfig> createPkgInfoConfigs(String processName) throws IOException {
        ArrayList<ArchiveEntryConfig> entryConfigs = new ArrayList<ArchiveEntryConfig>();
        String regexProcessName = Pattern.quote(processName);
        DirEntryConfig processPkgInfoConfig = new DirEntryConfig(this.packageArchiveEntryPrefix + "lib" + "/versions/", this.bootProps.getOutputFile(null), false, DirPattern.PatternStrategy.IncludePreference);
        entryConfigs.add(processPkgInfoConfig);
        processPkgInfoConfig.include(Pattern.compile(REGEX_SEPARATOR + regexProcessName + REGEX_SEPARATOR + "package_" + "\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d" + "\\.txt"));
        return entryConfigs;
    }

    private void getReferencedResources(List<ArchiveEntryConfig> entryConfigs) throws IOException {
        this.getLooseApplications(entryConfigs);
    }

    private void getLooseApplications(List<ArchiveEntryConfig> entryConfigs) throws IOException {
        this.looseFiles.addAll(ProcessorUtils.getLooseConfigFiles(this.bootProps));
        Iterator<File> it = this.looseFiles.iterator();
        while (it.hasNext()) {
            File lf = it.next();
            ProcessorUtils.LooseConfig looseConfig = null;
            try {
                looseConfig = ProcessorUtils.convertToLooseConfig(lf);
                if (looseConfig != null) {
                    try {
                        entryConfigs.addAll(ProcessorUtils.createLooseExpandedArchiveEntryConfigs(looseConfig, lf, this.bootProps, this.packageArchiveEntryPrefix, this.includeUsr(this.options.get((Object)PackageOption.INCLUDE))));
                    }
                    catch (FileNotFoundException e) {
                        System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("warning.unableToPackageLooseConfigFileMissingPath"), lf));
                        Debug.printStackTrace(e);
                        it.remove();
                    }
                    continue;
                }
                it.remove();
            }
            catch (Exception e) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("warn.package.invalid.looseFile"), lf));
                Debug.printStackTrace(e);
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReturnCode restoreWebSphereApplicationServerProperty(File wlpRoot) {
        File propertyBackupFile = new File(this.workAreaTmpDir, "WebSphereApplicationServer.properties.bak");
        File propertyFile = new File(wlpRoot, "/lib/versions/WebSphereApplicationServer.properties");
        if (propertyBackupFile != null && propertyBackupFile.exists() && propertyFile != null && propertyFile.exists()) {
            Properties wlpProp = new Properties();
            FileInputStream fio = null;
            FileOutputStream propertyOutput = null;
            try {
                fio = new FileInputStream(propertyBackupFile);
                wlpProp.load(fio);
                propertyOutput = new FileOutputStream(propertyFile);
                wlpProp.store(propertyOutput, null);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                ReturnCode returnCode = ReturnCode.RUNTIME_EXCEPTION;
                return returnCode;
            }
            finally {
                if (fio != null) {
                    try {
                        fio.close();
                    }
                    catch (IOException e) {
                        Debug.printStackTrace(e);
                        return ReturnCode.RUNTIME_EXCEPTION;
                    }
                }
                if (propertyOutput != null) {
                    try {
                        propertyOutput.close();
                    }
                    catch (IOException e) {
                        Debug.printStackTrace(e);
                        return ReturnCode.RUNTIME_EXCEPTION;
                    }
                }
                propertyBackupFile.delete();
            }
        }
        return ReturnCode.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReturnCode backupWebSphereApplicationServerProperty(File wlpRoot) {
        File propertyFile = new File(wlpRoot, "/lib/versions/WebSphereApplicationServer.properties");
        if (propertyFile != null && propertyFile.exists()) {
            File propertyBackupFile = new File(this.workAreaTmpDir, "WebSphereApplicationServer.properties.bak");
            Properties wlpProp = new Properties();
            FileInputStream fio = null;
            FileOutputStream propertyOutput = null;
            FileOutputStream propertyBackupFileOutput = null;
            try {
                fio = new FileInputStream(propertyFile);
                wlpProp.load(fio);
                if (wlpProp.getProperty("com.ibm.websphere.productInstallType").equals("Archive")) {
                    ReturnCode returnCode = ReturnCode.OK;
                    return returnCode;
                }
                propertyOutput = new FileOutputStream(propertyFile);
                propertyBackupFileOutput = new FileOutputStream(propertyBackupFile);
                wlpProp.store(propertyBackupFileOutput, null);
                wlpProp.setProperty("com.ibm.websphere.productInstallType", "Archive");
                wlpProp.store(propertyOutput, "com.ibm.websphere.productInstallType=InstallationManager");
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                ReturnCode returnCode = ReturnCode.RUNTIME_EXCEPTION;
                return returnCode;
            }
            finally {
                if (fio != null) {
                    try {
                        fio.close();
                    }
                    catch (IOException e) {
                        Debug.printStackTrace(e);
                        return ReturnCode.RUNTIME_EXCEPTION;
                    }
                }
                if (propertyOutput != null) {
                    try {
                        propertyOutput.close();
                    }
                    catch (IOException e) {
                        Debug.printStackTrace(e);
                        return ReturnCode.RUNTIME_EXCEPTION;
                    }
                }
                if (propertyBackupFileOutput != null) {
                    try {
                        propertyBackupFileOutput.close();
                    }
                    catch (IOException e) {
                        Debug.printStackTrace(e);
                        return ReturnCode.RUNTIME_EXCEPTION;
                    }
                }
            }
        }
        return ReturnCode.OK;
    }

    public boolean hasProductExtentions() {
        File prodExtDir = ProcessorUtils.getFileFromDirectory(this.wlpUserDir.getParentFile(), "/etc/extension");
        return prodExtDir.exists();
    }

    public void setArchivePrefix(String prefix) {
        this.packageArchiveEntryPrefix = prefix + "/";
        this.isServerRootOptionSet = true;
    }

    private boolean java2SecurityEnabled() {
        SecurityManager sm = System.getSecurityManager();
        return sm != null;
    }

    private boolean isArchiveJar() {
        return this.packageFile.getName().endsWith(".jar");
    }

    private HashMap<String, String> readJava9Options() throws IOException {
        HashMap<String, String> hm = new HashMap<String, String>();
        StringBuffer exports = new StringBuffer();
        StringBuffer opens = new StringBuffer();
        BufferedReader r = new BufferedReader(new FileReader(this.installRoot.getAbsolutePath() + File.separator + "lib" + File.separator + "platform" + File.separator + "java" + File.separator + "java9.options"));
        String line = r.readLine();
        while (line != null) {
            if (!line.startsWith("#")) {
                if (line.contains("--add-export")) {
                    line = r.readLine();
                    exports.append(this.getValue(line) + " ");
                } else if (line.contains("--add-open")) {
                    line = r.readLine();
                    opens.append(this.getValue(line) + " ");
                }
            }
            line = r.readLine();
        }
        hm.put("exports", exports.toString().trim());
        hm.put("opens", opens.toString().trim());
        r.close();
        return hm;
    }

    private String getValue(String line) {
        int loc = line.indexOf("=");
        return line.substring(0, loc);
    }

    public static enum IncludeOption {
        ALL("all"),
        USR("usr"),
        MINIFY("minify"),
        WLP("wlp"),
        RUNNABLE("runnable");

        private final String value;

        private IncludeOption(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean matches(String optionValue) {
            if (optionValue != null) {
                String[] optionValues;
                for (String option : optionValues = optionValue.split(",")) {
                    if (!option.equalsIgnoreCase(this.value)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum PackageOption {
        INCLUDE;

    }
}

