/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.LaunchArguments;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import java.io.File;
import java.io.FileFilter;
import java.text.MessageFormat;
import java.util.TreeSet;

public class ListServerHelper {
    private final File serversDir;

    public ListServerHelper(BootstrapConfig bootProps, LaunchArguments launchArgs) {
        this.serversDir = new File(bootProps.getUserRoot(), "servers");
    }

    public ReturnCode listServers() {
        File[] dirs = this.serversDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                File serverXML = new File(arg0, "server.xml");
                return !arg0.isHidden() && arg0.isDirectory() && serverXML.exists() && serverXML.isFile();
            }
        });
        if (dirs == null || dirs.length == 0) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.no.servers.defined"), this.serversDir.getParent()));
        } else {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.list.of.defined.servers"), this.serversDir.getParent()));
            System.out.println();
            TreeSet<String> servers = new TreeSet<String>();
            for (File dir : dirs) {
                servers.add(dir.getName());
            }
            for (String serverName : servers) {
                System.out.println(serverName);
            }
        }
        return ReturnCode.OK;
    }
}

