/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.internal.commands.JavaDumpAction;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumper;
import com.ibm.ws.kernel.boot.internal.commands.ServerDumpUtil;
import java.io.File;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.regex.Pattern;

class IBMLegacyJavaDumperImpl
extends JavaDumper {
    private static final Pattern HEAPDUMP_PATTERN = IBMLegacyJavaDumperImpl.createPattern("heapdump", "phd");
    private static final Pattern JAVACORE_PATTERN = IBMLegacyJavaDumperImpl.createPattern("javacore", "txt");
    private static final Pattern CORE_DUMP_PATTERN = IBMLegacyJavaDumperImpl.createPattern("core", "dmp");
    private final Class<?> dumpClass;

    private static Pattern createPattern(String prefix, String suffix) {
        return Pattern.compile(prefix + "\\.\\d{8}\\.\\d{6}\\..+?\\.\\d+\\." + suffix);
    }

    IBMLegacyJavaDumperImpl(Class<?> dumpClass) {
        this.dumpClass = dumpClass;
    }

    @Override
    public File dump(JavaDumpAction action, File outputDir) {
        String methodName;
        Pattern pattern;
        String dumpDirVar;
        switch (action) {
            case HEAP: {
                dumpDirVar = "IBM_HEAPDUMPDIR";
                pattern = HEAPDUMP_PATTERN;
                methodName = "HeapDump";
                break;
            }
            case SYSTEM: {
                dumpDirVar = "IBM_COREDIR";
                pattern = CORE_DUMP_PATTERN;
                methodName = "SystemDump";
                break;
            }
            case THREAD: {
                dumpDirVar = "IBM_JAVACOREDIR";
                pattern = JAVACORE_PATTERN;
                methodName = "JavaDump";
                break;
            }
            default: {
                return null;
            }
        }
        String dumpDirName = System.getenv(dumpDirVar);
        File dumpDir = dumpDirName != null ? new File(dumpDirName) : new File(System.getProperty("user.dir"));
        TreeSet<String> existingDumps = new TreeSet<String>();
        Object[] fileNames = dumpDir.list();
        if (fileNames != null) {
            for (Object fileName : fileNames) {
                if (!pattern.matcher((CharSequence)fileName).matches()) continue;
                existingDumps.add((String)fileName);
            }
        }
        try {
            this.dumpClass.getMethod(methodName, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        fileNames = dumpDir.list();
        if (fileNames != null) {
            Arrays.sort(fileNames);
            for (Object fileName : fileNames) {
                if (existingDumps.contains(fileName) || !pattern.matcher((CharSequence)fileName).matches()) continue;
                return new File(dumpDir, (String)fileName);
            }
        }
        if (ServerDumpUtil.isZos() && JavaDumpAction.SYSTEM == action) {
            return null;
        }
        throw new IllegalStateException("failed to find generated dump file");
    }
}

