/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.spi.naming;

import java.util.Arrays;
import org.apache.yoko.orb.CosNaming.tnaming2.NamingContextImpl;
import org.apache.yoko.orb.OB.BootLocator;
import org.apache.yoko.orb.OB.BootManager;
import org.apache.yoko.orb.OB.BootManagerHelper;
import org.apache.yoko.orb.OB.BootManagerPackage.NotFound;
import org.apache.yoko.orb.spi.naming.RemoteAccess;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.ObjectHolder;
import org.omg.CORBA.Policy;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class NameServiceInitializer
extends LocalObject
implements ORBInitializer {
    public static final String NS_ORB_INIT_PROP = ORBInitializer.class.getName() + "Class." + NameServiceInitializer.class.getName();
    public static final String SERVICE_NAME = "NameService";
    public static final String POA_NAME = "NameServicePOA";
    public static final String NS_REMOTE_ACCESS_ARG = "-YokoNameServiceRemoteAccess";
    private static final long serialVersionUID = 1L;
    private RemoteAccess remoteAccess = RemoteAccess.readWrite;

    public static final Policy[] createPOAPolicies(POA rootPOA) {
        return new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN)};
    }

    public void pre_init(ORBInitInfo info) {
        try {
            NamingContextImpl local = new NamingContextImpl();
            info.register_initial_reference(SERVICE_NAME, (Object)local);
            String[] args = info.arguments();
            for (int i = 0; i < args.length - 1; ++i) {
                switch (args[i]) {
                    case "-YokoNameServiceRemoteAccess": {
                        this.remoteAccess = RemoteAccess.valueOf(args[++i]);
                    }
                }
            }
        }
        catch (Exception e) {
            throw (INITIALIZE)new INITIALIZE().initCause((Throwable)e);
        }
    }

    public void post_init(ORBInitInfo info) {
        try {
            final POA rootPOA = (POA)info.resolve_initial_references("RootPOA");
            final NamingContextImpl local = (NamingContextImpl)info.resolve_initial_references(SERVICE_NAME);
            String serviceName = this.getServiceName(info);
            BootManager bootManager = BootManagerHelper.narrow(info.resolve_initial_references("BootManager"));
            final byte[] objectId = serviceName.getBytes();
            bootManager.set_locator(new BootLocatorImpl(){

                @Override
                public void locate(byte[] oid, ObjectHolder obj, BooleanHolder add) throws NotFound {
                    if (!Arrays.equals(oid, objectId)) {
                        throw new NotFound(new String(oid));
                    }
                    try {
                        rootPOA.the_POAManager().activate();
                        POA nameServicePOA = this.findOrCreatePOA(rootPOA);
                        nameServicePOA.the_POAManager().activate();
                        Servant nameServant = local.getServant(nameServicePOA, NameServiceInitializer.this.remoteAccess);
                        obj.value = nameServant._this_object();
                        add.value = true;
                    }
                    catch (Exception e) {
                        throw (NotFound)((java.lang.Object)new NotFound("Unexpected").initCause(e));
                    }
                }

                private POA findOrCreatePOA(POA rootPOA2) throws AdapterAlreadyExists, InvalidPolicy {
                    try {
                        return rootPOA2.find_POA(NameServiceInitializer.POA_NAME, true);
                    }
                    catch (AdapterNonExistent e) {
                        Policy[] policies = NameServiceInitializer.createPOAPolicies(rootPOA2);
                        return rootPOA2.create_POA(NameServiceInitializer.POA_NAME, null, policies);
                    }
                }
            });
        }
        catch (Exception e) {
            throw (INITIALIZE)new INITIALIZE().initCause((Throwable)e);
        }
    }

    private String getServiceName(ORBInitInfo info) {
        for (String arg : info.arguments()) {
            if (!arg.startsWith("ORBNameService=")) continue;
            return arg.substring("ORBNameService=".length());
        }
        return SERVICE_NAME;
    }

    static abstract class BootLocatorImpl
    extends LocalObject
    implements BootLocator {
        BootLocatorImpl() {
        }
    }
}

