/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.CollocatedServer;
import org.apache.yoko.orb.OB.GIOPServer;
import org.apache.yoko.orb.OB.OAInterface;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.Server;
import org.apache.yoko.orb.OCI.Acceptor;

public final class ServerManager {
    static final Logger logger = Logger.getLogger(ServerManager.class.getName());
    private boolean destroy_ = false;
    private CollocatedServer collocatedServer_;
    private Vector allServers_ = new Vector();

    protected void finalize() throws Throwable {
        Assert.ensure(this.destroy_);
        Assert.ensure(this.allServers_.isEmpty());
        Assert.ensure(this.collocatedServer_ == null);
        super.finalize();
    }

    public ServerManager(ORBInstance orbInstance, Acceptor[] acceptors, OAInterface oaInterface, int concModel) {
        for (int i = 0; i < acceptors.length; ++i) {
            GIOPServer server = new GIOPServer(orbInstance, acceptors[i], oaInterface, concModel);
            this.allServers_.addElement(server);
        }
        this.collocatedServer_ = new CollocatedServer(oaInterface, concModel);
        this.allServers_.addElement(this.collocatedServer_);
    }

    public synchronized void destroy() {
        if (this.destroy_) {
            return;
        }
        this.destroy_ = true;
        Enumeration e = this.allServers_.elements();
        while (e.hasMoreElements()) {
            ((Server)e.nextElement()).destroy();
        }
        this.allServers_.removeAllElements();
        this.collocatedServer_ = null;
    }

    public synchronized void hold() {
        logger.fine("Holding all servers");
        Enumeration e = this.allServers_.elements();
        while (e.hasMoreElements()) {
            ((Server)e.nextElement()).hold();
        }
    }

    public synchronized void activate() {
        logger.fine("Activating all servers");
        Enumeration e = this.allServers_.elements();
        while (e.hasMoreElements()) {
            ((Server)e.nextElement()).activate();
        }
    }

    public synchronized CollocatedServer getCollocatedServer() {
        return this.collocatedServer_;
    }

    public synchronized Server[] getServers() {
        Server[] servers = new Server[this.allServers_.size()];
        for (int i = 0; i < this.allServers_.size(); ++i) {
            servers[i] = (Server)this.allServers_.elementAt(i);
        }
        return servers;
    }
}

