/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.yoko.orb.OB.Assert;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.PolicyListHolder;
import org.omg.PortableInterceptor.PolicyFactory;

public final class PolicyFactoryManager {
    private boolean destroy_;
    Hashtable policyFactoryTableExternal_ = new Hashtable(63);
    Hashtable policyFactoryTableInternal_ = new Hashtable(63);

    void destroy() {
        Assert.ensure(!this.destroy_);
        this.destroy_ = true;
        this.policyFactoryTableInternal_.clear();
        this.policyFactoryTableExternal_.clear();
    }

    public void registerPolicyFactory(int type, PolicyFactory factory, boolean internal) {
        Integer itype;
        Hashtable table = internal ? this.policyFactoryTableInternal_ : this.policyFactoryTableExternal_;
        if (table.containsKey(itype = new Integer(type))) {
            throw new BAD_PARAM();
        }
        table.put(itype, factory);
    }

    public Policy createPolicy(int type, Any any) throws PolicyError {
        Integer itype = new Integer(type);
        Object factory = this.policyFactoryTableInternal_.get(itype);
        if (factory != null) {
            return ((PolicyFactory)factory).create_policy(type, any);
        }
        factory = this.policyFactoryTableExternal_.get(itype);
        if (factory != null) {
            return ((PolicyFactory)factory).create_policy(type, any);
        }
        throw new PolicyError(0);
    }

    public void filterPolicyList(PolicyListHolder in, PolicyListHolder out) {
        Vector<Policy> inVec = new Vector<Policy>();
        for (int i = 0; i < in.value.length; ++i) {
            inVec.addElement(in.value[i]);
        }
        Vector<Policy> outVec = new Vector<Policy>();
        for (int i = 0; i < out.value.length; ++i) {
            outVec.addElement(out.value[i]);
        }
        block2: for (int policy = 0; policy < inVec.size(); ++policy) {
            Policy p = (Policy)inVec.elementAt(policy);
            int type = p.policy_type();
            Enumeration e = this.policyFactoryTableExternal_.keys();
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                if (key != type) continue;
                outVec.addElement(p);
                inVec.removeElementAt(policy);
                --policy;
                continue block2;
            }
        }
        if (inVec.size() != in.value.length) {
            in.value = new Policy[inVec.size()];
            inVec.copyInto(in.value);
        }
        if (outVec.size() != out.value.length) {
            out.value = new Policy[outVec.size()];
            outVec.copyInto(out.value);
        }
    }

    public boolean isPolicyRegistered(int type) {
        Integer itype = new Integer(type);
        return this.policyFactoryTableInternal_.containsKey(itype) || this.policyFactoryTableExternal_.containsKey(itype);
    }
}

