/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.CosNaming.tnaming2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.yoko.orb.CosNaming.tnaming2.NamingContextImpl;
import org.apache.yoko.orb.CosNaming.tnaming2.RemotableObject;
import org.apache.yoko.orb.spi.naming.RemoteAccess;
import org.omg.CORBA.LocalObject;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorPOA;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public final class BindingIteratorImpl
extends LocalObject
implements BindingIterator,
RemotableObject {
    private static final long serialVersionUID = 1L;
    private final Core core;

    public BindingIteratorImpl(Collection<NamingContextImpl.BoundObject> boundObjects) {
        assert (boundObjects != null);
        this.core = new Core(boundObjects);
    }

    public boolean next_one(BindingHolder b) {
        assert (b != null);
        return this.core.next_one(b);
    }

    public boolean next_n(int how_many, BindingListHolder bl) {
        assert (bl != null);
        return this.core.next_n(how_many, bl);
    }

    public void destroy() {
        this.core.destroy();
    }

    @Override
    public Servant getServant(POA poa, RemoteAccess ignored) throws Exception {
        return new POAServant(poa, this.core);
    }

    private static final class POAServant
    extends BindingIteratorPOA {
        private final POA poa;
        private final Core core;

        public POAServant(POA poa, Core core) throws Exception {
            this.poa = poa;
            this.core = core;
            poa.activate_object_with_id(core.getServantId(), (Servant)this);
        }

        public boolean next_one(BindingHolder b) {
            return this.core.next_one(b);
        }

        public boolean next_n(int how_many, BindingListHolder bl) {
            return this.core.next_n(how_many, bl);
        }

        public void destroy() {
            try {
                byte[] objectId = this.poa.servant_to_id((Servant)this);
                if (objectId != null) {
                    this.poa.deactivate_object(objectId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final class Core
    extends BindingIteratorPOA {
        private static final AtomicLong NEXT_ID = new AtomicLong();
        private final long instanceId = NEXT_ID.getAndIncrement();
        private final Iterator<NamingContextImpl.BoundObject> iterator;
        private static final NameComponent[] ZERO_NC_ARRAY = new NameComponent[0];

        public Core(Collection<NamingContextImpl.BoundObject> boundObjects) {
            this.iterator = new ArrayList<NamingContextImpl.BoundObject>(boundObjects).iterator();
        }

        private byte[] getServantId() {
            return ("BindingIterator#" + this.instanceId).getBytes();
        }

        public boolean next_one(BindingHolder b) {
            if (this.iterator.hasNext()) {
                NamingContextImpl.BoundObject obj = this.iterator.next();
                b.value = new Binding(new NameComponent[]{obj.name}, obj.type);
                return true;
            }
            b.value = new Binding(ZERO_NC_ARRAY, BindingType.nobject);
            return false;
        }

        public boolean next_n(int how_many, BindingListHolder bl) {
            ArrayList<Binding> accum = new ArrayList<Binding>();
            BindingHolder holder = new BindingHolder();
            for (int i = 0; i < how_many && this.next_one(holder); ++i) {
                accum.add(holder.value);
            }
            bl.value = accum.toArray(new Binding[accum.size()]);
            return accum.isEmpty();
        }

        public void destroy() {
        }
    }
}

