/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.language.OperationDefinition;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class NoUnusedVariables
extends AbstractRule {
    private final List<VariableDefinition> variableDefinitions = new ArrayList<VariableDefinition>();
    private final Set<String> usedVariables = new LinkedHashSet<String>();

    public NoUnusedVariables(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
        this.setVisitFragmentSpreads(true);
    }

    @Override
    public void leaveOperationDefinition(OperationDefinition operationDefinition) {
        for (VariableDefinition variableDefinition : this.variableDefinitions) {
            if (this.usedVariables.contains(variableDefinition.getName())) continue;
            String message = String.format("Unused variable %s", variableDefinition.getName());
            this.addError(ValidationErrorType.UnusedVariable, variableDefinition.getSourceLocation(), message);
        }
    }

    @Override
    public void checkOperationDefinition(OperationDefinition operationDefinition) {
        this.usedVariables.clear();
        this.variableDefinitions.clear();
    }

    @Override
    public void checkVariableDefinition(VariableDefinition variableDefinition) {
        this.variableDefinitions.add(variableDefinition);
    }

    @Override
    public void checkVariable(VariableReference variableReference) {
        this.usedVariables.add(variableReference.getName());
    }
}

