/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.IgnoredChars;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.SourceLocation;
import graphql.language.Type;
import graphql.language.Value;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class InputValueDefinition
extends AbstractNode<InputValueDefinition>
implements DirectivesContainer<InputValueDefinition>,
NamedNode<InputValueDefinition> {
    private final String name;
    private final Type type;
    private final Value defaultValue;
    private final Description description;
    private final List<Directive> directives;
    public static final String CHILD_TYPE = "type";
    public static final String CHILD_DEFAULT_VALUE = "defaultValue";
    public static final String CHILD_DIRECTIVES = "directives";

    @Internal
    protected InputValueDefinition(String name, Type type, Value defaultValue, List<Directive> directives, Description description, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(sourceLocation, comments, ignoredChars, additionalData);
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.directives = directives;
        this.description = description;
    }

    public InputValueDefinition(String name, Type type) {
        this(name, type, null, new ArrayList<Directive>(), null, null, new ArrayList<Comment>(), IgnoredChars.EMPTY, Collections.emptyMap());
    }

    public InputValueDefinition(String name, Type type, Value defaultValue) {
        this(name, type, defaultValue, new ArrayList<Directive>(), null, null, new ArrayList<Comment>(), IgnoredChars.EMPTY, Collections.emptyMap());
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Description getDescription() {
        return this.description;
    }

    public Value getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public List<Directive> getDirectives() {
        return new ArrayList<Directive>(this.directives);
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(this.type);
        if (this.defaultValue != null) {
            result.add(this.defaultValue);
        }
        result.addAll(this.directives);
        return result;
    }

    @Override
    public NodeChildrenContainer getNamedChildren() {
        return NodeChildrenContainer.newNodeChildrenContainer().child(CHILD_TYPE, this.type).child(CHILD_DEFAULT_VALUE, this.defaultValue).children(CHILD_DIRECTIVES, this.directives).build();
    }

    @Override
    public InputValueDefinition withNewChildren(NodeChildrenContainer newChildren) {
        return this.transform(builder -> builder.type((Type)newChildren.getChildOrNull(CHILD_TYPE)).defaultValue((Value)newChildren.getChildOrNull(CHILD_DEFAULT_VALUE)).directives(newChildren.getChildren(CHILD_DIRECTIVES)));
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputValueDefinition that = (InputValueDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public InputValueDefinition deepCopy() {
        return new InputValueDefinition(this.name, this.deepCopy(this.type), this.deepCopy(this.defaultValue), this.deepCopy(this.directives), this.description, this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    public String toString() {
        return "InputValueDefinition{name='" + this.name + '\'' + ", type=" + this.type + ", defaultValue=" + this.defaultValue + ", directives=" + this.directives + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitInputValueDefinition(this, context);
    }

    public static Builder newInputValueDefinition() {
        return new Builder();
    }

    public InputValueDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private List<Comment> comments = new ArrayList<Comment>();
        private String name;
        private Type type;
        private Value defaultValue;
        private Description description;
        private List<Directive> directives = new ArrayList<Directive>();
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(InputValueDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.name = existing.getName();
            this.type = existing.getType();
            this.defaultValue = existing.getDefaultValue();
            this.description = existing.getDescription();
            this.directives = existing.getDirectives();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder defaultValue(Value defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder description(Description description) {
            this.description = description;
            return this;
        }

        public Builder directives(List<Directive> directives) {
            this.directives = directives;
            return this;
        }

        public Builder directive(Directive directive) {
            this.directives.add(directive);
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public InputValueDefinition build() {
            return new InputValueDefinition(this.name, this.type, this.defaultValue, this.directives, this.description, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

