/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Scalars;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLNonNull;

public class Directives {
    public static final GraphQLDirective IncludeDirective = GraphQLDirective.newDirective().name("include").description("Directs the executor to include this field or fragment only when the `if` argument is true").argument(GraphQLArgument.newArgument().name("if").type(GraphQLNonNull.nonNull(Scalars.GraphQLBoolean)).description("Included when true.")).validLocations(Introspection.DirectiveLocation.FRAGMENT_SPREAD, Introspection.DirectiveLocation.INLINE_FRAGMENT, Introspection.DirectiveLocation.FIELD).build();
    public static final GraphQLDirective SkipDirective = GraphQLDirective.newDirective().name("skip").description("Directs the executor to skip this field or fragment when the `if`'argument is true.").argument(GraphQLArgument.newArgument().name("if").type(GraphQLNonNull.nonNull(Scalars.GraphQLBoolean)).description("Skipped when true.")).validLocations(Introspection.DirectiveLocation.FRAGMENT_SPREAD, Introspection.DirectiveLocation.INLINE_FRAGMENT, Introspection.DirectiveLocation.FIELD).build();
    public static final GraphQLDirective DeferDirective = GraphQLDirective.newDirective().name("defer").description("This directive allows results to be deferred during execution").argument(GraphQLArgument.newArgument().name("if").type(GraphQLNonNull.nonNull(Scalars.GraphQLBoolean)).description("Deferred behaviour is controlled by this argument").defaultValue(true)).validLocations(Introspection.DirectiveLocation.FIELD).build();
    public static final GraphQLDirective DeprecatedDirective = GraphQLDirective.newDirective().name("deprecated").description("Marks the field or enum value as deprecated").argument(GraphQLArgument.newArgument().name("reason").type(GraphQLNonNull.nonNull(Scalars.GraphQLString)).defaultValue("No longer supported").description("The reason for the deprecation")).validLocations(Introspection.DirectiveLocation.FIELD_DEFINITION, Introspection.DirectiveLocation.ENUM_VALUE).build();
}

