/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.DeferredExecutionResult;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.execution.ExecutionPath;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@PublicApi
public class DeferredExecutionResultImpl
extends ExecutionResultImpl
implements DeferredExecutionResult {
    private final List<Object> path;

    private DeferredExecutionResultImpl(List<Object> path, ExecutionResultImpl executionResult) {
        super(executionResult);
        this.path = Assert.assertNotNull(path);
    }

    @Override
    public List<Object> getPath() {
        return this.path;
    }

    @Override
    public Map<String, Object> toSpecification() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(super.toSpecification());
        map.put("path", this.path);
        return map;
    }

    public static Builder newDeferredExecutionResult() {
        return new Builder();
    }

    public static class Builder {
        private List<Object> path = Collections.emptyList();
        private ExecutionResultImpl.Builder builder = ExecutionResultImpl.newExecutionResult();

        public Builder path(ExecutionPath path) {
            this.path = Assert.assertNotNull(path).toList();
            return this;
        }

        public Builder from(ExecutionResult executionResult) {
            this.builder.from((ExecutionResultImpl)executionResult);
            return this;
        }

        public Builder addErrors(List<GraphQLError> errors) {
            this.builder.addErrors(errors);
            return this;
        }

        public DeferredExecutionResult build() {
            ExecutionResultImpl build = this.builder.build();
            return new DeferredExecutionResultImpl(this.path, build);
        }
    }
}

