/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.jms.internal.listener.impl;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor;
import com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointHandler;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.embeddable.RecoverableXAResourceAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.ConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class BaseMessageEndpointFactory
implements MessageEndpointFactory {
    private static final TraceComponent tc = Tr.register(BaseMessageEndpointFactory.class, (String)"wsbatch", null);
    protected static final byte INACTIVE_STATE = 0;
    protected static final byte ACTIVATING_STATE = 1;
    protected static final byte ACTIVE_STATE = 2;
    protected static final byte DEACTIVATING_STATE = 3;
    protected static final byte DEACTIVATE_PENDING_STATE = 4;
    protected static final int RA_DOES_NOT_SUPPORT_XATRANSACTIONS = 0;
    protected static final int ERROR_DURING_TRAN_RECOVERY_SETUP = 1;
    protected byte ivState = 0;
    protected int ivRecoveryId;
    protected boolean ivRecoveryIdKnown = false;
    private boolean ivEnlistNotNeeded = false;
    private int ivEnlistNotNeededReason;
    private boolean ivEnlistNotNeededMessageLogged = false;
    protected Constructor<?> ivProxyCTOR = null;
    private String ivRAKey = null;
    protected boolean ivJMS = false;
    protected int majorJCAVersion = 1;
    protected int minorJCAVersion = 5;
    protected boolean ivRRSTransactional = false;
    protected J2EEName j2eeName = null;
    protected BatchJmsExecutor batchExecutor;
    static final long serialVersionUID = 171461406004026276L;

    public void setJ2eeName(J2EEName j2eeName) {
        this.j2eeName = j2eeName;
    }

    public BaseMessageEndpointFactory(BatchJmsExecutor batchExecutor) {
        this.batchExecutor = batchExecutor;
    }

    public BatchJmsExecutor getBatchExecutor() {
        return this.batchExecutor;
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        return this.createEndpoint(xaResource, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public MessageEndpoint createEndpoint(XAResource xaResource, long timeout) throws UnavailableException {
        Proxy proxy;
        block16: {
            boolean recoverableXAResource = false;
            MessageEndpointHandler handler = null;
            proxy = null;
            Constructor<?> constructor = this.ivProxyCTOR;
            synchronized (constructor) {
                if (!(xaResource == null && !this.ivRRSTransactional || this.ivRecoveryIdKnown && this.ivRecoveryId != 0 || this.ivEnlistNotNeeded)) {
                    if (RecoverableXAResourceAccessor.isRecoverableXAResource((XAResource)xaResource)) {
                        recoverableXAResource = true;
                    } else {
                        throw new UnavailableException("setRecoveryId must be called prior to createEndpoint");
                    }
                }
                if (this.ivState == 2) {
                    if (!this.isEndpointActive()) {
                        throw new UnavailableException("endpoint needs to be activated.");
                    }
                } else {
                    if (this.ivState == 3 || this.ivState == 4) {
                        throw new UnavailableException("deactivate of endpoint is in progress.");
                    }
                    throw new UnavailableException("endpoint needs to be activated.");
                }
            }
            UnavailableException ex = null;
            handler = this.createEndpointHandler();
            try {
                proxy = (Proxy)this.ivProxyCTOR.newInstance(handler);
                handler.ivProxy = proxy;
                if (this.ivEnlistNotNeeded) {
                    if (xaResource == null) {
                        handler.initialize(null, false, this.majorJCAVersion, this.minorJCAVersion);
                    } else {
                        ex = this.mapAndLogTranEnlistmentNotNeeded();
                    }
                } else {
                    handler.initialize(xaResource, recoverableXAResource, this.majorJCAVersion, this.minorJCAVersion);
                }
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.BaseMessageEndpointFactory", (String)"302", (Object)this, (Object[])new Object[]{xaResource, timeout});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("error invoking proxy" + e.toString()), (Object[])new Object[0]);
            }
        }
        return (MessageEndpoint)proxy;
    }

    protected MessageEndpointHandler createEndpointHandler() {
        return new MessageEndpointHandler(this, this.ivRecoveryId, this.ivRRSTransactional);
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        return false;
    }

    public void setRecoveryID(int recoveryId) throws ResourceException {
        if (this.ivRecoveryIdKnown) {
            throw new ApplicationServerInternalException("setRecoveryId can only be called once per factory");
        }
        this.ivRecoveryId = recoveryId;
        this.ivRecoveryIdKnown = true;
    }

    public void setTranEnlistmentNotNeeded(int reason) {
        this.ivEnlistNotNeeded = true;
        this.ivEnlistNotNeededReason = reason;
    }

    private UnavailableException mapAndLogTranEnlistmentNotNeeded() {
        UnavailableException ex = null;
        String exceptionMsg = null;
        switch (this.ivEnlistNotNeededReason) {
            case 0: {
                if (!this.ivEnlistNotNeededMessageLogged && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("RA_DOES_NOT_SUPPORT_XATRANSACTIONS for " + this.ivRAKey + " " + this.j2eeName), (Object[])new Object[0]);
                }
                exceptionMsg = "Transaction recovery not setup for this RA since RA does not support XA transactions";
                break;
            }
            case 1: {
                if (!this.ivEnlistNotNeededMessageLogged && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ERROR_DURING_TRAN_RECOVERY_SETUP for " + this.ivRAKey + " " + this.j2eeName), (Object[])new Object[0]);
                }
                exceptionMsg = "Error occured during transaction recovery setup for this Resource Adapter";
                break;
            }
            default: {
                if (!this.ivEnlistNotNeededMessageLogged && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"REASON_CODE_NOT_RECOGNIZED", (Object[])new Object[0]);
                }
                exceptionMsg = "Error occured during transaction recovery setup for this Resource Adapter";
            }
        }
        this.ivEnlistNotNeededMessageLogged = true;
        ex = new UnavailableException(exceptionMsg);
        return ex;
    }

    public void setRAKey(String raKey) {
        this.ivRAKey = raKey;
    }

    protected abstract boolean isEndpointActive();

    protected J2EEName getJ2EEName() {
        return this.j2eeName;
    }

    public String getActivationName() {
        return this.getJ2EEName().toString();
    }

    public Class<?> getEndpointClass() {
        return "com.ibm.ws.jbatch.jms.listener.BatchJmsEndpointListener".getClass();
    }

    protected ConnectionFactory getConnectionFactory() {
        return this.batchExecutor.getConnectionFactory();
    }
}

