/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.SessionManager;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.ISessionObserver;
import com.ibm.wsspi.session.ISessionStateObserver;
import com.ibm.wsspi.session.IStoreCallback;
import java.util.logging.Level;

public class StoreCallback
implements IStoreCallback {
    private static boolean _loggedVersion = false;
    private SessionManager _sessionManager = null;
    private ISessionStateObserver _sessionStateEventDispatcher = null;
    private ISessionObserver _sessionEventDispatcher = null;
    private static final String methodClassName = "StoreCallback";

    protected StoreCallback(SessionManager sessionManager) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE) && !_loggedVersion) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "", "CMVC Version 1.7 5/30/08 16:34:49");
            _loggedVersion = true;
        }
        this._sessionManager = sessionManager;
        this._sessionEventDispatcher = sessionManager.getSessionEventDispatcher();
        this._sessionStateEventDispatcher = sessionManager.getSessionStateEventDispatcher();
    }

    @Override
    public void registerSessionObserver(ISessionObserver observer) {
        this._sessionManager.registerSessionObserver(observer);
    }

    @Override
    public void sessionDidActivate(ISession session) {
        this._sessionEventDispatcher.sessionDidActivate(session);
    }

    @Override
    public boolean sessionWillPassivate(ISession session) {
        this._sessionEventDispatcher.sessionWillPassivate(session);
        return true;
    }

    @Override
    public boolean sessionInvalidated(ISession session) {
        this._sessionEventDispatcher.sessionDestroyed(session);
        return true;
    }

    @Override
    public boolean sessionInvalidatedByTimeout(ISession session) {
        this._sessionEventDispatcher.sessionDestroyedByTimeout(session);
        return true;
    }

    @Override
    public void sessionAffinityBroke(ISession session) {
        this._sessionEventDispatcher.sessionAffinityBroke(session);
    }

    @Override
    public void sessionCacheDiscard(Object value) {
        this._sessionEventDispatcher.sessionCacheDiscard(value);
    }

    @Override
    public void sessionLiveCountInc(Object value) {
        this._sessionEventDispatcher.sessionLiveCountInc(value);
    }

    @Override
    public void sessionLiveCountDec(Object value) {
        this._sessionEventDispatcher.sessionLiveCountDec(value);
    }

    @Override
    public void sessionAttributeSet(ISession session, Object name, Object oldValue, Object newValue) {
        this._sessionStateEventDispatcher.sessionAttributeSet(session, name, oldValue, Boolean.FALSE, newValue, Boolean.FALSE);
    }

    @Override
    public void sessionAttributeRemoved(ISession session, Object name, Object value) {
        this._sessionStateEventDispatcher.sessionAttributeRemoved(session, name, value, Boolean.FALSE);
    }

    @Override
    public void sessionAttributeSet(ISession session, Object name, Object oldValue, Boolean oldIsListener, Object newValue, Boolean newIsListener) {
        this._sessionStateEventDispatcher.sessionAttributeSet(session, name, oldValue, oldIsListener, newValue, newIsListener);
    }

    @Override
    public void sessionAttributeRemoved(ISession session, Object name, Object value, Boolean oldIsBindingListener) {
        this._sessionStateEventDispatcher.sessionAttributeRemoved(session, name, value, oldIsBindingListener);
    }

    @Override
    public void sessionAttributeAccessed(ISession session, Object name, Object value) {
        this._sessionStateEventDispatcher.sessionAttributeAccessed(session, name, value);
    }

    @Override
    public void sessionUserNameSet(ISession session, String oldUserName, String newUserName) {
        this._sessionStateEventDispatcher.sessionUserNameSet(session, oldUserName, newUserName);
    }

    @Override
    public void sessionLastAccessTimeSet(ISession session, long old, long newaccess) {
        this._sessionStateEventDispatcher.sessionLastAccessTimeSet(session, old, newaccess);
    }

    @Override
    public void sessionMaxInactiveTimeSet(ISession session, int old, int newval) {
        this._sessionStateEventDispatcher.sessionMaxInactiveTimeSet(session, old, newval);
    }

    @Override
    public void sessionExpiryTimeSet(ISession session, long old, long newone) {
        this._sessionStateEventDispatcher.sessionExpiryTimeSet(session, old, newone);
    }

    @Override
    public void sessionFlushed(ISession session) {
        this._sessionEventDispatcher.sessionFlushed(session);
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    @Override
    public void sessionReleased(ISession session) {
        this._sessionEventDispatcher.sessionReleased(session);
    }
}

