/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LDAPUtils {
    private static final Pattern FILTER_CHARS_TO_ESCAPE;
    static final long serialVersionUID = 9106177607913723557L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String escapeLDAPFilterTerm(String term) {
        if (term == null) {
            return null;
        }
        Matcher m = FILTER_CHARS_TO_ESCAPE.matcher(term);
        StringBuffer sb = new StringBuffer(term.length());
        while (m.find()) {
            String replacement = LDAPUtils.escapeFilterChar(m.group().charAt(0));
            m.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String escapeFilterChar(char ch) {
        switch (ch) {
            case '*': {
                return "\\2a";
            }
            case '(': {
                return "\\28";
            }
            case ')': {
                return "\\29";
            }
            case '\\': {
                return "\\5c";
            }
        }
        try {
            byte[] bytes = Character.toString(ch).getBytes("UTF-8");
            switch (bytes.length) {
                case 1: {
                    return String.format("\\%02x", bytes[0]);
                }
                case 2: {
                    return String.format("\\%02x\\%02x", bytes[0], bytes[1]);
                }
                case 3: {
                    return String.format("\\%02x\\%02x\\%02x", bytes[0], bytes[1], bytes[2]);
                }
            }
            throw new CharConversionException("No character should map to more than three UTF-8 bytes");
        }
        catch (UnsupportedEncodingException bytes) {
            FFDCFilter.processException((Throwable)bytes, (String)"com.ibm.wsspi.kernel.service.utils.LDAPUtils", (String)"89", null, (Object[])new Object[]{Character.valueOf(ch)});
            return "";
        }
        catch (CharConversionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.wsspi.kernel.service.utils.LDAPUtils", (String)"92", null, (Object[])new Object[]{Character.valueOf(ch)});
            return "";
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.kernel.service.utils.LDAPUtils", LDAPUtils.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        FILTER_CHARS_TO_ESCAPE = Pattern.compile("[*\\(\\)\\\\\u0000\u0080-\uffff]");
    }
}

