/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;

public class Semaphore {
    private static final TraceComponent tc = SibTr.register(Semaphore.class, "SIBUtils", "com.ibm.ws.sib.utils.CWSIUMessages");
    private int count = 0;

    public Semaphore() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.count = 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public Semaphore(int initialCount) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>", (Object)("" + initialCount));
        }
        this.count = -initialCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public synchronized void waitOn() throws InterruptedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "waitOn", (Object)("" + this.count));
        }
        ++this.count;
        if (this.count > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                --this.count;
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "waitOn");
        }
    }

    public synchronized void post() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "post", (Object)("" + this.count));
        }
        --this.count;
        if (this.count >= 0) {
            this.notify();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "post");
        }
    }

    public synchronized void waitOnIgnoringInterruptions() {
        boolean interrupted;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "waitOnIgnoringInterruptions");
        }
        do {
            interrupted = false;
            try {
                this.waitOn();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while (interrupted);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "waitOnIgnoringInterruptions");
        }
    }
}

