/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.opentracing.OpentracingUserFeatureAccessService;
import com.ibm.ws.opentracing.OpentracingUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpentracingTracerManager {
    private static final TraceComponent tc = Tr.register(OpentracingTracerManager.class, (String)"OPENTRACING", (String)"com.ibm.ws.opentracing.resources.Opentracing");
    private static final Map<String, Tracer> applicationTracers = new ConcurrentHashMap<String, Tracer>();
    private static final Tracer TRACER_NOT_FOUND = new Tracer(){
        static final long serialVersionUID = -5166478871796893107L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Span activeSpan() {
            return null;
        }

        public Tracer.SpanBuilder buildSpan(String arg0) {
            return null;
        }

        public <C> SpanContext extract(Format<C> arg0, C arg1) {
            return null;
        }

        public <C> void inject(SpanContext arg0, Format<C> arg1, C arg2) {
        }

        public ScopeManager scopeManager() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.opentracing.OpentracingTracerManager$1", 1.class, (String)"OPENTRACING", (String)"com.ibm.ws.opentracing.resources.Opentracing");
        }
    };
    static final long serialVersionUID = 4262181261011814780L;

    @Trivial
    @ManualTrace
    private static Tracer ensureTracer(String appName) {
        String methodName = "ensureTracer";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{appName});
        }
        Tracer tracer = null;
        boolean found = true;
        if (appName != null) {
            tracer = applicationTracers.get(appName);
            if (tracer == null) {
                found = false;
                tracer = applicationTracers.computeIfAbsent(appName, TracerCreator.INSTANCE);
            }
            if (tracer == TRACER_NOT_FOUND) {
                tracer = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String tracerCase = appName == null ? "appName is null" : (found ? "previously created" : "newly created or previously created if lost race condition");
            Tr.exit((TraceComponent)tc, (String)(methodName + " (" + tracerCase + ")"), (Object)OpentracingUtils.getTracerText(tracer));
        }
        return tracer;
    }

    @Trivial
    private static Tracer createTracer(String appName) {
        return OpentracingUserFeatureAccessService.getTracerInstance(appName);
    }

    @Trivial
    @ManualTrace
    public static Tracer getTracer() {
        String methodName = "getTracer";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        String appName = null;
        Tracer tracer = null;
        appName = OpentracingUtils.lookupAppName();
        tracer = OpentracingTracerManager.ensureTracer(appName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Thread currentThread = Thread.currentThread();
            String threadName = currentThread.getName();
            long threadId = currentThread.getId();
            Tr.exit((TraceComponent)tc, (String)(methodName + " (" + threadName + ":" + Long.toString(threadId) + ")"), (Object)OpentracingUtils.getTracerText(tracer));
        }
        return tracer;
    }

    public static void removeTracer(String appName) {
        if (appName != null) {
            applicationTracers.remove(appName);
        }
    }

    public static void clearTracers() {
        applicationTracers.clear();
    }

    @Trivial
    private static class TracerCreator
    implements Function<String, Tracer> {
        static TracerCreator INSTANCE = new TracerCreator();

        private TracerCreator() {
        }

        @Override
        public Tracer apply(String appName) {
            Tracer tracer = OpentracingTracerManager.createTracer(appName);
            if (tracer == null) {
                tracer = TRACER_NOT_FOUND;
            }
            return tracer;
        }
    }
}

