/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.ws.security.oauth20.error.impl.BrowserAndServerLogMessage;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import java.util.Enumeration;
import java.util.Locale;

public class OidcServerException
extends OAuth20Exception {
    private static final long serialVersionUID = -5649910420133501512L;
    private static final String OAUTH2_PARM_ERROR = "error";
    private static final String OAUTH2_PARM_ERROR_DESC = "error_description";
    private final String _errorCode;
    private final String _errorDescription;
    private final BrowserAndServerLogMessage _browserServerLog;
    private int _httpStatus = -1;

    public OidcServerException(String description, String code, int httpStatus, Throwable cause) {
        super(code, description, cause);
        this._errorDescription = description;
        this._errorCode = code;
        this._httpStatus = httpStatus;
        this._browserServerLog = null;
    }

    public OidcServerException(String description, String code, int httpStatus) {
        super(code, description, null);
        this._errorDescription = description;
        this._errorCode = code;
        this._httpStatus = httpStatus;
        this._browserServerLog = null;
    }

    public OidcServerException(BrowserAndServerLogMessage browserServerLogMsg, String code, int httpStatus) {
        super(code, null, null);
        this._errorDescription = null;
        this._errorCode = code;
        this._httpStatus = httpStatus;
        this._browserServerLog = browserServerLogMsg;
    }

    public OidcServerException(BrowserAndServerLogMessage browserServerLogMsg, String code, int httpStatus, Throwable cause) {
        super(code, null, cause);
        this._errorDescription = null;
        this._errorCode = code;
        this._httpStatus = httpStatus;
        this._browserServerLog = browserServerLogMsg;
    }

    public String getErrorDescription() {
        if (this._browserServerLog == null) {
            return this._errorDescription;
        }
        return this._browserServerLog.getBrowserErrorMessage();
    }

    public String getErrorDescription(Enumeration<Locale> locales) {
        if (this._browserServerLog == null) {
            return this.getErrorDescription();
        }
        this._browserServerLog.setLocales(locales);
        return this._browserServerLog.getBrowserErrorMessage();
    }

    public String getErrorCode() {
        return this._errorCode;
    }

    public int getHttpStatus() {
        return this._httpStatus;
    }

    public boolean isComplete() {
        return !OidcOAuth20Util.isNullEmpty((String)this._errorCode) && !OidcOAuth20Util.isNullEmpty((String)this._errorDescription) && this._httpStatus != -1;
    }

    public String toJSON() {
        JsonObject errorObject = new JsonObject();
        if (this._errorCode != null) {
            errorObject.add(OAUTH2_PARM_ERROR, (JsonElement)new JsonPrimitive(this._errorCode));
        }
        if (this._errorDescription != null) {
            errorObject.add(OAUTH2_PARM_ERROR_DESC, (JsonElement)new JsonPrimitive(this._errorDescription));
        }
        return errorObject.toString();
    }
}

