/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.injectionengine;

import com.ibm.ws.javaee.dd.common.AdministeredObject;
import com.ibm.ws.javaee.dd.common.ConnectionFactory;
import com.ibm.ws.javaee.dd.common.DataSource;
import com.ibm.ws.javaee.dd.common.EJBRef;
import com.ibm.ws.javaee.dd.common.EnvEntry;
import com.ibm.ws.javaee.dd.common.JMSConnectionFactory;
import com.ibm.ws.javaee.dd.common.JMSDestination;
import com.ibm.ws.javaee.dd.common.JNDIEnvironmentRef;
import com.ibm.ws.javaee.dd.common.JNDIEnvironmentRefs;
import com.ibm.ws.javaee.dd.common.MailSession;
import com.ibm.ws.javaee.dd.common.MessageDestinationRef;
import com.ibm.ws.javaee.dd.common.PersistenceContextRef;
import com.ibm.ws.javaee.dd.common.PersistenceUnitRef;
import com.ibm.ws.javaee.dd.common.ResourceEnvRef;
import com.ibm.ws.javaee.dd.common.ResourceRef;
import com.ibm.ws.javaee.dd.common.wsclient.ServiceRef;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public enum JNDIEnvironmentRefType {
    EnvEntry(EnvEntry.class, "env-entry", "env-entry-name", "Resource", "env-entry"){

        @Override
        public List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs refs) {
            return refs.getEnvEntries();
        }
    }
    ,
    EJBRef(EJBRef.class, "ejb-ref", "ejb-ref-name", "EJB", "ejb-ref"){

        @Override
        public List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs refs) {
            List ejbRefs = refs.getEJBRefs();
            List ejbLocalRefs = refs.getEJBLocalRefs();
            if (ejbRefs.isEmpty()) {
                return ejbLocalRefs;
            }
            if (ejbLocalRefs.isEmpty()) {
                return ejbRefs;
            }
            ArrayList allRefs = new ArrayList(ejbRefs.size() + ejbLocalRefs.size());
            allRefs.addAll(ejbRefs);
            allRefs.addAll(ejbLocalRefs);
            return allRefs;
        }
    }
    ,
    ServiceRef(ServiceRef.class, "service-ref", "service-ref-name", "WebServiceRef", null){

        @Override
        public List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs refs) {
            return refs.getServiceRefs();
        }
    }
    ,
    ResourceRef(ResourceRef.class, "resource-ref", "res-ref-name", "Resource", "resource-ref"){

        @Override
        public List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs refs) {
            return refs.getResourceRefs();
        }
    }
    ,
    ResourceEnvRef(ResourceEnvRef.class, "resource-env-ref", "resource-env-ref-name", "Resource", "resource-env-ref"){

        @Override
        public List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs refs) {
            return refs.getResourceEnvRefs();
        }
    }
    ,
    MessageDestinationRef(MessageDestinationRef.class, "message-destination-ref", "message-destination-ref-name", "Resource", "message-destination-ref"){

        @Override
        public List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs refs) {
            return refs.getMessageDestinationRefs();
        }
    }
    ,
    PersistenceContextRef(PersistenceContextRef.class, "persistence-context-ref", "persistence-context-ref-name", "PersistenceContextRef", null){

        @Override
        public List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs refs) {
            return refs.getPersistenceContextRefs();
        }
    }
    ,
    PersistenceUnitRef(PersistenceUnitRef.class, "persistence-unit-ref", "persistence-unit-ref-name", "PersistenceUnitRef", null){

        @Override
        public List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs refs) {
            return refs.getPersistenceUnitRefs();
        }
    }
    ,
    DataSource(DataSource.class, "data-source", "name", "DataSourceDefinition", "data-source"){

        @Override
        public List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs refs) {
            return refs.getDataSources();
        }
    }
    ,
    JMSConnectionFactory(JMSConnectionFactory.class, "jms-connection-factory", "name", "JMSConnectionFactoryDefinition", null){

        @Override
        public List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs refs) {
            return refs.getJMSConnectionFactories();
        }
    }
    ,
    JMSDestination(JMSDestination.class, "jms-destination", "name", "JMSDestinationDefinition", null){

        @Override
        public List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs refs) {
            return refs.getJMSDestinations();
        }
    }
    ,
    MailSession(MailSession.class, "mail-session", "name", "MailSessionDefinition", null){

        @Override
        public List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs refs) {
            return refs.getMailSessions();
        }
    }
    ,
    ConnectionFactory(ConnectionFactory.class, "connection-factory", "name", "ConnectionFactoryDefinition", null){

        @Override
        public List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs refs) {
            return refs.getConnectionFactories();
        }
    }
    ,
    AdministeredObject(AdministeredObject.class, "administered-object", "name", "AdministeredObjectDefinition", null){

        @Override
        public List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs refs) {
            return refs.getAdministeredObjects();
        }
    };

    public static final List<JNDIEnvironmentRefType> VALUES;
    private final Class<? extends JNDIEnvironmentRef> ivType;
    private final String ivXMLElementName;
    private final String ivNameXMLElementName;
    private final String ivAnnotationShortName;
    private final String ivBindingElementName;

    public static void addAllRefs(Map<JNDIEnvironmentRefType, List<? extends JNDIEnvironmentRef>> allRefs, JNDIEnvironmentRefs refs) {
        for (JNDIEnvironmentRefType refType : VALUES) {
            refType.addAllRefs(allRefs, refType.getRefs(refs));
        }
    }

    public static void addAllRefs(Map<JNDIEnvironmentRefType, List<? extends JNDIEnvironmentRef>> allRefs, ComponentNameSpaceConfiguration compNSConfig) {
        for (JNDIEnvironmentRefType refType : VALUES) {
            refType.addAllRefs(allRefs, compNSConfig.getJNDIEnvironmentRefs(refType.getType()));
        }
    }

    public static void setAllRefs(ComponentNameSpaceConfiguration compNSConfig, Map<JNDIEnvironmentRefType, List<? extends JNDIEnvironmentRef>> allRefs) {
        for (JNDIEnvironmentRefType refType : VALUES) {
            List<? extends JNDIEnvironmentRef> refs = allRefs.get((Object)refType);
            compNSConfig.setJNDIEnvironmentRefs(refType.getType(), refs);
        }
    }

    private JNDIEnvironmentRefType(Class<? extends JNDIEnvironmentRef> type, String xmlElementName, String nameXMLElementName, String annotationShortName, String bindingElementName) {
        this.ivType = type;
        this.ivXMLElementName = xmlElementName;
        this.ivNameXMLElementName = nameXMLElementName;
        this.ivAnnotationShortName = annotationShortName;
        this.ivBindingElementName = bindingElementName;
    }

    public Class<? extends JNDIEnvironmentRef> getType() {
        return this.ivType;
    }

    public String getXMLElementName() {
        return this.ivXMLElementName;
    }

    public String getNameXMLElementName() {
        return this.ivNameXMLElementName;
    }

    public String getAnnotationShortName() {
        return this.ivAnnotationShortName;
    }

    public String getNameAnnotationElementName() {
        return "name";
    }

    public String getBindingElementName() {
        return this.ivBindingElementName;
    }

    public String getBindingAttributeName() {
        return this.ivBindingElementName == null ? null : "binding-name";
    }

    public abstract List<? extends JNDIEnvironmentRef> getRefs(JNDIEnvironmentRefs var1);

    public void addRef(Map<JNDIEnvironmentRefType, List<? extends JNDIEnvironmentRef>> allRefs, JNDIEnvironmentRef ref) {
        this.getType().cast(ref);
        List<? extends JNDIEnvironmentRef> oldRefs = allRefs.get((Object)this);
        if (oldRefs == null) {
            ArrayList<JNDIEnvironmentRef> newRefs = new ArrayList<JNDIEnvironmentRef>();
            newRefs.add(ref);
            allRefs.put(this, newRefs);
        } else {
            oldRefs.add((JNDIEnvironmentRef)ref);
        }
    }

    public void addAllRefs(Map<JNDIEnvironmentRefType, List<? extends JNDIEnvironmentRef>> allRefs, List<? extends JNDIEnvironmentRef> refs) {
        if (refs != null && !refs.isEmpty()) {
            for (JNDIEnvironmentRef jNDIEnvironmentRef : refs) {
                this.getType().cast(jNDIEnvironmentRef);
            }
            List<? extends JNDIEnvironmentRef> oldRefs = allRefs.get((Object)this);
            if (oldRefs == null) {
                allRefs.put(this, new ArrayList<JNDIEnvironmentRef>(refs));
            } else {
                oldRefs.addAll(refs);
            }
        }
    }

    static {
        VALUES = Arrays.asList(JNDIEnvironmentRefType.values());
    }
}

