/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.injectionengine;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import com.ibm.wsspi.injectionengine.InjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.RecursiveInjectionException;
import java.util.HashMap;

public class InjectionUtil {
    private static final TraceComponent tc = Tr.register(InjectionUtil.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");

    public static Object createInjectedInstance(Class<?> targetClass, HashMap<Class<?>, InjectionTarget[]> injectionTargetMap) throws InjectionException, IllegalAccessException, InstantiationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createInjectedInstance : " + targetClass + ", " + (injectionTargetMap == null ? "null" : Util.identity((Object[])injectionTargetMap.get(targetClass)))), (Object[])new Object[0]);
        }
        InjectionTarget[] targets = null;
        Object instance = targetClass.newInstance();
        if (injectionTargetMap != null && (targets = injectionTargetMap.get(targetClass)) != null) {
            InjectionEngine injectionEngine = InjectionEngineAccessor.getInstance();
            for (InjectionTarget injectionTarget : targets) {
                injectionEngine.inject(instance, injectionTarget, null);
            }
        }
        return instance;
    }

    public static Object createInjectedInstance(Class<?> targetClass, InjectionTarget[] injectionTargets) throws InjectionException, IllegalAccessException, InstantiationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createInjectedInstance : " + targetClass + ", " + Util.identity((Object[])injectionTargets)), (Object[])new Object[0]);
        }
        Object instance = targetClass.newInstance();
        if (injectionTargets != null) {
            InjectionEngine injectionEngine = InjectionEngineAccessor.getInstance();
            for (InjectionTarget injectionTarget : injectionTargets) {
                injectionEngine.inject(instance, injectionTarget, null);
            }
        }
        return instance;
    }

    public static InjectionException checkForRecursiveException(Throwable t, String message) {
        InjectionException iex;
        RecursiveInjectionException.RecursionDetection rd = RecursiveInjectionException.detectRecursiveInjection(t);
        switch (rd) {
            case Recursive: {
                iex = new RecursiveInjectionException(message);
                iex.ivLogged = false;
                break;
            }
            case RecursiveAlreadyLogged: {
                iex = new RecursiveInjectionException(message);
                iex.ivLogged = true;
                break;
            }
            default: {
                iex = new InjectionException(message, t);
            }
        }
        return iex;
    }
}

