/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.utils.AuditUtils;
import com.ibm.ws.security.audit.utils.ParameterUtils;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JMXMBeanAttributeEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(JMXMBeanAttributeEvent.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = 5174033699524497424L;

    public JMXMBeanAttributeEvent() {
        this.set("eventName", "JMX_MBEAN_ATTRIBUTES");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    /*
     * WARNING - void declaration
     */
    public JMXMBeanAttributeEvent(ObjectName name, Object attrs, String action, String outcome, String reason) {
        block10: {
            this();
            try {
                if (name != null) {
                    this.set("target.jmx.mbean.name", name.toString());
                }
                if (action != null) {
                    if (action.equals("setAttribute") || action.equals("getAttribute")) {
                        this.set("target.jmx.mbean.attribute.name", attrs.toString());
                    } else if (action.equals("setAttributes") || action.equals("getAttributes")) {
                        StringBuffer buf = new StringBuffer();
                        for (Object attr : (AttributeList)attrs) {
                            buf.append("[").append(((Attribute)attr).getName()).append(" = ").append(ParameterUtils.format(((Attribute)attr).getValue())).append("]");
                        }
                        this.set("target.jmx.mbean.attribute.names", buf.toString());
                    }
                    this.set("target.jmx.mbean.action", action);
                }
                this.set("observer.name", "JMXService");
                this.set("target.typeURI", "server/mbean");
                this.set("target.realm", AuditUtils.getRealmName());
                if (outcome.equals("success")) {
                    this.setOutcome("success");
                    this.set("reason.reasonCode", 200);
                    this.set("reason.reasonType", reason);
                } else {
                    this.setOutcome("failure");
                    this.set("reason.reasonCode", 201);
                    this.set("reason.reasonType", reason);
                }
            }
            catch (Exception buf) {
                void e;
                FFDCFilter.processException((Throwable)buf, (String)"com.ibm.ws.security.audit.event.JMXMBeanAttributeEvent", (String)"79", (Object)((Object)this), (Object[])new Object[]{name, attrs, action, outcome, reason});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating JMXMBeanAttributeEvent", (Object[])new Object[]{e});
            }
        }
    }
}

