/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client.configuration;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyJaxRsClientConfigInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(LibertyJaxRsClientConfigInterceptor.class, (String)"com.ibm.ws.jaxrs20.client", (String)"com.ibm.ws.jaxrs20.client.internal.resources.JAXRSClientMessages");
    static final long serialVersionUID = 7937836626500280001L;

    public LibertyJaxRsClientConfigInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        Conduit conduit = message.getExchange().getConduit(message);
        if (conduit instanceof HTTPConduit) {
            HTTPConduit httpConduit = (HTTPConduit)conduit;
            Hashtable<String, String> cxfClientProps = new Hashtable<String, String>();
            for (Map.Entry entry : message.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("client.")) continue;
                Object valueObj = entry.getValue();
                String value = entry == null ? null : valueObj.toString();
                ((Dictionary)cxfClientProps).put(key, value);
            }
            LibertyJaxRsClientConfigInterceptor.applyClientPolicies(cxfClientProps, httpConduit);
            Object keepAlive = message.get((Object)"com.ibm.ws.jaxrs.client.keepalive.connection");
            HTTPClientPolicy clientPolicy = httpConduit.getClient();
            if (keepAlive != null) {
                String keepAliveString = keepAlive.toString();
                switch (keepAliveString.toLowerCase()) {
                    case "keep-alive": 
                    case "keepalive": {
                        clientPolicy.setConnection(ConnectionType.KEEP_ALIVE);
                        break;
                    }
                    case "close": {
                        clientPolicy.setConnection(ConnectionType.CLOSE);
                        break;
                    }
                    default: {
                        Tr.warning((TraceComponent)tc, (String)"warn_unknown_keepalive_setting", (Object[])new Object[]{keepAliveString, "keep-alive, close"});
                        clientPolicy.setConnection(ConnectionType.KEEP_ALIVE);
                        break;
                    }
                }
            } else if (!message.containsKey((Object)"client.Connection")) {
                clientPolicy.setConnection(ConnectionType.KEEP_ALIVE);
            }
            Object connection_timeout = message.get((Object)"com.ibm.ws.jaxrs.client.connection.timeout");
            Object receive_timeout = message.get((Object)"com.ibm.ws.jaxrs.client.receive.timeout");
            this.configClientTimeout(httpConduit, connection_timeout, receive_timeout);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void configClientTimeout(HTTPConduit httpConduit, Object connection_timeout, Object receive_timeout) {
        try {
            if (connection_timeout != null) {
                String sconnection_timeout = connection_timeout.toString();
                httpConduit.getClient().setConnectionTimeout(Long.parseLong(sconnection_timeout));
            }
        }
        catch (NumberFormatException sconnection_timeout) {
            void e;
            FFDCFilter.processException((Throwable)sconnection_timeout, (String)"com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientConfigInterceptor", (String)"102", (Object)((Object)this), (Object[])new Object[]{httpConduit, connection_timeout, receive_timeout});
            httpConduit.getClient().setConnectionTimeout(30000L);
            Tr.error((TraceComponent)tc, (String)"error.jaxrs.client.configuration.timeout.valueinvalid", (Object[])new Object[]{connection_timeout, "com.ibm.ws.jaxrs.client.connection.timeout", 30000L, e.getMessage()});
        }
        try {
            if (receive_timeout != null) {
                String sreceive_timeout = receive_timeout.toString();
                httpConduit.getClient().setReceiveTimeout(Long.parseLong(sreceive_timeout));
            }
        }
        catch (NumberFormatException sreceive_timeout) {
            void e;
            FFDCFilter.processException((Throwable)sreceive_timeout, (String)"com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientConfigInterceptor", (String)"115", (Object)((Object)this), (Object[])new Object[]{httpConduit, connection_timeout, receive_timeout});
            httpConduit.getClient().setReceiveTimeout(30000L);
            Tr.error((TraceComponent)tc, (String)"error.jaxrs.client.configuration.timeout.valueinvalid", (Object[])new Object[]{receive_timeout, "com.ibm.ws.jaxrs.client.receive.timeout", 30000L, e.getMessage()});
        }
    }

    private static void applyClientPolicies(Dictionary<String, String> d, HTTPConduit c) {
        Enumeration<String> keys = d.keys();
        HTTPClientPolicy p = c.getClient();
        while (keys.hasMoreElements()) {
            String k = keys.nextElement();
            if (!k.startsWith("client.")) continue;
            if (p == null) {
                p = new HTTPClientPolicy();
                c.setClient(p);
            }
            String v = d.get(k);
            if ("ConnectionTimeout".equals(k = k.substring("client.".length()))) {
                p.setConnectionTimeout(Long.parseLong(v.trim()));
                continue;
            }
            if ("ReceiveTimeout".equals(k)) {
                p.setReceiveTimeout(Long.parseLong(v.trim()));
                continue;
            }
            if ("AsyncExecuteTimeout".equals(k)) {
                p.setAsyncExecuteTimeout(Long.parseLong(v.trim()));
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"The Liberty threadpool maximum length is infinite.  The AsyncExecuteTimeout property will be ignored.", (Object[])new Object[0]);
                continue;
            }
            if ("AsyncExecuteTimeoutRejection".equals(k)) {
                p.setAsyncExecuteTimeoutRejection(Boolean.parseBoolean(v.trim()));
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"The Liberty threadpool maximum length is infinite.  The AsyncExecuteTimeoutRejection property will be ignored.", (Object[])new Object[0]);
                continue;
            }
            if ("AutoRedirect".equals(k)) {
                p.setAutoRedirect(Boolean.parseBoolean(v.trim()));
                continue;
            }
            if ("MaxRetransmits".equals(k)) {
                p.setMaxRetransmits(Integer.parseInt(v.trim()));
                continue;
            }
            if ("AllowChunking".equals(k)) {
                p.setAllowChunking(Boolean.parseBoolean(v.trim()));
                continue;
            }
            if ("ChunkingThreshold".equals(k)) {
                p.setChunkingThreshold(Integer.parseInt(v.trim()));
                continue;
            }
            if ("ChunkLength".equals(k)) {
                p.setChunkLength(Integer.parseInt(v.trim()));
                continue;
            }
            if ("Connection".equals(k)) {
                p.setConnection(ConnectionType.valueOf((String)v));
                continue;
            }
            if ("DecoupledEndpoint".equals(k)) {
                p.setDecoupledEndpoint(v);
                continue;
            }
            if ("ProxyServer".equals(k)) {
                p.setProxyServer(v);
                continue;
            }
            if ("ProxyServerPort".equals(k)) {
                p.setProxyServerPort(Integer.parseInt(v.trim()));
                continue;
            }
            if ("ProxyServerType".equals(k)) {
                p.setProxyServerType(ProxyServerType.fromValue((String)v));
                continue;
            }
            if (!"NonProxyHosts".equals(k)) continue;
            p.setNonProxyHosts(v);
        }
    }
}

