/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.viewer;

import com.ibm.ejs.ras.hpel.Messages;
import com.ibm.websphere.logging.hpel.reader.HpelFormatter;
import com.ibm.websphere.logging.hpel.reader.LogRecordFilter;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.reader.RepositoryPointer;
import com.ibm.websphere.logging.hpel.reader.RepositoryReaderImpl;
import com.ibm.websphere.logging.hpel.reader.ServerInstanceLogRecordList;
import com.ibm.websphere.logging.hpel.reader.filters.LogViewerFilter;
import com.ibm.websphere.logging.hpel.writer.HPELRepositoryExporter;
import com.ibm.ws.logging.object.hpel.RepositoryLogRecordImpl;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Level;

public class LogViewer {
    static final DateFormat dateFormat = new SimpleDateFormat(LogViewer.getLocalizedString("CWTRA0003I"));
    static final DateFormat instanceDF = new SimpleDateFormat(LogViewer.getLocalizedString("CWTRA0073I"));
    static final int MAX_ZCOLUMN_SIZE = 72;
    static final int MAX_DCOLUMN_SIZE = 30;
    static final String zOSHeader = LogViewer.getLocalizedString("CWTRA0071I");
    static final String zOSSpaces = "                                    ";
    static final String distHeader = LogViewer.getLocalizedString("CWTRA0072I");
    static final String distSpaces = "                ";
    private String spaces;
    private static final String BUNDLE_NAME = "com.ibm.ws.logging.hpel.resources.LogViewerMessages";
    private static final String OPTION_DELIMITER = "-";
    private static final boolean useHeaderTimeZone = true;
    private String binaryRepositoryDir = null;
    private String outputLogFilename = null;
    private Date startDate = null;
    private Date stopDate = null;
    private boolean listInstances = false;
    private Date mainInstanceId = null;
    private String subInstanceId = null;
    private String levelString = null;
    private boolean latestInstance = false;
    private Level minLevel = null;
    private Level maxLevel = null;
    private String includeLoggers = null;
    private String excludeLoggers = null;
    private String hexThreadID = null;
    private HpelFormatter theFormatter = HpelFormatter.getFormatter("Basic");
    private boolean hasFooter = false;
    private static final int DEFAULT_TAIL_INTERVAL = 5;
    private int tailInterval = -1;
    private Locale locale = null;
    private HPELRepositoryExporter outputRepository = null;
    private String message;
    private String excludeMessages = null;
    private final ArrayList<LogViewerFilter.Extension> extensions = new ArrayList();
    private String encoding = null;
    private boolean isSystemOut = false;
    private static final Comparator<Level> LEVEL_COMPARATOR = new Comparator<Level>(){

        @Override
        public int compare(Level object1, Level object2) {
            int level2;
            int level1 = object1.intValue();
            if (level1 < (level2 = object2.intValue())) {
                return -1;
            }
            if (level1 > level2) {
                return 1;
            }
            return 0;
        }
    };
    private static final Level[] DEFAULT_LEVEL_LIST = new Level[]{Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE};
    private final Option[] options = new Option[]{new OneArgOption("-repositoryDir"){

        @Override
        void setValue(String arg) {
            LogViewer.this.setBinaryRepositoryDir(arg);
        }
    }, new NoArgOption("-listInstances"){

        @Override
        void enableOption() {
            LogViewer.this.listInstances = true;
        }
    }, new NoArgOption("-latestInstance"){

        @Override
        void enableOption() {
            LogViewer.this.latestInstance = true;
        }
    }, new OneArgOption("-instance"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            LogViewer.this.setInstanceId(arg);
        }
    }, new OneArgOption("-startDate"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            LogViewer.this.setStartDate(arg);
        }
    }, new OneArgOption("-stopDate"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            LogViewer.this.setStopDate(arg);
        }
    }, new OneArgOption("-outLog"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            LogViewer.this.setOutputLogFilename(arg);
        }
    }, new OneArgOption("-format"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            LogViewer.this.setOutFormat(arg);
        }
    }, new OneArgOption("-level"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            LogViewer.this.setMinLevel(arg);
            LogViewer.this.setMaxLevel(arg);
        }
    }, new OneArgOption("-minLevel"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            LogViewer.this.setMinLevel(arg);
        }
    }, new OneArgOption("-maxLevel"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            LogViewer.this.setMaxLevel(arg);
        }
    }, new OneArgOption("-locale"){

        @Override
        void setValue(String arg) {
            LogViewer.this.setLocale(arg);
        }
    }, new OneArgOption("-includeLoggers"){

        @Override
        void setValue(String arg) {
            LogViewer.this.includeLoggers = arg;
        }
    }, new OneArgOption("-excludeLoggers"){

        @Override
        void setValue(String arg) {
            LogViewer.this.excludeLoggers = arg;
        }
    }, new OneArgOption("-thread"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            LogViewer.this.setHexThreadID(arg);
        }
    }, new OneArgOption("-extractToNewRepository"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            LogViewer.this.setOutputRepositoryDir(arg);
        }
    }, new OneArgOption("-message"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            LogViewer.this.setMessage(arg);
        }
    }, new OneArgOption("-excludeMessages"){

        @Override
        void setValue(String arg) {
            LogViewer.this.excludeMessages = arg;
        }
    }, new OneArgOption("-includeExtensions"){

        @Override
        public void setValue(String arg) throws IllegalArgumentException {
            LogViewer.this.setExtensions(arg);
        }
    }, new OneArgOption("-encoding"){

        @Override
        public void setValue(String arg) throws IllegalArgumentException {
            if (!Charset.isSupported(arg)) {
                throw new IllegalArgumentException(LogViewer.getLocalizedParmString("UnsupportedEncodingError", new Object[]{arg}));
            }
            LogViewer.this.encoding = arg;
        }
    }, new TailOption("-monitor")};

    public static void main(String[] args) {
        LogViewer logViewer = new LogViewer();
        int code = logViewer.execute(args);
        if (code > 0) {
            System.err.println(LogViewer.getLocalizedString("CWTRA0029I"));
        }
        System.exit(code);
    }

    Map<String, LevelDetails> readLevels(String customLevelsPropertyFile) {
        if (customLevelsPropertyFile != null) {
            HashMap<String, LevelDetails> result = new HashMap<String, LevelDetails>();
            try {
                Properties levelProps = new Properties();
                levelProps.load(new FileInputStream(new File(customLevelsPropertyFile)));
                for (String level : levelProps.stringPropertyNames()) {
                    try {
                        String resourceBundleName;
                        int intValue = Integer.parseInt(level);
                        String valueString = levelProps.getProperty(level);
                        String[] values = valueString.trim().split("\\s+");
                        if (values.length == 0) {
                            System.err.println(LogViewer.getLocalizedParmString("NoLevelNameInCustomLevelsFile", new Object[]{customLevelsPropertyFile, level}));
                            break;
                        }
                        if (values.length > 3) {
                            System.err.println(LogViewer.getLocalizedParmString("TooManyValuesInCustomLevelsFile", new Object[]{customLevelsPropertyFile, level, valueString, 3}));
                            break;
                        }
                        String name = values[0];
                        String id = values.length > 1 ? values[1] : null;
                        String string = resourceBundleName = values.length > 2 ? values[2] : null;
                        if (id != null && id.length() > 1) {
                            if (resourceBundleName == null || resourceBundleName.length() == 1) {
                                String tmp = resourceBundleName;
                                resourceBundleName = id;
                                id = tmp;
                            } else {
                                System.err.println(LogViewer.getLocalizedParmString("LevelIdTooBigInCustomLevelsFile", new Object[]{customLevelsPropertyFile, level, id, resourceBundleName}));
                                break;
                            }
                        }
                        result.put(name, new LevelDetails(intValue, id, resourceBundleName));
                    }
                    catch (NumberFormatException ex) {
                        System.err.println(LogViewer.getLocalizedParmString("NotIntegerKeyInCustomLevelsFile", new Object[]{customLevelsPropertyFile, level}));
                        break;
                    }
                }
                return result;
            }
            catch (FileNotFoundException e) {
                System.err.println(LogViewer.getLocalizedParmString("SpecifiedCustomLevelsFileNotFound", new Object[]{customLevelsPropertyFile}));
            }
            catch (IOException e) {
                System.err.println(LogViewer.getLocalizedParmString("ErrorReadingCustomLevelsFile", new Object[]{customLevelsPropertyFile, e.getMessage()}));
            }
        }
        return null;
    }

    String getLevelsString(Map<String, LevelDetails> levels) {
        TreeSet<Level> list = new TreeSet<Level>(LEVEL_COMPARATOR);
        if (levels != null) {
            for (Map.Entry entry : levels.entrySet()) {
                list.add(HpelFormatter.addCustomLevel((String)entry.getKey(), ((LevelDetails)entry.getValue()).intValue, ((LevelDetails)entry.getValue()).id, ((LevelDetails)entry.getValue()).resourceBundleName));
            }
        }
        for (Level level : DEFAULT_LEVEL_LIST) {
            list.add(level);
        }
        StringBuilder result = null;
        for (Level level : list) {
            if (result == null) {
                result = new StringBuilder(level.getName());
                continue;
            }
            result.append(" | ").append(level.getName());
        }
        return result.toString();
    }

    String[] readHeader(String headerFileName) {
        if (headerFileName != null) {
            try {
                String line;
                BufferedReader input = new BufferedReader(new FileReader(headerFileName));
                ArrayList<String> header = new ArrayList<String>();
                while ((line = input.readLine()) != null) {
                    header.add(line);
                }
                return header.toArray(new String[header.size()]);
            }
            catch (FileNotFoundException e) {
                System.err.println(LogViewer.getLocalizedParmString("SpecifiedCustomHeaderFileNotFound", new Object[]{headerFileName}));
            }
            catch (IOException e) {
                System.err.println(LogViewer.getLocalizedParmString("ErrorReadingCustomHeaderFile", new Object[]{headerFileName, e.getMessage()}));
            }
        }
        return null;
    }

    public int execute(String[] args) {
        Map<String, LevelDetails> levels = this.readLevels(System.getProperty("logviewer.custom.levels"));
        String[] header = this.readHeader(System.getProperty("logviewer.custom.header"));
        return this.execute(args, levels, header);
    }

    public int execute(String[] args, Map<String, LevelDetails> levels, String[] header) {
        this.levelString = this.getLevelsString(levels);
        try {
            ServerInstanceLogRecordList silrl;
            if (this.parseCmdLineArgs(args) || this.validateSettings()) {
                return 0;
            }
            if (header != null) {
                this.theFormatter.setCustomHeader(header);
            }
            RepositoryReaderImpl logRepository = new RepositoryReaderImpl(this.binaryRepositoryDir);
            if (!(this.mainInstanceId == null || (silrl = logRepository.getLogListForServerInstance(this.mainInstanceId)) != null && silrl.getStartTime() != null && silrl.getStartTime().equals(this.mainInstanceId) && (this.subInstanceId == null || this.subInstanceId.isEmpty() || silrl.getChildren().containsKey(this.subInstanceId)))) {
                throw new IllegalArgumentException(LogViewer.getLocalizedString("LVM_ERROR_INSTANCEID"));
            }
            PrintStream outps = this.createOutputStream();
            LogViewerFilter searchCriteria = new LogViewerFilter(this.startDate, this.stopDate, this.minLevel, this.maxLevel, this.includeLoggers, this.excludeLoggers, this.hexThreadID, this.message, this.excludeMessages, this.extensions);
            if (this.listInstances) {
                Iterable<ServerInstanceLogRecordList> results = logRepository.getLogLists();
                this.displayInstances(outps, results);
            } else {
                Properties initialProps = logRepository.getLogListForCurrentServerInstance().getHeader();
                if (initialProps != null) {
                    boolean isZOS = "Y".equalsIgnoreCase(initialProps.getProperty("isZOS"));
                    if (isZOS && !this.latestInstance && this.mainInstanceId == null) {
                        Iterable<ServerInstanceLogRecordList> results = logRepository.getLogLists();
                        this.displayInstances(outps, results);
                    } else {
                        this.displayRecords(outps, searchCriteria, logRepository, this.mainInstanceId, this.subInstanceId);
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        return 0;
    }

    private void displayRecords(PrintStream outps, LogViewerFilter searchCriteria, RepositoryReaderImpl logRepository, Date requestedProcess, String requestedSubProcess) {
        boolean headerPrinted;
        long opStart;
        int recordcount;
        block96: {
            recordcount = 0;
            opStart = System.currentTimeMillis();
            headerPrinted = false;
            Iterable<ServerInstanceLogRecordList> repResults = null;
            boolean needHeader = false;
            if (this.tailInterval > 0) {
                boolean firstIteration = true;
                String tailPid = null;
                Object logRepositoryPointer = null;
                RepositoryPointer traceRepositoryPointer = null;
                if (this.latestInstance) {
                    ServerInstanceLogRecordList silrl = logRepository.getLogListForCurrentServerInstance();
                    requestedSubProcess = this.getLatestKid(silrl);
                    requestedProcess = silrl.getStartTime();
                }
                while (true) {
                    Iterator<ServerInstanceLogRecordList> traceResults;
                    Iterator<ServerInstanceLogRecordList> logResults;
                    logRepository = new RepositoryReaderImpl(this.binaryRepositoryDir);
                    RepositoryReaderImpl logReader = null;
                    if (logRepository.getLogLocation() != null) {
                        logReader = new RepositoryReaderImpl(logRepository.getLogLocation());
                    }
                    RepositoryReaderImpl traceReader = null;
                    if (logRepository.getTraceLocation() != null) {
                        traceReader = new RepositoryReaderImpl(logRepository.getTraceLocation());
                    }
                    if (logReader == null && traceReader == null) {
                        return;
                    }
                    if (requestedProcess != null && (logRepositoryPointer == null || traceRepositoryPointer == null) && logReader != null && traceReader != null) {
                        Iterator<ServerInstanceLogRecordList> it;
                        ServerInstanceLogRecordList logSilrl = logReader.getLogListForServerInstance(requestedProcess);
                        ServerInstanceLogRecordList traceSilrl = traceReader.getLogListForServerInstance(requestedProcess);
                        if (!(logRepositoryPointer != null || logSilrl.getStartTime() != null && logSilrl.getStartTime().equals(requestedProcess))) {
                            if (logSilrl.getStartTime() == null) {
                                logSilrl = logReader.getLogLists(requestedProcess, null).iterator().next();
                            } else if (logSilrl.getStartTime().before(requestedProcess)) {
                                it = logReader.getLogLists(requestedProcess, null).iterator();
                                it.next();
                                logSilrl = it.next();
                            } else {
                                throw new RuntimeException("Internal Error! Log start time is after requested date");
                            }
                            if (logSilrl != null) {
                                String logPid = logSilrl.getHeader().getProperty("ProcessId");
                                String tracePid = traceSilrl.getHeader().getProperty("ProcessId");
                                if (tracePid.equals(logPid)) {
                                    requestedProcess = logSilrl.getStartTime();
                                } else {
                                    logReader = null;
                                }
                            }
                        } else if (!(traceRepositoryPointer != null || traceSilrl.getStartTime() != null && traceSilrl.getStartTime().equals(requestedProcess))) {
                            if (traceSilrl.getStartTime() == null) {
                                traceSilrl = traceReader.getLogLists(requestedProcess, null).iterator().next();
                            } else if (traceSilrl.getStartTime().before(requestedProcess)) {
                                it = traceReader.getLogLists(requestedProcess, null).iterator();
                                it.next();
                                traceSilrl = it.next();
                            } else {
                                throw new RuntimeException("Internal Error! Trace start time is after requested date");
                            }
                            if (traceSilrl != null) {
                                String tracePid = traceSilrl.getHeader().getProperty("ProcessId");
                                String logPid = logSilrl.getHeader().getProperty("ProcessId");
                                if (logPid.equals(tracePid)) {
                                    requestedProcess = traceSilrl.getStartTime();
                                } else {
                                    traceReader = null;
                                }
                            }
                        }
                    }
                    if (this.startDate == null && firstIteration) {
                        if (requestedProcess != null) {
                            RepositoryLogRecord lastRecord;
                            ServerInstanceLogRecordList silrl;
                            if (logReader != null) {
                                silrl = logReader.getLogListForServerInstance(requestedProcess, (LogRecordFilter)searchCriteria);
                                if (requestedSubProcess != null && !requestedSubProcess.isEmpty()) {
                                    silrl = silrl.getChildren().get(requestedSubProcess);
                                }
                                if (silrl != null && (lastRecord = silrl.range(-1, 1).iterator().next()) != null) {
                                    logRepositoryPointer = lastRecord.getRepositoryPointer();
                                }
                            }
                            if (traceReader != null) {
                                silrl = traceReader.getLogListForServerInstance(requestedProcess, (LogRecordFilter)searchCriteria);
                                if (requestedSubProcess != null && !requestedSubProcess.isEmpty()) {
                                    silrl = silrl.getChildren().get(requestedSubProcess);
                                }
                                if (silrl != null && (lastRecord = silrl.range(-1, 1).iterator().next()) != null) {
                                    traceRepositoryPointer = lastRecord.getRepositoryPointer();
                                }
                            }
                        } else {
                            this.startDate = new Date();
                        }
                    }
                    firstIteration = false;
                    ServerInstanceLogRecordList nextLogList = null;
                    ServerInstanceLogRecordList nextTraceList = null;
                    if (logReader != null) {
                        if (requestedProcess != null) {
                            if (logRepositoryPointer == null) {
                                nextLogList = logReader.getLogListForServerInstance(requestedProcess, (LogRecordFilter)searchCriteria);
                                if (requestedSubProcess != null && !requestedSubProcess.isEmpty()) {
                                    nextLogList = nextLogList.getChildren().get(requestedSubProcess);
                                }
                            } else {
                                nextLogList = logReader.getLogListForServerInstance((RepositoryPointer)logRepositoryPointer, (LogRecordFilter)searchCriteria);
                            }
                            logResults = null;
                        } else {
                            logResults = logRepositoryPointer == null ? logReader.getLogLists(this.startDate, this.stopDate, (LogRecordFilter)searchCriteria).iterator() : logReader.getLogLists((RepositoryPointer)logRepositoryPointer, this.stopDate, (LogRecordFilter)searchCriteria).iterator();
                            nextLogList = logResults.next();
                        }
                    } else {
                        logResults = null;
                    }
                    if (traceReader != null) {
                        if (requestedProcess != null) {
                            if (traceRepositoryPointer == null) {
                                nextTraceList = traceReader.getLogListForServerInstance(requestedProcess, (LogRecordFilter)searchCriteria);
                                if (requestedSubProcess != null && !requestedSubProcess.isEmpty()) {
                                    nextTraceList = nextTraceList.getChildren().get(requestedSubProcess);
                                }
                            } else {
                                nextTraceList = traceReader.getLogListForServerInstance(traceRepositoryPointer, (LogRecordFilter)searchCriteria);
                            }
                            traceResults = null;
                        } else {
                            traceResults = traceRepositoryPointer == null ? traceReader.getLogLists(this.startDate, this.stopDate, (LogRecordFilter)searchCriteria).iterator() : traceReader.getLogLists(traceRepositoryPointer, this.stopDate, (LogRecordFilter)searchCriteria).iterator();
                            nextTraceList = traceResults.next();
                        }
                    } else {
                        traceResults = null;
                    }
                    while (nextLogList != null || nextTraceList != null) {
                        Iterable<RepositoryLogRecord> resultsList;
                        Properties pidHeaderProps;
                        RepositoryLogRecord log = null;
                        if (nextLogList != null) {
                            while ((log = (RepositoryLogRecord)nextLogList.iterator().next()) == null && (nextLogList = logResults == null ? null : logResults.next()) != null) {
                            }
                        }
                        RepositoryLogRecord trace = null;
                        if (nextTraceList != null) {
                            while ((trace = (RepositoryLogRecord)nextTraceList.iterator().next()) == null && (nextTraceList = traceResults == null ? null : traceResults.next()) != null) {
                            }
                        }
                        if (log == null && trace == null) break;
                        boolean useLog = false;
                        boolean useTrace = false;
                        if (nextTraceList == null) {
                            useLog = true;
                        } else if (nextLogList == null) {
                            useTrace = true;
                        } else {
                            String logPid = nextLogList.getHeader().getProperty("ProcessId");
                            String tracePid = nextTraceList.getHeader().getProperty("ProcessId");
                            if (logPid == null && tracePid == null || logPid != null && logPid.equals(tracePid)) {
                                useLog = true;
                                useTrace = true;
                            } else if (log.getMillis() < trace.getMillis()) {
                                useLog = true;
                            } else {
                                useTrace = true;
                            }
                        }
                        if (!useTrace) {
                            pidHeaderProps = nextLogList.getHeader();
                            resultsList = nextLogList;
                            nextLogList = logResults == null ? null : logResults.next();
                        } else if (!useLog) {
                            pidHeaderProps = nextTraceList.getHeader();
                            resultsList = nextTraceList;
                            nextTraceList = traceResults == null ? null : traceResults.next();
                        } else {
                            pidHeaderProps = nextLogList.getHeader();
                            resultsList = new LocalMergedRepository(nextLogList, nextTraceList);
                            nextLogList = logResults == null ? null : logResults.next();
                            nextTraceList = traceResults == null ? null : traceResults.next();
                        }
                        String pid = pidHeaderProps.getProperty("ProcessId");
                        if (pid != null && !pid.equals(tailPid)) {
                            needHeader = true;
                        }
                        tailPid = pid;
                        for (RepositoryLogRecord record : resultsList) {
                            if (needHeader) {
                                this.theFormatter.setStartDatetime(record.getMillis());
                                this.printHeader(pidHeaderProps, outps, headerPrinted);
                                headerPrinted = true;
                                needHeader = false;
                            }
                            if (!useTrace) {
                                logRepositoryPointer = record.getRepositoryPointer();
                            } else if (!useLog) {
                                traceRepositoryPointer = record.getRepositoryPointer();
                            } else if (((LocalMergedRepository)resultsList).isLastLog()) {
                                logRepositoryPointer = record.getRepositoryPointer();
                            } else {
                                traceRepositoryPointer = record.getRepositoryPointer();
                            }
                            if (this.outputRepository != null) {
                                this.outputRepository.storeRecord(record);
                            } else {
                                outps.println(this.theFormatter.formatRecord(record));
                            }
                            ++recordcount;
                        }
                    }
                    if (requestedProcess != null && requestedProcess.before(logRepository.getLogListForCurrentServerInstance().getStartTime())) break block96;
                    try {
                        Thread.sleep(this.tailInterval * 1000);
                    }
                    catch (InterruptedException e) {
                        break block96;
                    }
                }
            }
            if (this.latestInstance || requestedProcess != null) {
                ServerInstanceLogRecordList silrl = null;
                if (this.latestInstance) {
                    silrl = logRepository.getLogListForCurrentServerInstance();
                    requestedSubProcess = this.getLatestKid(silrl);
                    silrl = logRepository.getLogListForServerInstance((Date)null, (LogRecordFilter)searchCriteria);
                } else {
                    silrl = logRepository.getLogListForServerInstance(requestedProcess, (LogRecordFilter)searchCriteria);
                }
                if (requestedSubProcess != null && !requestedSubProcess.isEmpty()) {
                    silrl = silrl.getChildren().get(requestedSubProcess);
                }
                if (silrl != null) {
                    Properties pidHeaderProps = silrl.getHeader();
                    for (RepositoryLogRecord record : silrl) {
                        if (!headerPrinted) {
                            this.theFormatter.setStartDatetime(record.getMillis());
                            this.printHeader(pidHeaderProps, outps, false);
                            headerPrinted = true;
                        }
                        if (this.outputRepository != null) {
                            this.outputRepository.storeRecord(record);
                        } else {
                            outps.println(this.theFormatter.formatRecord(record));
                        }
                        ++recordcount;
                    }
                }
            } else {
                repResults = logRepository.getLogLists(this.startDate, this.stopDate, (LogRecordFilter)searchCriteria);
                for (ServerInstanceLogRecordList resultsList : repResults) {
                    Properties pidHeaderProps = resultsList.getHeader();
                    needHeader = true;
                    for (RepositoryLogRecord record : resultsList) {
                        if (needHeader) {
                            this.theFormatter.setStartDatetime(record.getMillis());
                            this.printHeader(pidHeaderProps, outps, headerPrinted);
                            headerPrinted = true;
                            needHeader = false;
                        }
                        if (this.outputRepository != null) {
                            this.outputRepository.storeRecord(record);
                        } else {
                            outps.println(this.theFormatter.formatRecord(record));
                        }
                        ++recordcount;
                    }
                }
            }
        }
        if (this.outputRepository != null) {
            this.outputRepository.close();
        } else if (this.hasFooter && headerPrinted) {
            outps.println(this.theFormatter.getFooter());
        }
        if (!this.isSystemOut) {
            outps.flush();
            outps.close();
        }
        System.out.println(LogViewer.getLocalizedString("CWTRA0010I"));
        long opEnd = System.currentTimeMillis();
        double opSec = (double)(opEnd - opStart) / 1000.0;
        double opAvg = (double)recordcount / opSec;
        NumberFormat numFormat = null;
        numFormat = this.locale == null ? NumberFormat.getInstance(Locale.getDefault()) : NumberFormat.getInstance(this.locale);
        System.out.println(LogViewer.getLocalizedParmString("CWTRA0018I", new Object[]{numFormat.format(recordcount), numFormat.format(opSec), numFormat.format(opAvg)}));
    }

    private long getProcessInstanceId(String instanceId) throws NumberFormatException {
        int endIndx = instanceId.indexOf("/");
        if (endIndx > -1) {
            return Long.parseLong(instanceId.substring(0, endIndx));
        }
        return Long.parseLong(instanceId);
    }

    private String getSubProcessInstanceId(String instanceId) {
        int beg = instanceId.indexOf("/");
        if (beg > -1 && beg + 1 < instanceId.length()) {
            return instanceId.substring(beg + 1);
        }
        return "";
    }

    private void displayInstances(PrintStream outps, Iterable<ServerInstanceLogRecordList> repResults) {
        boolean isZOS = false;
        ArrayList<DisplayInstance> unsortedInstances = new ArrayList<DisplayInstance>();
        Comparator<DisplayInstance> comparator = new Comparator<DisplayInstance>(){

            @Override
            public int compare(DisplayInstance serverList1, DisplayInstance serverList2) {
                long time2;
                long time1 = serverList1.getValue();
                if (time1 < (time2 = serverList2.getValue())) {
                    return -1;
                }
                if (time1 > time2) {
                    return 1;
                }
                return 0;
            }
        };
        char[] spacesAr = new char[72];
        for (int i = 0; i < spacesAr.length; ++i) {
            spacesAr[i] = 32;
        }
        this.spaces = new String(spacesAr);
        for (ServerInstanceLogRecordList list : repResults) {
            isZOS = "Y".equalsIgnoreCase(list.getHeader().getProperty("isZOS"));
            ArrayList<DisplayInstance> kidResult = new ArrayList<DisplayInstance>();
            long kidTimeStamp = this.collectAllKids(kidResult, list);
            if (kidTimeStamp <= 0L) continue;
            if (list.iterator().next() == null) {
                unsortedInstances.add(new DisplayInstance("", "", kidTimeStamp, kidResult));
                continue;
            }
            long timestamp = list.getStartTime().getTime();
            unsortedInstances.add(new DisplayInstance(Long.toString(timestamp), "", timestamp, kidResult));
        }
        this.printInstances(unsortedInstances, comparator, false, isZOS);
    }

    private void printInstances(ArrayList<DisplayInstance> unsorted, Comparator<DisplayInstance> comparator, boolean headerPrinted, boolean isZOS) {
        DisplayInstance[] sortedAr = unsorted.toArray(new DisplayInstance[unsorted.size()]);
        Arrays.sort(sortedAr, comparator);
        for (DisplayInstance displayInstance : sortedAr) {
            if (!headerPrinted) {
                System.out.println();
                if (isZOS) {
                    System.out.println(zOSHeader);
                } else {
                    System.out.println(distHeader);
                }
                headerPrinted = true;
            }
            String parentID = displayInstance.getParent();
            long timeStamp = displayInstance.getValue();
            String formattedTime = this.getFormattedDateTime(new Date(timeStamp));
            if (!"".equals(displayInstance.name)) {
                if (!"".equals(parentID)) {
                    this.printInstanceLine(parentID + "/" + displayInstance.name, formattedTime, isZOS);
                } else {
                    this.printInstanceLine(displayInstance.name, formattedTime, isZOS);
                }
            }
            this.printInstances(displayInstance.getKids(), comparator, headerPrinted, isZOS);
        }
    }

    private void printInstanceLine(String instanceId, String formattedTime, boolean isZOS) {
        int instanceSize = instanceId.length();
        int spacesNum = isZOS ? 72 - instanceSize : 30 - instanceSize;
        System.out.println(instanceId.toUpperCase() + this.spaces.substring(0, spacesNum - 1) + formattedTime);
    }

    private long collectAllKids(ArrayList<DisplayInstance> result, ServerInstanceLogRecordList list) {
        long timestamp = -1L;
        RepositoryLogRecord first = (RepositoryLogRecord)list.iterator().next();
        if (first != null) {
            timestamp = first.getMillis();
        }
        Iterator<Map.Entry<String, ServerInstanceLogRecordList>> iterator = list.getChildren().entrySet().iterator();
        while (iterator.hasNext()) {
            ArrayList<DisplayInstance> kidResult = new ArrayList<DisplayInstance>();
            Map.Entry<String, ServerInstanceLogRecordList> kid = iterator.next();
            long curTimestamp = this.collectAllKids(kidResult, kid.getValue());
            if (curTimestamp <= 0L) continue;
            result.add(new DisplayInstance(kid.getKey(), Long.toString(list.getStartTime().getTime()), curTimestamp, kidResult));
            if (timestamp >= curTimestamp) continue;
            timestamp = curTimestamp;
        }
        return timestamp;
    }

    private String getLatestKid(ServerInstanceLogRecordList list) {
        long timestamp = -1L;
        String lastKid = null;
        RepositoryLogRecord first = (RepositoryLogRecord)list.iterator().next();
        if (first != null) {
            timestamp = first.getMillis();
        }
        Iterator<Map.Entry<String, ServerInstanceLogRecordList>> iterator = list.getChildren().entrySet().iterator();
        while (iterator.hasNext()) {
            ArrayList<DisplayInstance> kidResult = new ArrayList<DisplayInstance>();
            Map.Entry<String, ServerInstanceLogRecordList> kid = iterator.next();
            long curTimestamp = this.collectAllKids(kidResult, kid.getValue());
            if (curTimestamp <= 0L || timestamp >= curTimestamp) continue;
            timestamp = curTimestamp;
            lastKid = kid.getKey();
        }
        return lastKid;
    }

    private void printHeader(Properties pidHeaderProps, PrintStream outps, boolean headerPrinted) {
        this.applyHeaderPropsToFormatter(this.theFormatter, pidHeaderProps);
        if (this.outputRepository == null) {
            if (this.hasFooter && headerPrinted) {
                outps.println(this.theFormatter.getFooter());
            }
            for (String headerLine : this.theFormatter.getHeader()) {
                outps.println(headerLine);
            }
        } else {
            this.outputRepository.storeHeader(pidHeaderProps);
        }
    }

    String getFormattedDateTime(Date dateTime) {
        return instanceDF.format(dateTime);
    }

    String getLevelString() {
        return this.levelString;
    }

    String getValidatedBinaryRepositoryDir() {
        return this.binaryRepositoryDir;
    }

    void setValidatedBinaryRepositoryDir(String validatedBinaryRepositoryDir) {
        this.binaryRepositoryDir = validatedBinaryRepositoryDir;
    }

    void setBinaryRepositoryDir(String binaryDir) throws IllegalArgumentException {
        File rd = new File(binaryDir);
        if (!RepositoryReaderImpl.containsLogFiles(rd)) {
            if (this.tailInterval > 0) {
                System.out.println(this.getLocalizedString_NO_FILES_FOUND_MONITOR());
            } else {
                throw new IllegalArgumentException(this.getLocalizedString_NO_FILES_FOUND());
            }
        }
        this.setValidatedBinaryRepositoryDir(rd.getAbsolutePath());
    }

    String getLocalizedString_NO_FILES_FOUND_MONITOR() {
        return LogViewer.getLocalizedString("CWTRA0020I");
    }

    String getLocalizedString_NO_FILES_FOUND() {
        return LogViewer.getLocalizedString("CWTRA0021E");
    }

    void setLocale(String localeString) {
        this.locale = new Locale(localeString);
    }

    void setDateFormat() {
        this.theFormatter.setDateFormat(this.locale, true);
    }

    private void setOutputLogFilename(String outputFilename) throws IllegalArgumentException {
        File theFile = new File(outputFilename).getAbsoluteFile();
        File theDir = theFile.getParentFile();
        if (theDir == null || !theDir.isDirectory() || !theDir.canWrite()) {
            throw new IllegalArgumentException(LogViewer.getLocalizedString("CWTRA0005E"), null);
        }
        this.outputLogFilename = theFile.getAbsolutePath();
    }

    Date getStartDate() {
        return this.startDate;
    }

    void setStartDate(String newStartDate) throws IllegalArgumentException {
        String sdfPattern = LogViewer.getLocalizedString("CWTRA0001I");
        if (newStartDate.contains(":")) {
            sdfPattern = LogViewer.getLocalizedString("CWTRA0003I");
        }
        SimpleDateFormat df = new SimpleDateFormat(sdfPattern);
        df.setLenient(false);
        try {
            this.startDate = df.parse(newStartDate);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(LogViewer.getLocalizedString("CWTRA0004E"), e);
        }
    }

    void setStartDate(Date date) {
        this.startDate = date;
    }

    Date getStopDate() {
        return this.stopDate;
    }

    void setStopDate(String newStopDate) throws IllegalArgumentException {
        String sdfPattern = LogViewer.getLocalizedString("CWTRA0001I");
        if (newStopDate.contains(":")) {
            sdfPattern = LogViewer.getLocalizedString("CWTRA0003I");
        }
        SimpleDateFormat df = new SimpleDateFormat(sdfPattern);
        df.setLenient(false);
        try {
            this.stopDate = df.parse(newStopDate);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(LogViewer.getLocalizedString("CWTRA0006E"), e);
        }
    }

    void setStopDate(Date date) {
        this.stopDate = date;
    }

    void setOutFormat(String outFormat) throws IllegalArgumentException {
        try {
            this.theFormatter = HpelFormatter.getFormatter(outFormat);
            this.hasFooter = "" != this.theFormatter.getFooter();
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(this.getLocalizedParmString_BAD_FORMAT(new Object[]{outFormat}), null);
        }
    }

    String getLocalizedParmString_BAD_FORMAT(Object[] parms) {
        return LogViewer.getLocalizedParmString("CWTRA0028E", parms);
    }

    void setEncoding(String encoding) throws IllegalArgumentException {
        if (!Charset.isSupported(encoding)) {
            throw new IllegalArgumentException(LogViewer.getLocalizedParmString("UnsupportedEncodingError", new Object[]{encoding}));
        }
        this.encoding = encoding;
    }

    void setLatestInstance(boolean latestInstance) {
        this.latestInstance = latestInstance;
    }

    Level getMinLevel() {
        return this.minLevel;
    }

    void setMinLevel(String minLevel) throws IllegalArgumentException {
        this.minLevel = this.createLevelByString(minLevel);
    }

    Level getMaxLevel() {
        return this.maxLevel;
    }

    void setMaxLevel(String maxLevel) throws IllegalArgumentException {
        this.maxLevel = this.createLevelByString(maxLevel);
        if (this.maxLevel == Level.ALL) {
            this.maxLevel = null;
        }
    }

    void setIncludeLoggers(String loggers) {
        this.includeLoggers = loggers;
    }

    void setExcludeLoggers(String loggers) {
        this.excludeLoggers = loggers;
    }

    void setHexThreadID(String hexString) throws IllegalArgumentException {
        try {
            Integer.parseInt(hexString, 16);
            this.hexThreadID = hexString;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(LogViewer.getLocalizedString("CWTRA0008E"), e);
        }
    }

    void setMessage(String message) throws IllegalArgumentException {
        this.message = message;
    }

    void setExcludeMessages(String messages) {
        this.excludeMessages = messages;
    }

    void setExtensions(String extensions) {
        this.extensions.clear();
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        try {
            for (int i = 0; i < extensions.length(); ++i) {
                if (extensions.charAt(i) != ',') continue;
                int count = 0;
                for (int index = i - 1; index > -1 && extensions.charAt(index) == '\\'; --index) {
                    ++count;
                }
                if (count % 2 == 0) continue;
                extensions = extensions.substring(0, i - 1) + "[comma]" + extensions.substring(i + 1);
                i += 5;
            }
            String[] extension = extensions.split(",");
            for (int i = 0; i < extension.length; ++i) {
                key.append(extension[i].substring(0, extension[i].indexOf(61)));
                value.append(extension[i].substring(extension[i].indexOf("=") + 1).replace("[comma]", "\\,"));
                this.extensions.add(new LogViewerFilter.Extension(key, value));
                key.setLength(0);
                value.setLength(0);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(" Invalid Extensions ", e);
        }
    }

    void setOutputRepository(HPELRepositoryExporter hpelRepositoryExporter) {
        this.outputRepository = hpelRepositoryExporter;
    }

    void setOutputRepositoryDir(String outputRepositoryDir) throws IllegalArgumentException {
        File theDir = new File(outputRepositoryDir);
        try {
            if (!theDir.exists()) {
                theDir.mkdirs();
            }
            if (!theDir.isDirectory() || !theDir.canWrite() || theDir.listFiles().length != 0) {
                throw new IllegalArgumentException(this.getLocalizedString_UNABLE_TO_COPY(), null);
            }
            this.setOutputRepository(new HPELRepositoryExporter(theDir));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(this.getLocalizedString_UNABLE_TO_COPY(), null);
        }
    }

    String getLocalizedString_UNABLE_TO_COPY() {
        return LogViewer.getLocalizedString("CWTRA0009E");
    }

    void setListInstances(boolean listInstances) {
        this.listInstances = listInstances;
    }

    int getTailInterval() {
        return this.tailInterval;
    }

    void setTailInterval(int tailInterval) {
        this.tailInterval = tailInterval;
    }

    private Level createLevelByString(String levelString) throws IllegalArgumentException {
        try {
            return Level.parse(levelString.toUpperCase());
        }
        catch (Exception npe) {
            throw new IllegalArgumentException(LogViewer.getLocalizedParmString("CWTRA0013E", new Object[]{levelString}));
        }
    }

    void setInstanceId(String instanceId) throws IllegalArgumentException {
        if (instanceId != null && !"".equals(instanceId)) {
            this.subInstanceId = this.getSubProcessInstanceId(instanceId);
            try {
                long id = this.getProcessInstanceId(instanceId);
                this.mainInstanceId = id < 0L ? null : new Date(id);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException(LogViewer.getLocalizedString("LVM_ERROR_INSTANCEID"), nfe);
            }
        }
    }

    private void applyHeaderPropsToFormatter(HpelFormatter formatter, Properties props) {
        formatter.setHeaderProps(props);
        if (props == null) {
            throw new IllegalArgumentException("Argument 'sysProps' cannot be null.");
        }
        String timeZoneID = props.getProperty("ServerTimeZone");
        try {
            formatter.setTimeZoneID(timeZoneID);
        }
        catch (IllegalArgumentException ex) {
            if (timeZoneID != null) {
                System.err.println(LogViewer.getLocalizedParmString("ErrorUsingHeaderTimeZone", new Object[]{timeZoneID}));
            }
            formatter.setTimeZoneID(TimeZone.getDefault().getID());
        }
    }

    boolean parseCmdLineArgs(String[] args) throws IllegalArgumentException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].toLowerCase().contains("help") || args[i].toLowerCase().contains("usage")) {
                this.printUsage();
                return true;
            }
            boolean accepted = false;
            for (Option option : this.options) {
                if (!args[i].equalsIgnoreCase(option.name)) continue;
                if (i + option.nargs < args.length) {
                    i += option.accept(args, i + 1);
                } else {
                    throw new IllegalArgumentException(LogViewer.getLocalizedParmString("CWTRA0022E", new Object[]{option.name, option.nargs}));
                }
                accepted = true;
                break;
            }
            if (accepted) continue;
            throw new IllegalArgumentException(LogViewer.getLocalizedParmString("CWTRA0023E", new Object[]{args[i]}));
        }
        return false;
    }

    boolean validateSettings() throws IllegalArgumentException {
        if (this.startDate != null && this.stopDate != null && this.startDate.after(this.stopDate)) {
            throw new IllegalArgumentException(LogViewer.getLocalizedString("CWTRA0026E"));
        }
        if (this.maxLevel != null && this.minLevel != null && this.minLevel.intValue() > this.maxLevel.intValue()) {
            throw new IllegalArgumentException(LogViewer.getLocalizedString("CWTRA0027E"));
        }
        if (this.binaryRepositoryDir == null) {
            File[] servers = this.listRepositoryChoices();
            File repositoryDirFile = null;
            if (servers.length > 1) {
                System.out.println(LogViewer.getLocalizedString("LVM_SelectServerPrompt"));
                int i = 0;
                for (File s : servers) {
                    System.out.println(++i + ") " + this.getLogDirName(s));
                }
                String serverNum = null;
                int serverNumInt = 0;
                BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
                while (repositoryDirFile == null) {
                    System.out.print("[1-" + i + "]: ");
                    try {
                        serverNum = input.readLine();
                        serverNumInt = Integer.parseInt(serverNum);
                        if (serverNumInt < 1 || serverNumInt > i) continue;
                        repositoryDirFile = servers[serverNumInt - 1];
                    }
                    catch (NumberFormatException s) {
                    }
                    catch (IOException e) {
                        return true;
                    }
                }
            } else if (servers.length == 1) {
                repositoryDirFile = servers[0];
            }
            if (repositoryDirFile != null) {
                try {
                    this.setBinaryRepositoryDir(repositoryDirFile.getCanonicalPath());
                    System.out.println(LogViewer.getLocalizedParmString("CWTRA0030I", new Object[]{this.binaryRepositoryDir}));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.binaryRepositoryDir == null) {
                throw new IllegalArgumentException(LogViewer.getLocalizedString("CWTRA0024E"));
            }
        }
        return false;
    }

    protected File[] listRepositoryChoices() {
        File logDir;
        String currentDir = System.getProperty("log.repository.root");
        if (currentDir == null) {
            currentDir = System.getProperty("user.dir");
        }
        if ((logDir = new File(currentDir)).isDirectory()) {
            File[] result = RepositoryReaderImpl.listRepositories(logDir);
            if (result.length == 0 && (RepositoryReaderImpl.containsLogFiles(logDir) || this.tailInterval > 0)) {
                return new File[]{logDir};
            }
            return result;
        }
        return new File[0];
    }

    protected String getLogDirName(File repository) {
        return repository.getName();
    }

    private void printUsage() {
        String WINDOWS_SAMPLE_PATH = "C:\\temp\\newRepository";
        String UNIX_SAMPLE_PATH = "/tmp/newRepository";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df1 = new SimpleDateFormat(LogViewer.getLocalizedString("CWTRA0001I"));
        SimpleDateFormat df2 = new SimpleDateFormat(LogViewer.getLocalizedString("CWTRA0003I"));
        SimpleDateFormat df3 = new SimpleDateFormat(LogViewer.getLocalizedString("CWTRA0002I"));
        calendar.set(2009, 0, 30);
        Date date = calendar.getTime();
        String fStartDate1 = df1.format(date);
        calendar.set(2009, 0, 30, 4, 0, 0);
        calendar.set(14, 100);
        date = calendar.getTime();
        String fStartDate2 = df2.format(date);
        calendar.set(2009, 4, 28);
        date = calendar.getTime();
        String fStopDate1 = df1.format(date);
        calendar.set(2009, 4, 28, 14, 32, 9);
        calendar.set(14, 100);
        date = calendar.getTime();
        String fStopDate2 = df2.format(date);
        calendar.set(2010, 3, 27, 1, 30, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        String fBeginDate3 = df3.format(date);
        String fStartDate3 = df2.format(date);
        calendar.set(2010, 3, 27, 1, 35, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        String fEndDate3 = df3.format(date);
        String fStopDate3 = df2.format(date);
        String uDesc = LogViewer.getLocalizedString("CWTRA0031I");
        String uUsage = LogViewer.getLocalizedString("CWTRA0033I");
        StringBuilder uOptions = new StringBuilder(300);
        uOptions.append(LogViewer.getLocalizedString("CWTRA0034I"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("CWTRA0035I") + "\n\n" + LogViewer.getLocalizedString("CWTRA0036I"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("CWTRA0037I") + "\n\n" + LogViewer.getLocalizedParmString("CWTRA0038I", new Object[]{LogViewer.getLocalizedString("CWTRA0074I"), LogViewer.getLocalizedString("CWTRA0075I")}));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedParmString("CWTRA0039I", new Object[]{fStartDate1, fStartDate2}));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("CWTRA0040I") + "\n\n" + LogViewer.getLocalizedParmString("CWTRA0041I", new Object[]{LogViewer.getLocalizedString("CWTRA0074I"), LogViewer.getLocalizedString("CWTRA0075I")}));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedParmString("CWTRA0042I", new Object[]{fStopDate1, fStopDate2}));
        uOptions.append("\n\n");
        uOptions.append("-level ").append(this.levelString).append("\n\n").append(LogViewer.getLocalizedString("CWTRA0044I"));
        uOptions.append("\n\n");
        uOptions.append("-minLevel ").append(this.levelString).append("\n\n").append(LogViewer.getLocalizedString("CWTRA0046I"));
        uOptions.append("\n\n");
        uOptions.append("-maxLevel ").append(this.levelString).append("\n\n").append(LogViewer.getLocalizedString("CWTRA0048I"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("CWTRA0049I") + "\n\n" + LogViewer.getLocalizedString("CWTRA0050I"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("CWTRA0053I") + "\n\n" + LogViewer.getLocalizedString("CWTRA0052I"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("CWTRA0055I") + "\n\n" + LogViewer.getLocalizedString("CWTRA0056I"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("CWTRA0057I"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("CWTRA0058I") + "\n\n" + LogViewer.getLocalizedString("CWTRA0059I"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("CWTRA0060I"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("CWTRA0061I") + "\n\n" + LogViewer.getLocalizedString("CWTRA0062I"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("CWTRA0065I") + "\n\n" + LogViewer.getLocalizedString("CWTRA0066I"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("CWTRA0067I") + "\n\n" + LogViewer.getLocalizedString("CWTRA0068I"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("CWTRA0069I") + "\n\n" + LogViewer.getLocalizedString("CWTRA0070I"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("LVM_HELP_LATESTINSTANCE") + "\n\n" + LogViewer.getLocalizedString("LVM_HELP_LATESTINSTANCE_DESCR"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("LVM_HELP_MESSAGE") + "\n\n" + LogViewer.getLocalizedString("LVM_HELP_MESSAGE_DESCR"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("LVM_HELP_EXTENSIONS") + "\n\n" + LogViewer.getLocalizedString("LVM_HELP_EXTENSIONS_DESCR"));
        uOptions.append("\n\n");
        uOptions.append(LogViewer.getLocalizedString("LVM_HELP_ENCODING") + "\n\n" + LogViewer.getLocalizedString("LVM_HELP_ENCODING_DESCR"));
        System.out.println(uDesc + "\n\n");
        System.out.println(uUsage + "\n\n");
        System.out.println(uOptions + "\n\n");
        System.out.println(LogViewer.getLocalizedString("LVM_HELP_SAMPLES_INTRO") + "\n\n");
        System.out.println(LogViewer.getLocalizedString("LVM_HELP_SAMPLE1") + "\n\n");
        System.out.println(LogViewer.getLocalizedString("LVM_HELP_SAMPLE4") + "\n\n");
        System.out.println(LogViewer.getLocalizedParmString("LVM_HELP_SAMPLE2", new Object[]{fBeginDate3, fEndDate3, fStartDate3, fStopDate3}) + "\n\n");
        if (File.separator.equals("/")) {
            System.out.println(LogViewer.getLocalizedParmString("LVM_HELP_SAMPLE3", new Object[]{fBeginDate3, UNIX_SAMPLE_PATH, fStartDate3}));
        } else {
            System.out.println(LogViewer.getLocalizedParmString("LVM_HELP_SAMPLE3", new Object[]{fBeginDate3, WINDOWS_SAMPLE_PATH, fStartDate3}));
        }
    }

    private PrintStream createOutputStream() {
        if (this.outputLogFilename != null) {
            try {
                FileOutputStream fout = new FileOutputStream(this.outputLogFilename, false);
                BufferedOutputStream bos = new BufferedOutputStream(fout, 4096);
                if (this.encoding != null) {
                    return new PrintStream((OutputStream)bos, false, this.encoding);
                }
                return new PrintStream(bos, false);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(LogViewer.getLocalizedString("CWTRA0005E"));
            }
        }
        this.isSystemOut = true;
        if (this.encoding != null) {
            try {
                return new PrintStream((OutputStream)System.out, false, this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return System.out;
    }

    private static String getLocalizedString(String key) {
        return LogViewer.getLocalizedString(BUNDLE_NAME, key);
    }

    static String getLocalizedString(String bundleName, String key) {
        try {
            return Messages.getStringFromBundle(bundleName, key, null, key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    private static String getLocalizedParmString(String key, Object[] parms) {
        return LogViewer.getLocalizedParmString(BUNDLE_NAME, key, parms);
    }

    static String getLocalizedParmString(String bundleName, String key, Object[] parms) {
        return MessageFormat.format(LogViewer.getLocalizedString(bundleName, key), parms);
    }

    public String toString() {
        return "latestInstance=" + Boolean.toString(this.latestInstance) + ", minLevel=" + (this.minLevel != null ? this.minLevel.toString() : "null") + ", maxLevel=" + (this.maxLevel != null ? this.maxLevel.toString() : "null") + ", startDate=" + (this.startDate != null ? dateFormat.format(this.startDate) : "null") + ", stopDate=" + (this.stopDate != null ? dateFormat.format(this.stopDate) : "null") + ", includeLoggers=" + this.includeLoggers + ", excludeLoggers=" + this.excludeLoggers + ", hexThreadID=" + this.hexThreadID + ", tailInterval=" + Integer.toString(this.tailInterval) + ", locale=" + (this.locale != null ? this.locale.toString() : "null") + ", message=" + this.message + ", excludeMessages=" + this.excludeMessages + ", extensions=" + (this.extensions != null ? this.extensions.toString() : "null") + ", encoding=" + this.encoding;
    }

    private class TailOption
    extends Option {
        TailOption(String name) {
            super(name, 0);
        }

        @Override
        int accept(String[] args, int i) throws IllegalArgumentException {
            LogViewer.this.tailInterval = 5;
            if (i < args.length && !args[i].startsWith(LogViewer.OPTION_DELIMITER)) {
                try {
                    LogViewer.this.tailInterval = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(LogViewer.getLocalizedParmString("CWTRA0019E", new Object[]{this.name.substring(1), args[i]}));
                }
                return 1;
            }
            return 0;
        }
    }

    private static abstract class NoArgOption
    extends Option {
        NoArgOption(String name) {
            super(name, 0);
        }

        @Override
        int accept(String[] args, int i) throws IllegalArgumentException {
            this.enableOption();
            return 0;
        }

        abstract void enableOption();
    }

    private static abstract class OneArgOption
    extends Option {
        OneArgOption(String name) {
            super(name, 1);
        }

        @Override
        int accept(String[] args, int i) throws IllegalArgumentException {
            this.setValue(args[i]);
            return 1;
        }

        abstract void setValue(String var1) throws IllegalArgumentException;
    }

    private static abstract class Option {
        final String name;
        final int nargs;

        Option(String name, int nargs) {
            this.name = name;
            this.nargs = nargs;
        }

        abstract int accept(String[] var1, int var2) throws IllegalArgumentException;
    }

    private static final class DisplayInstance {
        final String parent;
        final String name;
        final long value;
        final ArrayList<DisplayInstance> kids;

        DisplayInstance(String name, String parent, long value, ArrayList<DisplayInstance> kids) {
            this.name = name;
            this.parent = parent;
            this.value = value;
            this.kids = kids;
        }

        public long getValue() {
            return this.value;
        }

        public String getParent() {
            return this.parent;
        }

        public ArrayList<DisplayInstance> getKids() {
            return this.kids;
        }
    }

    private static class LocalMergedRepository
    implements Iterable<RepositoryLogRecord> {
        final Iterator<RepositoryLogRecord> logIt;
        final Iterator<RepositoryLogRecord> traceIt;
        RepositoryLogRecordImpl nextLog;
        RepositoryLogRecordImpl nextTrace;
        boolean returnLog = false;
        Iterator<RepositoryLogRecord> it = null;

        LocalMergedRepository(ServerInstanceLogRecordList logList, ServerInstanceLogRecordList traceList) {
            this.logIt = logList.iterator();
            this.traceIt = traceList.iterator();
            this.nextLog = (RepositoryLogRecordImpl)this.logIt.next();
            this.nextTrace = (RepositoryLogRecordImpl)this.traceIt.next();
        }

        boolean isLastLog() {
            return this.returnLog;
        }

        @Override
        public Iterator<RepositoryLogRecord> iterator() {
            if (this.it != null) {
                throw new UnsupportedOperationException("Creating second iterator on LocalMergeRepository is not supported.");
            }
            this.it = new Iterator<RepositoryLogRecord>(){

                @Override
                public boolean hasNext() {
                    return nextLog != null || nextTrace != null;
                }

                @Override
                public RepositoryLogRecord next() {
                    if (nextLog == null && nextTrace == null) {
                        return null;
                    }
                    returnLog = nextLog == null ? false : (nextTrace == null ? true : nextLog.getInternalSeqNumber() < nextTrace.getInternalSeqNumber());
                    RepositoryLogRecordImpl result = null;
                    if (returnLog) {
                        result = nextLog;
                        nextLog = (RepositoryLogRecordImpl)logIt.next();
                    } else {
                        result = nextTrace;
                        nextTrace = (RepositoryLogRecordImpl)traceIt.next();
                    }
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return this.it;
        }
    }

    public static class LevelDetails {
        final int intValue;
        final String id;
        final String resourceBundleName;

        public LevelDetails(int intValue, String id, String resourceBundleName) {
            this.intValue = intValue;
            this.id = id;
            this.resourceBundleName = resourceBundleName;
        }
    }
}

